/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.split;

import cn.orionsec.kit.office.excel.Excels;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

class ExcelColumnSplitSupport {
    ExcelColumnSplitSupport() {
    }

    protected static void split(Sheet sourceSheet, Workbook targetWorkbook, Sheet targetSheet, int[] columns, String[] headers, int skip, boolean streaming) {
        int index = 0;
        int rowIndex = 0;
        if (!streaming) {
            targetSheet.setDefaultColumnWidth(sourceSheet.getDefaultColumnWidth());
            targetSheet.setDefaultRowHeightInPoints(sourceSheet.getDefaultRowHeightInPoints());
            for (Object column : (Object)columns) {
                targetSheet.setColumnWidth((int)column, sourceSheet.getColumnWidth((int)column));
                targetSheet.setDefaultColumnStyle((int)column, sourceSheet.getColumnStyle((int)column));
            }
        }
        if (headers != null) {
            Row headerRow = targetSheet.createRow(rowIndex++);
            for (int headerIndex = 0; headerIndex < headers.length; ++headerIndex) {
                Cell headerCell = headerRow.createCell(headerIndex);
                headerCell.setCellValue(headers[headerIndex]);
            }
        }
        for (Row sourceRow : sourceSheet) {
            if (index++ < skip) continue;
            int cellIndex = 0;
            Row targetRow = targetSheet.createRow(rowIndex++);
            for (int column : columns) {
                Cell targetCell = targetRow.createCell(cellIndex++);
                Cell sourceCell = sourceRow.getCell(column);
                Excels.copyCellValue(sourceCell, targetCell);
                if (streaming) continue;
                CellStyle targetStyle = targetWorkbook.createCellStyle();
                targetStyle.cloneStyleFrom(sourceCell.getCellStyle());
                targetCell.setCellStyle(targetStyle);
            }
        }
    }
}

