/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.split;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.split.ExcelColumnSplitSupport;
import java.io.File;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelColumnMultiSplit
implements SafeCloseable {
    private final Workbook sourceWorkbook;
    private Sheet sourceSheet;
    private int skip;

    public ExcelColumnMultiSplit(Workbook sourceWorkbook, int sourceSheetIndex) {
        this(sourceWorkbook);
        Valid.gte((Comparable)Integer.valueOf(sourceSheetIndex), (Comparable)Integer.valueOf(0), (String)"split sheet index must >= 0", (Object[])new Object[0]);
        this.sourceSheet = sourceWorkbook.getSheetAt(sourceSheetIndex);
    }

    public ExcelColumnMultiSplit(Workbook sourceWorkbook, String sourceSheetName) {
        this(sourceWorkbook);
        Valid.notBlank((String)sourceSheetName, (String)"split sheet name is null", (Object[])new Object[0]);
        this.sourceSheet = sourceWorkbook.getSheet(sourceSheetName);
    }

    public ExcelColumnMultiSplit(Workbook sourceWorkbook, Sheet sourceSheet) {
        this(sourceWorkbook);
        this.sourceSheet = (Sheet)Valid.notNull((Object)sourceSheet, (String)"split sheet is null", (Object[])new Object[0]);
    }

    private ExcelColumnMultiSplit(Workbook sourceWorkbook) {
        this.sourceWorkbook = (Workbook)Valid.notNull((Object)sourceWorkbook, (String)"split workbook is null", (Object[])new Object[0]);
        Valid.isTrue((!Excels.isStreamingWorkbook(sourceWorkbook) ? 1 : 0) != 0, (String)"unsupported streaming reading, please use ExcelColumnSingleSplit", (Object[])new Object[0]);
    }

    public ExcelColumnMultiSplit skip() {
        ++this.skip;
        return this;
    }

    public ExcelColumnMultiSplit skip(int skip) {
        this.skip += skip;
        return this;
    }

    public ExcelColumnMultiSplit split(int[] columns, File file) {
        return this.split(columns, null, null, Files1.openOutputStreamSafe((File)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, File file) {
        return this.split(columns, headers, null, Files1.openOutputStreamSafe((File)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String password, File file) {
        return this.split(columns, null, password, Files1.openOutputStreamSafe((File)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, String password, File file) {
        return this.split(columns, headers, password, Files1.openOutputStreamSafe((File)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String file) {
        return this.split(columns, null, null, Files1.openOutputStreamSafe((String)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, String file) {
        return this.split(columns, headers, null, Files1.openOutputStreamSafe((String)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String password, String file) {
        return this.split(columns, null, password, Files1.openOutputStreamSafe((String)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, String password, String file) {
        return this.split(columns, headers, password, Files1.openOutputStreamSafe((String)file), true);
    }

    public ExcelColumnMultiSplit split(int[] columns, OutputStream out) {
        return this.split(columns, null, null, out, false);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, OutputStream out) {
        return this.split(columns, headers, null, out, false);
    }

    public ExcelColumnMultiSplit split(int[] columns, String password, OutputStream out) {
        return this.split(columns, null, password, out, false);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, String password, OutputStream out) {
        return this.split(columns, headers, password, out, false);
    }

    public ExcelColumnMultiSplit split(int[] columns, String[] headers, String password, OutputStream out, boolean close) {
        Valid.notNull((Object)out, (String)"dest stream is null", (Object[])new Object[0]);
        SXSSFWorkbook targetWorkbook = new SXSSFWorkbook();
        Sheet targetSheet = targetWorkbook.createSheet(this.sourceSheet.getSheetName());
        ExcelColumnSplitSupport.split(this.sourceSheet, (Workbook)targetWorkbook, targetSheet, columns, headers, this.skip, false);
        if (!Strings.isBlank((String)password)) {
            targetSheet.protectSheet(password);
        }
        Excels.setDefaultProperties((Workbook)targetWorkbook);
        Excels.write((Workbook)targetWorkbook, out);
        Streams.close((AutoCloseable)targetWorkbook);
        if (close) {
            Streams.close((AutoCloseable)out);
        }
        return this;
    }

    public void close() {
        Streams.close((AutoCloseable)this.sourceWorkbook);
    }

    public Workbook getSourceWorkbook() {
        return this.sourceWorkbook;
    }

    public Sheet getSourceSheet() {
        return this.sourceSheet;
    }
}

