/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.reader;

import cn.orionsec.kit.lang.define.collect.MutableHashMap;
import cn.orionsec.kit.lang.define.collect.MutableLinkedHashMap;
import cn.orionsec.kit.lang.define.collect.MutableMap;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.option.ImportFieldOption;
import cn.orionsec.kit.office.excel.reader.BaseExcelReader;
import cn.orionsec.kit.office.excel.type.ExcelReadType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelMapReader<K, V>
extends BaseExcelReader<K, MutableMap<K, V>> {
    private final Map<K, V> defaultValue;
    private boolean nullPutKey;
    private boolean linked;

    public ExcelMapReader(Workbook workbook, Sheet sheet) {
        this(workbook, sheet, (List<MutableMap<K, V>>)new ArrayList<MutableMap<K, V>>(), (Consumer<MutableMap<K, V>>)null);
    }

    public ExcelMapReader(Workbook workbook, Sheet sheet, List<MutableMap<K, V>> store) {
        this(workbook, sheet, store, (Consumer<MutableMap<K, V>>)null);
    }

    public ExcelMapReader(Workbook workbook, Sheet sheet, Consumer<MutableMap<K, V>> consumer) {
        this(workbook, sheet, (List<MutableMap<K, V>>)null, consumer);
    }

    private ExcelMapReader(Workbook workbook, Sheet sheet, List<MutableMap<K, V>> store, Consumer<MutableMap<K, V>> consumer) {
        super(workbook, sheet, store, consumer);
        this.init = false;
        this.nullPutKey = true;
        this.options = new HashMap();
        this.defaultValue = new HashMap();
    }

    public static <K, V> ExcelMapReader<K, V> create(Workbook workbook, Sheet sheet) {
        return new ExcelMapReader<K, V>(workbook, sheet);
    }

    public static <K, V> ExcelMapReader<K, V> create(Workbook workbook, Sheet sheet, List<MutableMap<K, V>> store) {
        return new ExcelMapReader<K, V>(workbook, sheet, store);
    }

    public static <K, V> ExcelMapReader<K, V> create(Workbook workbook, Sheet sheet, Consumer<MutableMap<K, V>> consumer) {
        return new ExcelMapReader<K, V>(workbook, sheet, consumer);
    }

    public ExcelMapReader<K, V> option(K key, ImportFieldOption option) {
        this.addOption(key, option, null);
        return this;
    }

    public ExcelMapReader<K, V> option(K key, ImportFieldOption option, V defaultValue) {
        this.addOption(key, option, defaultValue);
        return this;
    }

    public ExcelMapReader<K, V> option(int column, K key, ExcelReadType type) {
        this.addOption(key, new ImportFieldOption(column, type), null);
        return this;
    }

    public ExcelMapReader<K, V> option(int column, K key, ExcelReadType type, V defaultValue) {
        this.addOption(key, new ImportFieldOption(column, type), defaultValue);
        return this;
    }

    protected void addOption(K key, ImportFieldOption option, V defaultValue) {
        super.addOption(key, option);
        if (defaultValue != null) {
            this.defaultValue.put(key, defaultValue);
        }
    }

    public ExcelMapReader<K, V> defaultValue(K key, V value) {
        this.defaultValue.put(key, value);
        return this;
    }

    public ExcelMapReader<K, V> linked() {
        this.linked = true;
        this.options = new LinkedHashMap(this.options);
        return this;
    }

    public ExcelMapReader<K, V> nullPutKey(boolean nullPutKey) {
        this.nullPutKey = nullPutKey;
        return this;
    }

    @Override
    protected MutableMap<K, V> parserRow(Row row) {
        if (row == null) {
            return null;
        }
        Object map = this.linked ? new MutableLinkedHashMap() : new MutableHashMap();
        this.options.forEach((arg_0, arg_1) -> this.lambda$parserRow$0(row, (MutableMap)map, arg_0, arg_1));
        return map;
    }

    private /* synthetic */ void lambda$parserRow$0(Row row, MutableMap map, Object key, ImportFieldOption option) {
        int column = option.getIndex();
        Cell cell = row.getCell(column);
        ExcelReadType type = option.getType();
        Object value = null;
        if (cell != null) {
            value = type.equals((Object)ExcelReadType.PICTURE) ? this.getPicture(column, row) : (Object)Excels.getCellValue(cell, type, option.getCellOption());
        }
        if (value == null) {
            V defaultValue = this.defaultValue.get(key);
            if (defaultValue != null || this.nullPutKey) {
                map.put(key, defaultValue);
            } else {
                map.put(key, null);
            }
        } else {
            if (this.trim && value instanceof String) {
                value = ((String)value).trim();
            }
            map.put(key, value);
        }
    }
}

