/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.reader;

import cn.orionsec.kit.lang.define.wrapper.Pair;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.option.ImportFieldOption;
import cn.orionsec.kit.office.excel.reader.BaseExcelReader;
import cn.orionsec.kit.office.excel.type.ExcelReadType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelLambdaReader<T>
extends BaseExcelReader<Pair<Function<?, ?>, BiConsumer<T, ?>>, T> {
    protected Map<Integer, Pair<Function<?, ?>, BiConsumer<T, ?>>> mapping;
    protected Supplier<T> supplier;
    protected boolean nullInvoke;
    private boolean nullAddEmptyBean;

    public ExcelLambdaReader(Workbook workbook, Sheet sheet, Supplier<T> supplier) {
        this(workbook, sheet, new ArrayList(), null, supplier);
    }

    public ExcelLambdaReader(Workbook workbook, Sheet sheet, List<T> store, Supplier<T> supplier) {
        this(workbook, sheet, store, null, supplier);
    }

    public ExcelLambdaReader(Workbook workbook, Sheet sheet, Consumer<T> consumer, Supplier<T> supplier) {
        this(workbook, sheet, null, consumer, supplier);
    }

    protected ExcelLambdaReader(Workbook workbook, Sheet sheet, List<T> store, Consumer<T> consumer, Supplier<T> supplier) {
        super(workbook, sheet, store, consumer);
        this.supplier = (Supplier)Valid.notNull(supplier, (String)"supplier is null", (Object[])new Object[0]);
        this.options = new HashMap();
        this.init = false;
    }

    public static <T> ExcelLambdaReader<T> create(Workbook workbook, Sheet sheet, Supplier<T> supplier) {
        return new ExcelLambdaReader<T>(workbook, sheet, supplier);
    }

    public static <T> ExcelLambdaReader<T> create(Workbook workbook, Sheet sheet, List<T> store, Supplier<T> supplier) {
        return new ExcelLambdaReader<T>(workbook, sheet, store, supplier);
    }

    public static <T> ExcelLambdaReader<T> create(Workbook workbook, Sheet sheet, Consumer<T> consumer, Supplier<T> supplier) {
        return new ExcelLambdaReader<T>(workbook, sheet, consumer, supplier);
    }

    public ExcelLambdaReader<T> nullInvoke() {
        this.nullInvoke = true;
        return this;
    }

    public ExcelLambdaReader<T> nullAddEmptyBean() {
        this.nullAddEmptyBean = true;
        return this;
    }

    public <V> ExcelLambdaReader<T> option(int column, ExcelReadType type, BiConsumer<T, V> consumer) {
        super.addOption(Pair.of(Function.identity(), consumer), new ImportFieldOption(column, type));
        return this;
    }

    public <E, V> ExcelLambdaReader<T> option(int column, ExcelReadType type, Function<E, V> convert, BiConsumer<T, V> consumer) {
        super.addOption(Pair.of(convert, consumer), new ImportFieldOption(column, type));
        return this;
    }

    public <V> ExcelLambdaReader<T> option(ImportFieldOption option, BiConsumer<T, V> consumer) {
        super.addOption(Pair.of(Function.identity(), consumer), option);
        return this;
    }

    public <E, V> ExcelLambdaReader<T> option(ImportFieldOption option, Function<E, V> convert, BiConsumer<T, V> consumer) {
        super.addOption(Pair.of(convert, consumer), option);
        return this;
    }

    @Override
    protected T parserRow(Row row) {
        if (row == null) {
            if (this.nullAddEmptyBean) {
                return this.supplier.get();
            }
            return null;
        }
        T current = this.supplier.get();
        this.options.forEach((? super K pair, ? super V option) -> {
            int index = option.getIndex();
            Cell cell = row.getCell(index);
            Object value = option.getType().equals((Object)ExcelReadType.PICTURE) ? super.getPicture(index, row) : (Object)Excels.getCellValue(cell, option.getType(), option.getCellOption());
            if (value != null || this.nullInvoke) {
                if (this.trim && value instanceof String) {
                    value = ((String)value).trim();
                }
                Function convert = (Function)pair.getKey();
                BiConsumer consumer = (BiConsumer)pair.getValue();
                Object val = convert.apply(value);
                consumer.accept(current, val);
            }
        });
        return current;
    }
}

