/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.reader;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.codec.Base64s;
import cn.orionsec.kit.lang.utils.reflect.Annotations;
import cn.orionsec.kit.lang.utils.reflect.Constructors;
import cn.orionsec.kit.lang.utils.reflect.Fields;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import cn.orionsec.kit.office.excel.Excels;
import cn.orionsec.kit.office.excel.annotation.ImportField;
import cn.orionsec.kit.office.excel.annotation.ImportIgnore;
import cn.orionsec.kit.office.excel.option.CellOption;
import cn.orionsec.kit.office.excel.option.ImportFieldOption;
import cn.orionsec.kit.office.excel.reader.BaseExcelReader;
import cn.orionsec.kit.office.excel.type.ExcelReadType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBeanReader<T>
extends BaseExcelReader<String, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelBeanReader.class);
    private final Class<T> targetClass;
    private final Constructor<T> constructor;
    private final Map<String, Method> setters;
    private boolean nullInvoke;
    private boolean nullAddEmptyBean;

    public ExcelBeanReader(Workbook workbook, Sheet sheet, Class<T> targetClass) {
        this(workbook, sheet, targetClass, new ArrayList(), null);
    }

    public ExcelBeanReader(Workbook workbook, Sheet sheet, Class<T> targetClass, List<T> store) {
        this(workbook, sheet, targetClass, store, null);
    }

    public ExcelBeanReader(Workbook workbook, Sheet sheet, Class<T> targetClass, Consumer<T> consumer) {
        this(workbook, sheet, targetClass, null, consumer);
    }

    protected ExcelBeanReader(Workbook workbook, Sheet sheet, Class<T> targetClass, List<T> rows, Consumer<T> consumer) {
        super(workbook, sheet, rows, consumer);
        this.targetClass = (Class)Valid.notNull(targetClass, (String)"target class is null", (Object[])new Object[0]);
        this.constructor = (Constructor)Valid.notNull((Object)Constructors.getDefaultConstructor(targetClass), (String)"target class not found default constructor", (Object[])new Object[0]);
        this.setters = new HashMap<String, Method>();
        this.options = new HashMap();
        this.analysisField();
        this.init = false;
    }

    public static <T> ExcelBeanReader<T> create(Workbook workbook, Sheet sheet, Class<T> targetClass) {
        return new ExcelBeanReader<T>(workbook, sheet, targetClass);
    }

    public static <T> ExcelBeanReader<T> create(Workbook workbook, Sheet sheet, Class<T> targetClass, List<T> rows) {
        return new ExcelBeanReader<T>(workbook, sheet, targetClass, rows);
    }

    public static <T> ExcelBeanReader<T> create(Workbook workbook, Sheet sheet, Class<T> targetClass, Consumer<T> consumer) {
        return new ExcelBeanReader<T>(workbook, sheet, targetClass, consumer);
    }

    public ExcelBeanReader<T> nullInvoke() {
        this.nullInvoke = true;
        return this;
    }

    public ExcelBeanReader<T> nullAddEmptyBean() {
        this.nullAddEmptyBean = true;
        return this;
    }

    public ExcelBeanReader<T> option(String field, ImportFieldOption option) {
        this.addOption(field, option);
        return this;
    }

    public ExcelBeanReader<T> option(int column, String field, ExcelReadType type) {
        this.addOption(field, new ImportFieldOption(column, type));
        return this;
    }

    @Override
    protected void addOption(String field, ImportFieldOption option) {
        Valid.notNull((Object)option, (String)"field option is null", (Object[])new Object[0]);
        Valid.notNull((Object)this.setters.get(field), (String)"not found setter method ({}) in {}", (Object[])new Object[]{field, this.targetClass});
        super.addOption(field, option);
    }

    @Override
    protected T parserRow(Row row) {
        if (row == null) {
            if (this.nullAddEmptyBean) {
                return (T)Constructors.newInstance(this.constructor);
            }
            return null;
        }
        Object t = Constructors.newInstance(this.constructor);
        this.options.forEach((? super K field, ? super V option) -> {
            Method setter = this.setters.get(field);
            int index = option.getIndex();
            Cell cell = row.getCell(index);
            Object value = option.getType().equals((Object)ExcelReadType.PICTURE) ? this.getPicture(setter, row.getRowNum(), index) : Excels.getCellValue(cell, option.getType(), option.getCellOption());
            if (value != null) {
                if (this.trim && value instanceof String) {
                    value = ((String)value).trim();
                }
                try {
                    Methods.invokeSetterInfer((Object)t, (Method)setter, (Object)value);
                }
                catch (Exception e) {
                    LOGGER.error("ExcelBeanReader.parserRow error", (Throwable)e);
                }
            } else if (this.nullInvoke) {
                Methods.invokeMethod((Object)t, (Method)setter, (Object[])new Object[]{null});
            }
        });
        return (T)t;
    }

    private Object getPicture(Method setter, int row, int col) {
        if (this.pictureParser == null) {
            return null;
        }
        PictureData picture = this.pictureParser.getPicture(row, col);
        if (picture == null) {
            return null;
        }
        Class<?> parameterType = setter.getParameterTypes()[0];
        if (parameterType == String.class) {
            return Base64s.imgEncode((byte[])picture.getData(), (String)picture.getMimeType());
        }
        if (parameterType == byte[].class) {
            return picture.getData();
        }
        if (parameterType == OutputStream.class || parameterType == ByteArrayOutputStream.class) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(picture.getData());
            }
            catch (Exception e) {
                throw Exceptions.ioRuntime((Throwable)e);
            }
            return out;
        }
        return null;
    }

    private void analysisField() {
        List setterMethodList = Methods.getSetterMethodsByCache(this.targetClass);
        List fieldList = Fields.getFieldsByCache(this.targetClass);
        for (Field field : fieldList) {
            this.analysisColumn((ImportField)Annotations.getAnnotation((Field)field, ImportField.class), (ImportIgnore)Annotations.getAnnotation((Field)field, ImportIgnore.class), Methods.getSetterMethodByField(this.targetClass, (Field)field), field.getName());
        }
        for (Method method : setterMethodList) {
            String fieldName = Fields.getFieldNameByMethod((Method)method);
            this.setters.put(fieldName, method);
            this.analysisColumn((ImportField)Annotations.getAnnotation((Method)method, ImportField.class), (ImportIgnore)Annotations.getAnnotation((Method)method, ImportIgnore.class), method, fieldName);
        }
    }

    private void analysisColumn(ImportField field, ImportIgnore ignore, Method method, String fieldName) {
        if (field == null || ignore != null) {
            return;
        }
        ImportFieldOption option = new ImportFieldOption();
        option.setIndex(field.index());
        option.setType(field.type());
        String parseFormat = field.parseFormat();
        if (!Strings.isEmpty((CharSequence)parseFormat)) {
            option.setCellOption(new CellOption(parseFormat));
        }
        this.analysisColumn(option, fieldName, method);
    }

    private void analysisColumn(ImportFieldOption option, String fieldName, Method method) {
        Valid.notNull((Object)option, (String)"option is null", (Object[])new Object[0]);
        Valid.notNull((Object)method, (String)(fieldName + " setter method not found from " + this.targetClass), (Object[])new Object[0]);
        Valid.gte((Comparable)Integer.valueOf(option.getIndex()), (Comparable)Integer.valueOf(0), (String)"index must >= 0", (Object[])new Object[0]);
        ExcelReadType type = (ExcelReadType)((Object)Objects1.def((Object)((Object)option.getType()), (Object)((Object)ExcelReadType.TEXT)));
        option.setType(type);
        this.checkStreamingSupportType(type);
        Class<?> parameterType = method.getParameterTypes()[0];
        switch (type) {
            case LINK_ADDRESS: {
                if (parameterType.equals(String.class)) break;
                throw Exceptions.parse((String)"read hyperlink address parameter type must be String");
            }
            case PICTURE: {
                if (parameterType.equals(byte[].class) || parameterType.equals(String.class) || parameterType.equals(OutputStream.class) || parameterType.equals(ByteArrayOutputStream.class)) break;
                throw Exceptions.parse((String)"read picture parameter type must be byte[], String, OutputStream or ByteArrayOutputStream");
            }
        }
        this.options.put(fieldName, option);
    }
}

