/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel.reader;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.office.excel.option.ImportFieldOption;
import cn.orionsec.kit.office.excel.picture.PictureParser;
import cn.orionsec.kit.office.excel.reader.ExcelReaderIterator;
import cn.orionsec.kit.office.excel.type.ExcelReadType;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class BaseExcelReader<K, T>
implements SafeCloseable,
Iterable<T> {
    protected Workbook workbook;
    protected Sheet sheet;
    protected Iterator<Row> iterator;
    protected int currentIndex;
    protected int rowIndex;
    protected int rowNum;
    protected int lines;
    protected boolean end;
    protected boolean trim;
    protected boolean streaming;
    protected List<T> rows;
    protected Consumer<T> consumer;
    protected boolean store;
    protected Map<K, ImportFieldOption> options;
    protected PictureParser pictureParser;
    protected boolean init;

    protected BaseExcelReader(Workbook workbook, Sheet sheet, List<T> rows, Consumer<T> consumer) {
        Valid.notNull((Object)workbook, (String)"workbook is null", (Object[])new Object[0]);
        Valid.notNull((Object)sheet, (String)"sheet is null", (Object[])new Object[0]);
        if (rows == null && consumer == null) {
            throw Exceptions.argument((String)"rows container or row consumer one of them must not be empty");
        }
        this.workbook = workbook;
        this.sheet = sheet;
        this.rows = rows;
        this.consumer = consumer;
        this.store = rows != null;
        this.streaming = sheet instanceof StreamingSheet;
        this.lines = sheet.getLastRowNum() + 1;
        this.iterator = sheet.rowIterator();
        this.init = true;
    }

    @Override
    public ExcelReaderIterator<T> iterator() {
        return new ExcelReaderIterator(this);
    }

    public BaseExcelReader<K, T> init() {
        if (this.init) {
            return this;
        }
        this.init = true;
        boolean hasPicture = this.checkHasPicture();
        if (hasPicture) {
            this.pictureParser = new PictureParser(this.workbook, this.sheet);
            this.pictureParser.analysis();
        }
        return this;
    }

    public BaseExcelReader<K, T> skip() {
        ++this.rowIndex;
        return this;
    }

    public BaseExcelReader<K, T> skip(int i) {
        this.rowIndex += i;
        return this;
    }

    public BaseExcelReader<K, T> trim() {
        this.trim = true;
        return this;
    }

    public BaseExcelReader<K, T> recalculationFormula() {
        this.sheet.setForceFormulaRecalculation(true);
        return this;
    }

    public BaseExcelReader<K, T> read() {
        this.checkInit();
        while (!this.end) {
            this.readRow();
        }
        return this;
    }

    public BaseExcelReader<K, T> read(int i) {
        this.checkInit();
        for (int j = 0; j < i && !this.end; ++j) {
            this.readRow();
        }
        return this;
    }

    public BaseExcelReader<K, T> clear() {
        if (this.store && this.rows != null) {
            this.rows.clear();
        }
        return this;
    }

    protected void readRow() {
        this.checkInit();
        T row = this.nextRow();
        if (this.end || row == null) {
            return;
        }
        if (this.store) {
            this.rows.add(row);
        } else {
            this.consumer.accept(row);
        }
    }

    protected T nextRow() {
        this.checkInit();
        if (this.end) {
            return null;
        }
        if (!this.iterator.hasNext()) {
            this.end = true;
            return null;
        }
        Row row = this.iterator.next();
        if (this.currentIndex++ == this.rowIndex) {
            ++this.rowIndex;
            ++this.rowNum;
            return this.parserRow(row);
        }
        return this.nextRow();
    }

    protected abstract T parserRow(Row var1);

    protected void checkInit() {
        if (!this.init) {
            if (this.checkHasPicture()) {
                throw Exceptions.init((String)"excel reader uninitialized");
            }
            this.init = true;
        }
    }

    protected boolean checkHasPicture() {
        if (this.options == null) {
            return false;
        }
        return this.options.values().stream().map(ImportFieldOption::getType).anyMatch(ExcelReadType.PICTURE::equals);
    }

    protected void checkStreamingSupportType(ExcelReadType type) {
        if (this.streaming && (type.equals((Object)ExcelReadType.LINK_ADDRESS) || type.equals((Object)ExcelReadType.COMMENT) || type.equals((Object)ExcelReadType.PICTURE))) {
            throw Exceptions.parse((String)"streaming just support read value");
        }
    }

    protected void addOption(K k, ImportFieldOption option) {
        Valid.notNull((Object)option, (String)"field option is null", (Object[])new Object[0]);
        ExcelReadType type = option.getType();
        if (type == null) {
            throw Exceptions.init((String)"type must not be null");
        }
        this.checkStreamingSupportType(type);
        this.options.put(k, option);
    }

    protected byte[] getPicture(int col, Row row) {
        if (this.pictureParser == null) {
            return null;
        }
        return Optional.ofNullable(this.pictureParser.getPicture(row.getRowNum(), col)).map(PictureData::getData).orElse(null);
    }

    public void close() {
        Streams.close((AutoCloseable)this.workbook);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public int getLines() {
        return this.lines;
    }
}

