/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.excel;

import cn.orionsec.kit.lang.config.KitConfig;
import cn.orionsec.kit.lang.constant.Const;
import cn.orionsec.kit.lang.utils.Colors;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.convert.Converts;
import cn.orionsec.kit.lang.utils.io.FileReaders;
import cn.orionsec.kit.lang.utils.io.FileTypes;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.math.BigDecimals;
import cn.orionsec.kit.lang.utils.time.Dates;
import cn.orionsec.kit.office.KitOfficeConfiguration;
import cn.orionsec.kit.office.excel.copy.SheetCopier;
import cn.orionsec.kit.office.excel.option.CellOption;
import cn.orionsec.kit.office.excel.option.CommentOption;
import cn.orionsec.kit.office.excel.option.ExportFieldOption;
import cn.orionsec.kit.office.excel.option.FontOption;
import cn.orionsec.kit.office.excel.option.FooterOption;
import cn.orionsec.kit.office.excel.option.HeaderOption;
import cn.orionsec.kit.office.excel.option.PrintOption;
import cn.orionsec.kit.office.excel.option.PropertiesOption;
import cn.orionsec.kit.office.excel.option.TitleOption;
import cn.orionsec.kit.office.excel.picture.PictureParser;
import cn.orionsec.kit.office.excel.style.FontStream;
import cn.orionsec.kit.office.excel.style.PrintStream;
import cn.orionsec.kit.office.excel.style.StyleStream;
import cn.orionsec.kit.office.excel.type.ExcelFieldType;
import cn.orionsec.kit.office.excel.type.ExcelLinkType;
import cn.orionsec.kit.office.excel.type.ExcelPictureType;
import cn.orionsec.kit.office.excel.type.ExcelReadType;
import com.monitorjbl.xlsx.StreamingReader;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import com.monitorjbl.xlsx.impl.StreamingWorkbook;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.Thumbnail;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Excels {
    private static final Logger LOGGER = LoggerFactory.getLogger(Excels.class);
    private static final int BUFFER_LINE = Const.N_100;
    private static final int BUFFER_SIZE = 8192;
    private static final String POI_DEFAULT_AUTHOR = "Apache POI";
    private static final String KIT_DEFAULT_AUTHOR = (String)KitConfig.get((String)KitOfficeConfiguration.CONFIG.EXCEL_DEFAULT_AUTHOR);
    private static final String KIT_DEFAULT_APPLICATION = (String)KitConfig.get((String)KitOfficeConfiguration.CONFIG.EXCEL_DEFAULT_APPLICATION);

    private Excels() {
    }

    public static int getColumnNumber(String s) {
        if (Strings.isBlank((String)s)) {
            return -1;
        }
        char[] ss = s.toUpperCase().toCharArray();
        int count = 0;
        int mi = 1;
        for (int i = ss.length - 1; i >= 0; --i) {
            int t = ss[i] - 65 + 1;
            count += t * mi;
            mi *= 26;
        }
        return count;
    }

    public static String getColumnSymbol(int column) {
        String out;
        Valid.gt((Comparable)Integer.valueOf(column), (Comparable)Integer.valueOf(0), (String)"column must > 0 && < 703", (Object[])new Object[0]);
        Valid.lt((Comparable)Integer.valueOf(column), (Comparable)Integer.valueOf(703), (String)"column must > 0 && < 703", (Object[])new Object[0]);
        if (column == 26) {
            return Const.LETTERS[25];
        }
        if (column / 26 != 0) {
            if (column % 26 == 0) {
                out = Const.LETTERS[column / 26 - 2];
                out = out + Const.LETTERS[25];
            } else {
                out = Const.LETTERS[column / 26 - 1];
                out = out + Const.LETTERS[column % 26 - 1];
            }
        } else {
            out = Const.LETTERS[column - 1];
        }
        return out;
    }

    public static int getWidth(int width) {
        return Excels.getWidth((double)width);
    }

    public static int getWidth(double width) {
        return (int)((width + 0.72) * 256.0);
    }

    public static <T> T getCellValue(Cell cell, ExcelReadType type) {
        return Excels.getCellValue(cell, type, null);
    }

    public static <T> T getCellValue(Cell cell, ExcelReadType type, CellOption option) {
        Object value;
        switch (type) {
            case DECIMAL: {
                value = Excels.getCellDecimal(cell, null, option);
                break;
            }
            case INTEGER: {
                value = Excels.getCellInteger(cell, null, option);
                break;
            }
            case LONG: {
                value = Excels.getCellLong(cell, null, option);
                break;
            }
            case DATE: {
                value = Excels.getCellDate(cell, null, option);
                break;
            }
            case PHONE: {
                value = Excels.getCellPhone(cell);
                break;
            }
            case LINK_ADDRESS: {
                value = Excels.getCellHyperUrl(cell);
                break;
            }
            case COMMENT: {
                value = Excels.getCellComment(cell);
                break;
            }
            case PICTURE: {
                value = null;
                break;
            }
            default: {
                value = Excels.getCellValue(cell);
            }
        }
        return (T)value;
    }

    public static String getCellValue(Cell cell) {
        return Excels.getCellValue(cell, (CellType)null);
    }

    public static String getCellValue(Cell cell, CellType type) {
        String value = "";
        if (cell == null) {
            return value;
        }
        if (type == null) {
            type = cell.getCellType();
        }
        switch (type) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = Dates.format((Date)DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    break;
                }
                value = BigDecimal.valueOf(cell.getNumericCellValue()).toString();
                String[] item = value.split("\\.");
                if (item.length <= 1 || !Strings.isInteger((String)item[1]) || Long.parseLong(item[1]) != 0L) break;
                value = item[0];
                break;
            }
            case FORMULA: {
                value = Excels.getCellValue(cell, cell.getCachedFormulaResultType());
                if (!"NaN".equals(value)) break;
                value = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                value = "" + cell.getBooleanCellValue();
                break;
            }
            case BLANK: {
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                value = error == null ? "" : error.getString();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return (String)Objects1.def((Object)value, (Object)"");
    }

    public static BigDecimal getCellDecimal(Cell cell) {
        return Excels.getCellDecimal(cell, null, null);
    }

    public static BigDecimal getCellDecimal(Cell cell, CellOption option) {
        return Excels.getCellDecimal(cell, null, option);
    }

    public static BigDecimal getCellDecimal(Cell cell, CellType type, CellOption option) {
        if (cell == null) {
            return null;
        }
        if (type == null) {
            type = cell.getCellType();
        }
        switch (type) {
            case FORMULA: {
                return Excels.getCellDecimal(cell, cell.getCachedFormulaResultType(), option);
            }
            case NUMERIC: {
                return BigDecimal.valueOf(cell.getNumericCellValue());
            }
            case STRING: {
                String str = cell.getStringCellValue().trim();
                if (option != null && !Strings.isEmpty((CharSequence)option.getFormat())) {
                    return BigDecimals.parse((String)str, (String)option.getFormat());
                }
                if (!Strings.isNumber((String)str)) break;
                return BigDecimals.toBigDecimal((Object)str);
            }
        }
        return null;
    }

    public static Integer getCellInteger(Cell cell) {
        return Excels.getCellInteger(cell, null, null);
    }

    public static Integer getCellInteger(Cell cell, CellOption option) {
        return Excels.getCellInteger(cell, null, option);
    }

    public static Integer getCellInteger(Cell cell, CellType type, CellOption option) {
        BigDecimal val = Excels.getCellDecimal(cell, type, option);
        return val == null ? null : Integer.valueOf(val.intValue());
    }

    public static Long getCellLong(Cell cell) {
        return Excels.getCellLong(cell, null, null);
    }

    public static Long getCellLong(Cell cell, CellOption option) {
        return Excels.getCellLong(cell, null, option);
    }

    public static Long getCellLong(Cell cell, CellType type, CellOption option) {
        BigDecimal val = Excels.getCellDecimal(cell, type, option);
        return val == null ? null : Long.valueOf(val.longValue());
    }

    public static Date getCellDate(Cell cell) {
        return Excels.getCellDate(cell, null, null);
    }

    public static Date getCellDate(Cell cell, CellOption option) {
        return Excels.getCellDate(cell, null, option);
    }

    public static Date getCellDate(Cell cell, CellType type, CellOption option) {
        if (cell == null) {
            return null;
        }
        if (type == null) {
            type = cell.getCellType();
        }
        switch (type) {
            case FORMULA: {
                if (!DateUtil.isCellDateFormatted((Cell)cell)) {
                    return Excels.getCellDate(cell, cell.getCachedFormulaResultType(), option);
                }
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                double value = cell.getNumericCellValue();
                if (!DateUtil.isValidExcelDate((double)value)) break;
                return DateUtil.getJavaDate((double)cell.getNumericCellValue());
            }
        }
        String o = cell.getStringCellValue().trim();
        if (option != null && !Strings.isEmpty((CharSequence)option.getFormat())) {
            return Dates.parse((String)o, (String)option.getFormat());
        }
        return Dates.date((Object)o);
    }

    public static String getCellPhone(Cell cell) {
        return Excels.getCellPhone(cell, null);
    }

    public static String getCellPhone(Cell cell, CellType type) {
        if (cell == null) {
            return "";
        }
        if (type == null) {
            type = cell.getCellType();
        }
        switch (type) {
            case FORMULA: {
                return Excels.getCellPhone(cell, cell.getCachedFormulaResultType());
            }
            case NUMERIC: {
                return new DecimalFormat("#").format(cell.getNumericCellValue());
            }
            case STRING: {
                return new DecimalFormat("#").format(Double.parseDouble(cell.toString()));
            }
        }
        return cell.toString().trim();
    }

    public static String getCellComment(Cell cell) {
        if (cell == null) {
            return null;
        }
        return Optional.ofNullable(cell.getCellComment()).map(Comment::getString).map(RichTextString::getString).orElse(null);
    }

    public static String getCellHyperUrl(Cell cell) {
        if (cell == null) {
            return null;
        }
        return Optional.ofNullable(cell.getHyperlink()).map(Hyperlink::getAddress).orElse(null);
    }

    public static Row getRow(Sheet sheet, int index) {
        return sheet.getRow(index);
    }

    public static CellStyle getRowStyle(Sheet sheet, int index) {
        return Optional.ofNullable(sheet.getRow(index)).map(Row::getRowStyle).get();
    }

    public static Cell getCell(Sheet sheet, int row, int column) {
        return SheetUtil.getCell((Sheet)sheet, (int)row, (int)column);
    }

    public static CellStyle getCellStyle(Sheet sheet, int row, int column) {
        return Optional.ofNullable(SheetUtil.getCell((Sheet)sheet, (int)row, (int)column)).map(Cell::getCellStyle).get();
    }

    public static Cell getCellMerge(Sheet sheet, int row, int column) {
        return SheetUtil.getCellWithMerges((Sheet)sheet, (int)row, (int)column);
    }

    public static ExcelFieldType getFieldType(Object o) {
        if (o == null) {
            return ExcelFieldType.TEXT;
        }
        return ExcelFieldType.of(o.getClass());
    }

    public static ExcelFieldType getFieldType(Class<?> clazz) {
        return ExcelFieldType.of(clazz);
    }

    public static void setCellValue(Cell cell, Object value) {
        Excels.setCellValue(cell, value, null, null);
    }

    public static void setCellValue(Cell cell, Object value, ExcelFieldType type) {
        Excels.setCellValue(cell, value, type, null);
    }

    public static void setCellValue(Cell cell, Object value, ExcelFieldType type, CellOption option) {
        if (value == null) {
            return;
        }
        if (type == null) {
            cell.setCellValue(Objects1.toString((Object)value));
        } else if (type.equals((Object)ExcelFieldType.AUTO)) {
            Excels.setCellValue(cell, value, ExcelFieldType.of(value.getClass()), option);
        } else {
            switch (type) {
                case NUMBER: {
                    cell.setCellValue(Converts.toDouble((Object)value));
                    break;
                }
                case DATE: {
                    cell.setCellValue(Converts.toDate((Object)value));
                    break;
                }
                case DATE_FORMAT: {
                    if (option != null && !Strings.isEmpty((CharSequence)option.getFormat())) {
                        cell.setCellValue(Dates.format((Date)Converts.toDate((Object)value), (String)option.getFormat()));
                        break;
                    }
                    cell.setCellValue(Dates.format((Date)Converts.toDate((Object)value)));
                    break;
                }
                case DECIMAL_FORMAT: {
                    if (option != null && !Strings.isEmpty((CharSequence)option.getFormat())) {
                        cell.setCellValue(BigDecimals.format((Object)value, (String)option.getFormat()));
                        break;
                    }
                    cell.setCellValue(Objects1.toString((Object)value));
                    break;
                }
                case FORMULA: {
                    cell.setCellFormula(Objects1.toString((Object)value));
                    break;
                }
                case BOOLEAN: {
                    cell.setCellValue(Converts.toBoolean((Object)value));
                    break;
                }
                default: {
                    cell.setCellValue(Objects1.toString((Object)value));
                }
            }
        }
    }

    public static void copyCellValue(Cell source, Cell target) {
        if (source == null) {
            return;
        }
        CellType type = source.getCellType();
        switch (type) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)source)) {
                    target.setCellValue(source.getDateCellValue());
                    break;
                }
                target.setCellValue(source.getNumericCellValue());
                break;
            }
            case STRING: {
                target.setCellValue(source.getRichStringCellValue());
                break;
            }
            case FORMULA: {
                target.setCellFormula(source.getCellFormula());
                break;
            }
            case ERROR: {
                target.setCellErrorValue(source.getErrorCellValue());
                break;
            }
            case BOOLEAN: {
                target.setCellValue(source.getBooleanCellValue());
                break;
            }
        }
    }

    public static int getRowCount(Sheet sheet) {
        return sheet.getLastRowNum() + 1;
    }

    public static int getPhysicalRowCount(Sheet sheet) {
        return sheet.getPhysicalNumberOfRows() + 1;
    }

    public static int getColumnCount(Sheet sheet) {
        return Excels.getColumnCount(sheet, 0);
    }

    public static int getColumnCount(Sheet sheet, int rowNum) {
        Row row = sheet.getRow(rowNum);
        if (row != null) {
            return row.getLastCellNum();
        }
        return 0;
    }

    public static XSSFColor getColor(String rgb) {
        return new XSSFColor(Colors.toRgb((String)rgb), null);
    }

    public static short paletteColor(Workbook workbook, short index, String rgb) {
        return Excels.paletteColor(workbook, index, Colors.toRgb((String)rgb));
    }

    public static short paletteColor(Workbook workbook, short index, byte[] rgb) {
        if (workbook instanceof HSSFWorkbook) {
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            if (rgb != null) {
                HSSFColor color = palette.findColor(rgb[0], rgb[1], rgb[2]);
                if (color == null) {
                    palette.setColorAtIndex(index, rgb[0], rgb[1], rgb[2]);
                    return index;
                }
                return color.getIndex();
            }
            return 0;
        }
        return new XSSFColor(rgb, null).getIndex();
    }

    public static PictureParser createPictureParser(Sheet sheet) {
        return new PictureParser(sheet.getWorkbook(), sheet);
    }

    public static PictureParser createPictureParser(Workbook workbook, int index) {
        return new PictureParser(workbook, workbook.getSheetAt(index));
    }

    public static PictureParser createPictureParser(Workbook workbook, Sheet sheet) {
        return new PictureParser(workbook, sheet);
    }

    public static byte[] getThumbnail(Workbook workbook) {
        block6: {
            if (workbook instanceof HSSFWorkbook) {
                return Optional.ofNullable(((HSSFWorkbook)workbook).getSummaryInformation()).map(SummaryInformation::getThumbnailThumbnail).map(Thumbnail::getThumbnail).orElse(null);
            }
            if (workbook instanceof XSSFWorkbook) {
                try {
                    InputStream in = ((XSSFWorkbook)workbook).getProperties().getThumbnailImage();
                    if (in != null) {
                        return Streams.toByteArray((InputStream)in);
                    }
                    break block6;
                }
                catch (IOException e) {
                    throw Exceptions.ioRuntime((Throwable)e);
                }
            }
            if (workbook instanceof SXSSFWorkbook) {
                return Excels.getThumbnail((Workbook)((SXSSFWorkbook)workbook).getXSSFWorkbook());
            }
        }
        return null;
    }

    public static void setThumbnail(Workbook workbook, File thumbnail) {
        try {
            Excels.setThumbnail(workbook, Streams.toByteArray((InputStream)Files1.openInputStream((File)thumbnail)), thumbnail.getName());
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static void setThumbnail(Workbook workbook, String thumbnail) {
        try {
            Excels.setThumbnail(workbook, Streams.toByteArray((InputStream)Files1.openInputStream((String)thumbnail)), Files1.getFileName((String)thumbnail));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static void setThumbnail(Workbook workbook, InputStream thumbnail) {
        try {
            Excels.setThumbnail(workbook, Streams.toByteArray((InputStream)thumbnail), null);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static void setThumbnail(Workbook workbook, byte[] thumbnail) {
        Excels.setThumbnail(workbook, thumbnail, null);
    }

    public static void setThumbnail(Workbook workbook, InputStream thumbnail, String fileName) {
        try {
            Excels.setThumbnail(workbook, Streams.toByteArray((InputStream)thumbnail), fileName);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static void setThumbnail(Workbook workbook, byte[] thumbnail, String fileName) {
        if (thumbnail == null) {
            return;
        }
        if (workbook instanceof HSSFWorkbook) {
            HSSFWorkbook wb = (HSSFWorkbook)workbook;
            if (wb.getSummaryInformation() == null) {
                wb.createInformationProperties();
            }
            wb.getSummaryInformation().setThumbnail(thumbnail);
        } else if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook wb = (XSSFWorkbook)workbook;
            try {
                if (fileName == null) {
                    String fileType = FileTypes.getFileType((byte[])thumbnail);
                    fileName = "jpg".equals(fileType) ? "tmp.jpg" : "tmp.png";
                }
                wb.getProperties().setThumbnail(fileName, Streams.toInputStream((byte[])thumbnail));
            }
            catch (IOException e) {
                throw Exceptions.ioRuntime((Throwable)e);
            }
        } else if (workbook instanceof SXSSFWorkbook) {
            Excels.setThumbnail((Workbook)((SXSSFWorkbook)workbook).getXSSFWorkbook(), thumbnail, fileName);
        }
    }

    public static PropertiesOption getProperties(Workbook workbook) {
        PropertiesOption option = new PropertiesOption();
        if (workbook instanceof HSSFWorkbook) {
            SummaryInformation i = ((HSSFWorkbook)workbook).getSummaryInformation();
            DocumentSummaryInformation di = ((HSSFWorkbook)workbook).getDocumentSummaryInformation();
            if (i == null) {
                return option;
            }
            option.setAuthor(i.getAuthor());
            option.setTitle(i.getTitle());
            option.setSubject(i.getSubject());
            option.setKeywords(i.getKeywords());
            option.setDescription(i.getComments());
            option.setCategory(di.getCategory());
            option.setModifiedUser(i.getLastAuthor());
            option.setContentType(di.getContentType());
            option.setContentStatus(di.getContentStatus());
            option.setCreated(i.getCreateDateTime());
            option.setManager(di.getManager());
            option.setCompany(di.getCompany());
            option.setApplication(i.getApplicationName());
            if (i.getEditTime() != 0L) {
                option.setModified(new Date(i.getEditTime()));
            }
        } else if (workbook instanceof XSSFWorkbook) {
            POIXMLProperties.CoreProperties p = ((XSSFWorkbook)workbook).getProperties().getCoreProperties();
            CTProperties cp = ((XSSFWorkbook)workbook).getProperties().getExtendedProperties().getUnderlyingProperties();
            option.setAuthor(p.getCreator());
            option.setTitle(p.getTitle());
            option.setSubject(p.getSubject());
            option.setKeywords(p.getKeywords());
            option.setDescription(p.getDescription());
            option.setRevision(p.getRevision());
            option.setCategory(p.getCategory());
            option.setModifiedUser(p.getLastModifiedByUser());
            option.setContentType(p.getContentType());
            option.setContentStatus(p.getContentStatus());
            option.setIdentifier(p.getIdentifier());
            option.setCreated(option.getCreated());
            option.setModified(option.getModified());
            option.setManager(cp.getManager());
            option.setCompany(cp.getCompany());
            option.setApplication(cp.getApplication());
        } else if (workbook instanceof SXSSFWorkbook) {
            return Excels.getProperties((Workbook)((SXSSFWorkbook)workbook).getXSSFWorkbook());
        }
        return option;
    }

    public static void setProperties(Workbook workbook, PropertiesOption option) {
        if (option == null) {
            return;
        }
        if (workbook instanceof HSSFWorkbook) {
            if (((HSSFWorkbook)workbook).getSummaryInformation() == null) {
                ((HSSFWorkbook)workbook).createInformationProperties();
            }
            SummaryInformation i = ((HSSFWorkbook)workbook).getSummaryInformation();
            DocumentSummaryInformation di = ((HSSFWorkbook)workbook).getDocumentSummaryInformation();
            Strings.ifNotBlank((String)option.getAuthor(), arg_0 -> ((SummaryInformation)i).setAuthor(arg_0));
            Strings.ifNotBlank((String)option.getTitle(), arg_0 -> ((SummaryInformation)i).setTitle(arg_0));
            Strings.ifNotBlank((String)option.getSubject(), arg_0 -> ((SummaryInformation)i).setSubject(arg_0));
            Strings.ifNotBlank((String)option.getKeywords(), arg_0 -> ((SummaryInformation)i).setKeywords(arg_0));
            Strings.ifNotBlank((String)option.getDescription(), arg_0 -> ((SummaryInformation)i).setComments(arg_0));
            Strings.ifNotBlank((String)option.getModifiedUser(), arg_0 -> ((SummaryInformation)i).setLastAuthor(arg_0));
            Strings.ifNotBlank((String)option.getCategory(), arg_0 -> ((DocumentSummaryInformation)di).setCategory(arg_0));
            Strings.ifNotBlank((String)option.getContentType(), arg_0 -> ((DocumentSummaryInformation)di).setContentType(arg_0));
            Strings.ifNotBlank((String)option.getContentStatus(), arg_0 -> ((DocumentSummaryInformation)di).setContentStatus(arg_0));
            Strings.ifNotBlank((String)option.getManager(), arg_0 -> ((DocumentSummaryInformation)di).setManager(arg_0));
            Strings.ifNotBlank((String)option.getCompany(), arg_0 -> ((DocumentSummaryInformation)di).setCompany(arg_0));
            Strings.ifNotBlank((String)option.getApplication(), arg_0 -> ((SummaryInformation)i).setApplicationName(arg_0));
            Objects1.ifNotNull((Object)option.getCreated(), arg_0 -> ((SummaryInformation)i).setCreateDateTime(arg_0));
            Objects1.ifNotNull((Object)option.getModified(), m -> i.setEditTime(m.getTime()));
        } else if (workbook instanceof XSSFWorkbook) {
            POIXMLProperties.CoreProperties p = ((XSSFWorkbook)workbook).getProperties().getCoreProperties();
            CTProperties cp = ((XSSFWorkbook)workbook).getProperties().getExtendedProperties().getUnderlyingProperties();
            Strings.ifNotBlank((String)option.getAuthor(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setCreator(arg_0));
            Strings.ifNotBlank((String)option.getTitle(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setTitle(arg_0));
            Strings.ifNotBlank((String)option.getSubject(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setSubjectProperty(arg_0));
            Strings.ifNotBlank((String)option.getKeywords(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setKeywords(arg_0));
            Strings.ifNotBlank((String)option.getRevision(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setRevision(arg_0));
            Strings.ifNotBlank((String)option.getCategory(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setCategory(arg_0));
            Strings.ifNotBlank((String)option.getModifiedUser(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setLastModifiedByUser(arg_0));
            Strings.ifNotBlank((String)option.getContentType(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setContentType(arg_0));
            Strings.ifNotBlank((String)option.getContentStatus(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setContentStatus(arg_0));
            Strings.ifNotBlank((String)option.getIdentifier(), arg_0 -> ((POIXMLProperties.CoreProperties)p).setIdentifier(arg_0));
            Objects1.ifNotNull((Object)option.getCreated(), c -> p.setCreated(Optional.of(c)));
            Objects1.ifNotNull((Object)option.getModified(), c -> p.setModified(Optional.of(c)));
            Strings.ifNotBlank((String)option.getManager(), arg_0 -> ((CTProperties)cp).setManager(arg_0));
            Strings.ifNotBlank((String)option.getCompany(), arg_0 -> ((CTProperties)cp).setCompany(arg_0));
            Strings.ifNotBlank((String)option.getApplication(), arg_0 -> ((CTProperties)cp).setApplication(arg_0));
        } else if (workbook instanceof SXSSFWorkbook) {
            Excels.setProperties((Workbook)((SXSSFWorkbook)workbook).getXSSFWorkbook(), option);
        }
    }

    public static void setDefaultProperties(Workbook workbook) {
        try {
            PropertiesOption properties = Excels.getProperties(workbook);
            String author = properties.getAuthor();
            String application = properties.getApplication();
            if (Strings.isBlank((String)author) || POI_DEFAULT_AUTHOR.equals(author)) {
                properties.setAuthor(KIT_DEFAULT_AUTHOR);
            }
            if (Strings.isBlank((String)application) || POI_DEFAULT_AUTHOR.equals(application)) {
                properties.setApplication(KIT_DEFAULT_APPLICATION);
            }
            Excels.setProperties(workbook, properties);
        }
        catch (Exception e) {
            LOGGER.error("Excels.setDefaultProperties setDefaultProperties error", (Throwable)e);
        }
    }

    public static HeaderOption getHeader(Sheet sheet) {
        Header header = sheet.getHeader();
        HeaderOption option = new HeaderOption();
        option.setLeft(header.getLeft());
        option.setCenter(header.getCenter());
        option.setRight(header.getRight());
        return option;
    }

    public static void setHeader(Sheet sheet, HeaderOption option) {
        Header header = sheet.getHeader();
        header.setLeft(option.getLeft());
        header.setCenter(option.getCenter());
        header.setRight(option.getRight());
    }

    public static FooterOption getFooter(Sheet sheet) {
        Footer footer = sheet.getFooter();
        FooterOption option = new FooterOption();
        option.setLeft(footer.getLeft());
        option.setCenter(footer.getCenter());
        option.setRight(footer.getRight());
        return option;
    }

    public static void setFooter(Sheet sheet, FooterOption option) {
        Footer footer = sheet.getFooter();
        footer.setLeft(option.getLeft());
        footer.setCenter(option.getCenter());
        footer.setRight(option.getRight());
    }

    public static Comment createComment(Sheet sheet, int column, int row, String comment) {
        return Excels.createComment(sheet, column, row, new CommentOption(comment));
    }

    public static Comment createComment(Sheet sheet, int column, int row, CommentOption option) {
        if (option == null) {
            return null;
        }
        Drawing d = sheet.createDrawingPatriarch();
        ClientAnchor anchor = d.createAnchor(0, 0, 0, 0, column, row, 0, 0);
        Comment comment = d.createCellComment(anchor);
        Optional.ofNullable(option.getAuthor()).ifPresent(arg_0 -> ((Comment)comment).setAuthor(arg_0));
        comment.setVisible(option.isVisible());
        if (comment instanceof HSSFComment) {
            comment.setString((RichTextString)new HSSFRichTextString(option.getComment()));
        } else if (comment instanceof XSSFComment) {
            comment.setString((RichTextString)new XSSFRichTextString(option.getComment()));
        }
        return comment;
    }

    public static CellStyle parseStyle(Workbook workbook, ExportFieldOption option) {
        return StyleStream.parseStyle(workbook, option);
    }

    public static CellStyle parseColumnStyle(Workbook workbook, ExportFieldOption option) {
        return StyleStream.parseColumnStyle(workbook, option);
    }

    public static CellStyle parseTitleStyle(Workbook workbook, TitleOption option) {
        return StyleStream.parseTitleStyle(workbook, option);
    }

    public static Font parseFont(Workbook workbook, FontOption option) {
        return FontStream.parseFont(workbook, option);
    }

    public static PrintSetup parsePrint(Sheet sheet, PrintOption option) {
        return PrintStream.parsePrint(sheet, option);
    }

    public static void setLink(Workbook workbook, Cell cell, ExcelLinkType linkType, String address, ExcelFieldType textType, Object text) {
        Excels.setLink(workbook, cell, linkType, address, textType, null, text);
    }

    public static void setLink(Workbook workbook, Cell cell, ExcelLinkType linkType, String address, ExcelFieldType textType, CellOption option, Object text) {
        org.apache.poi.ss.usermodel.Hyperlink link;
        if (address == null) {
            return;
        }
        switch (linkType) {
            case LINK_URL: {
                link = workbook.getCreationHelper().createHyperlink(HyperlinkType.URL);
                break;
            }
            case LINK_DOC: {
                link = workbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
                break;
            }
            case LINK_EMAIL: {
                link = workbook.getCreationHelper().createHyperlink(HyperlinkType.EMAIL);
                break;
            }
            case LINK_FILE: {
                link = workbook.getCreationHelper().createHyperlink(HyperlinkType.FILE);
                break;
            }
            default: {
                link = null;
            }
        }
        Excels.setCellValue(cell, text, textType, option);
        if (link == null) {
            return;
        }
        if (linkType.equals((Object)ExcelLinkType.LINK_FILE) && !address.startsWith("file:///")) {
            address = "file:///" + Files1.getPath((String)address);
        } else if (linkType.equals((Object)ExcelLinkType.LINK_EMAIL) && !address.startsWith("mailto:")) {
            address = "mailto:" + address;
        }
        link.setAddress(Strings.def((String)address));
        cell.setHyperlink(link);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, File image, int rowIndex, int columnIndex) {
        return Excels.setPicture(workbook, sheet, FileReaders.readAllBytesFast((File)image), rowIndex, columnIndex, null, null);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, File image, int rowIndex, int columnIndex, String fileName) {
        return Excels.setPicture(workbook, sheet, FileReaders.readAllBytesFast((File)image), rowIndex, columnIndex, fileName, null);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, File image, int rowIndex, int columnIndex, ExcelPictureType type) {
        return Excels.setPicture(workbook, sheet, FileReaders.readAllBytesFast((File)image), rowIndex, columnIndex, null, type);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, String image, int rowIndex, int columnIndex) {
        return Excels.setPicture(workbook, sheet, FileReaders.readAllBytesFast((String)image), rowIndex, columnIndex, null, null);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, String image, int rowIndex, int columnIndex, String fileName) {
        return Excels.setPicture(workbook, sheet, FileReaders.readAllBytesFast((String)image), rowIndex, columnIndex, fileName, null);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, String image, int rowIndex, int columnIndex, ExcelPictureType type) {
        return Excels.setPicture(workbook, sheet, FileReaders.readAllBytesFast((String)image), rowIndex, columnIndex, null, type);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, InputStream image, int rowIndex, int columnIndex) {
        try {
            return Excels.setPicture(workbook, sheet, Streams.toByteArray((InputStream)image), rowIndex, columnIndex, null, null);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, InputStream image, int rowIndex, int columnIndex, String fileName) {
        try {
            return Excels.setPicture(workbook, sheet, Streams.toByteArray((InputStream)image), rowIndex, columnIndex, fileName, null);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, InputStream image, int rowIndex, int columnIndex, ExcelPictureType type) {
        try {
            return Excels.setPicture(workbook, sheet, Streams.toByteArray((InputStream)image), rowIndex, columnIndex, null, type);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, byte[] image, int rowIndex, int columnIndex) {
        return Excels.setPicture(workbook, sheet, image, rowIndex, columnIndex, null, null);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, byte[] image, int rowIndex, int columnIndex, String fileName) {
        return Excels.setPicture(workbook, sheet, image, rowIndex, columnIndex, fileName, null);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, byte[] image, int rowIndex, int columnIndex, ExcelPictureType type) {
        return Excels.setPicture(workbook, sheet, image, rowIndex, columnIndex, null, type);
    }

    public static Picture setPicture(Workbook workbook, Sheet sheet, byte[] image, int rowIndex, int columnIndex, String fileName, ExcelPictureType type) {
        int pictureIndex;
        if (type == null || type.equals((Object)ExcelPictureType.AUTO)) {
            type = Strings.isEmpty((CharSequence)fileName) ? ExcelPictureType.PNG : ExcelPictureType.of(Files1.getFileName((String)fileName));
        }
        if (workbook instanceof HSSFWorkbook) {
            int type1 = type.getType1();
            if (type1 == -1) {
                type1 = ExcelPictureType.PNG.getType1();
            }
            pictureIndex = workbook.addPicture(image, type1);
        } else {
            pictureIndex = workbook.addPicture(image, type.getType2());
        }
        Drawing drawing = sheet.createDrawingPatriarch();
        Object anchor = workbook instanceof HSSFWorkbook ? new HSSFClientAnchor(0, 0, 0, 0, (short)columnIndex, rowIndex, (short)(columnIndex + 1), rowIndex + 1) : new XSSFClientAnchor(0, 0, 0, 0, columnIndex, rowIndex, columnIndex + 1, rowIndex + 1);
        return drawing.createPicture((ClientAnchor)anchor, pictureIndex);
    }

    public static void freezeFirstRow(Sheet sheet) {
        sheet.createFreezePane(0, 1);
    }

    public static void freezeRow(Sheet sheet, int lastRow) {
        sheet.createFreezePane(0, lastRow);
    }

    public static void filterFirstRow(Sheet sheet) {
        Row row = sheet.getRow(0);
        sheet.setAutoFilter(new CellRangeAddress(1, 2, 0, row.getLastCellNum() - 1));
    }

    public static void filterFirstRow(Sheet sheet, int lastColumn) {
        sheet.setAutoFilter(new CellRangeAddress(0, 1, 0, lastColumn));
    }

    public static void filterFirstRow(Sheet sheet, int firstColumn, int lastColumn) {
        sheet.setAutoFilter(new CellRangeAddress(0, 1, firstColumn, lastColumn));
    }

    public static void filterRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(0);
        sheet.setAutoFilter(new CellRangeAddress(rowIndex, rowIndex + 1, 0, row.getLastCellNum() - 1));
    }

    public static void filterRow(Sheet sheet, int rowIndex, int lastColumn) {
        sheet.setAutoFilter(new CellRangeAddress(rowIndex, rowIndex + 1, 0, lastColumn));
    }

    public static void filterRow(Sheet sheet, int rowIndex, int firstColumn, int lastColumn) {
        sheet.setAutoFilter(new CellRangeAddress(rowIndex, rowIndex + 1, firstColumn, lastColumn));
    }

    public static CellRangeAddress mergeCellRange(int row, int firstColumn, int lastColumn) {
        return new CellRangeAddress(row, row, firstColumn, lastColumn);
    }

    public static CellRangeAddress mergeCellRange(int firstRow, int lastRow, int firstColumn, int lastColumn) {
        return new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
    }

    public static void mergeCell(Sheet sheet, int row, int firstColumn, int lastColumn) {
        Excels.mergeCell(sheet, new CellRangeAddress(row, row, firstColumn, lastColumn));
    }

    public static void mergeCell(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        Excels.mergeCell(sheet, new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn));
    }

    public static void mergeCell(Sheet sheet, CellRangeAddress region) {
        sheet.addMergedRegion(region);
    }

    public static void mergeCellBorder(Sheet sheet, int borderCode, int colorIndex, int row, int firstColumn, int lastColumn) {
        Excels.mergeCellBorder(sheet, borderCode, colorIndex, new CellRangeAddress(row, row, firstColumn, lastColumn));
    }

    public static void mergeCellBorder(Sheet sheet, int borderCode, int colorIndex, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        Excels.mergeCellBorder(sheet, borderCode, colorIndex, new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn));
    }

    public static void mergeCellBorder(Sheet sheet, int borderCode, int colorIndex, CellRangeAddress region) {
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.valueOf((short)((short)borderCode)), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.valueOf((short)((short)borderCode)), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.valueOf((short)((short)borderCode)), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.valueOf((short)((short)borderCode)), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)colorIndex, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)colorIndex, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)colorIndex, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)colorIndex, (CellRangeAddress)region, (Sheet)sheet);
    }

    public static void addSelectOptions(Sheet sheet, int column, String[] options) {
        Excels.addSelectOptions(sheet, 0, 65535, column, column, options);
    }

    public static void addSelectOptions(Sheet sheet, int startRow, int column, String[] options) {
        Excels.addSelectOptions(sheet, startRow, 65535, column, column, options);
    }

    public static void addSelectOptions(Sheet sheet, int startRow, int endRow, int column, String[] options) {
        Excels.addSelectOptions(sheet, startRow, endRow, column, column, options);
    }

    public static void addSelectOptions(Sheet sheet, int startRow, int endRow, int startColumn, int endColumn, String[] options) {
        if (endRow < startRow || endColumn < startColumn) {
            return;
        }
        CellRangeAddressList range = new CellRangeAddressList(startRow, endRow, startColumn, endColumn);
        DataValidationConstraint c = sheet.getDataValidationHelper().createExplicitListConstraint(options);
        DataValidation v = sheet.getDataValidationHelper().createValidation(c, range);
        sheet.addValidationData(v);
    }

    public static void write(Workbook workbook, String file) {
        Excels.write(workbook, (OutputStream)Files1.openOutputStreamSafe((String)file), true);
    }

    public static void write(Workbook workbook, File file) {
        Excels.write(workbook, (OutputStream)Files1.openOutputStreamSafe((File)file), true);
    }

    public static void write(Workbook workbook, OutputStream out) {
        Excels.write(workbook, out, false);
    }

    public static void write(Workbook workbook, OutputStream out, boolean close) {
        Valid.notNull((Object)workbook, (String)"workbook is null", (Object[])new Object[0]);
        Valid.notNull((Object)out, (String)"outputStream is null", (Object[])new Object[0]);
        try {
            workbook.write(out);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        finally {
            if (close) {
                Streams.close((AutoCloseable)out);
            }
        }
    }

    public static void write(Workbook workbook, String file, String password) {
        Excels.write(workbook, Files1.openOutputStreamSafe((File)new File(file)), password, true);
    }

    public static void write(Workbook workbook, File file, String password) {
        Excels.write(workbook, Files1.openOutputStreamSafe((File)file), password, true);
    }

    public static void write(Workbook workbook, OutputStream out, String password) {
        Excels.write(workbook, out, password, false);
    }

    public static void write(Workbook workbook, OutputStream out, String password, boolean close) {
        Valid.notNull((Object)workbook, (String)"workbook is null", (Object[])new Object[0]);
        Valid.notNull((Object)out, (String)"outputStream is null", (Object[])new Object[0]);
        if (password == null) {
            Excels.write(workbook, out, close);
            return;
        }
        try (POIFSFileSystem fs = new POIFSFileSystem();){
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
            workbook.write((OutputStream)tmpOut);
            ByteArrayInputStream tmpIn = new ByteArrayInputStream(tmpOut.toByteArray());
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((InputStream)tmpIn);
                 OutputStream os = enc.getDataStream(fs);){
                opc.save(os);
            }
            fs.writeFilesystem(out);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        finally {
            if (close) {
                Streams.close((AutoCloseable)out);
            }
        }
    }

    public static void close(Workbook workbook) {
        try {
            Streams.close((AutoCloseable)workbook);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SheetCopier copySheet(Workbook resourceWorkbook, Workbook targetWorkbook, int resourceIndex) {
        Sheet resourceSheet = resourceWorkbook.getSheetAt(resourceIndex);
        Sheet targetSheet = targetWorkbook.createSheet(resourceSheet.getSheetName());
        return new SheetCopier(resourceWorkbook, targetWorkbook, resourceSheet, targetSheet);
    }

    public static SheetCopier copySheet(Workbook resourceWorkbook, Workbook targetWorkbook, int resourceIndex, int targetIndex) {
        Sheet targetSheet;
        Sheet resourceSheet = resourceWorkbook.getSheetAt(resourceIndex);
        try {
            targetSheet = targetWorkbook.getSheetAt(targetIndex);
        }
        catch (Exception e) {
            targetSheet = targetWorkbook.createSheet(resourceSheet.getSheetName());
        }
        return new SheetCopier(resourceWorkbook, targetWorkbook, resourceSheet, targetSheet);
    }

    public static Workbook openWorkbook(InputStream in) {
        return Excels.openWorkbook(in, null);
    }

    public static Workbook openWorkbook(String file) {
        return Excels.openWorkbook(Files1.openInputStreamSafe((String)file), null);
    }

    public static Workbook openWorkbook(File file) {
        return Excels.openWorkbook(Files1.openInputStreamSafe((File)file), null);
    }

    public static Workbook openWorkbook(String file, String password) {
        return Excels.openWorkbook(Files1.openInputStreamSafe((String)file), password);
    }

    public static Workbook openWorkbook(File file, String password) {
        return Excels.openWorkbook(Files1.openInputStreamSafe((File)file), password);
    }

    public static Workbook openWorkbook(InputStream in, String password) {
        try {
            return WorkbookFactory.create((InputStream)in, (String)password);
        }
        catch (Exception e) {
            throw Exceptions.parse((String)"cannot open excel file", (Throwable)e);
        }
    }

    public static Workbook openStreamingWorkbook(String file) {
        return Excels.openStreamingWorkbook(new File(file), null, BUFFER_LINE, 8192);
    }

    public static Workbook openStreamingWorkbook(File file) {
        return Excels.openStreamingWorkbook(file, null, BUFFER_LINE, 8192);
    }

    public static Workbook openStreamingWorkbook(InputStream in) {
        return Excels.openStreamingWorkbook(in, null, BUFFER_LINE, 8192);
    }

    public static Workbook openStreamingWorkbook(String file, String password) {
        return Excels.openStreamingWorkbook(new File(file), password, BUFFER_LINE, 8192);
    }

    public static Workbook openStreamingWorkbook(File file, String password) {
        return Excels.openStreamingWorkbook(file, password, BUFFER_LINE, 8192);
    }

    public static Workbook openStreamingWorkbook(InputStream in, String password) {
        return Excels.openStreamingWorkbook(in, password, BUFFER_LINE, 8192);
    }

    public static Workbook openStreamingWorkbook(String file, int rowCache) {
        return Excels.openStreamingWorkbook(new File(file), null, rowCache, 8192);
    }

    public static Workbook openStreamingWorkbook(File file, int rowCache) {
        return Excels.openStreamingWorkbook(file, null, rowCache, 8192);
    }

    public static Workbook openStreamingWorkbook(InputStream in, int rowCache) {
        return Excels.openStreamingWorkbook(in, null, rowCache, 8192);
    }

    public static Workbook openStreamingWorkbook(String file, String password, int rowCache) {
        return Excels.openStreamingWorkbook(new File(file), password, rowCache, 8192);
    }

    public static Workbook openStreamingWorkbook(File file, String password, int rowCache) {
        return Excels.openStreamingWorkbook(file, password, rowCache, 8192);
    }

    public static Workbook openStreamingWorkbook(InputStream in, String password, int rowCache) {
        return Excels.openStreamingWorkbook(in, password, rowCache, 8192);
    }

    public static Workbook openStreamingWorkbook(String file, int rowCache, int bufferSize) {
        return Excels.openStreamingWorkbook(new File(file), null, rowCache, bufferSize);
    }

    public static Workbook openStreamingWorkbook(File file, int rowCache, int bufferSize) {
        return Excels.openStreamingWorkbook(file, null, rowCache, bufferSize);
    }

    public static Workbook openStreamingWorkbook(InputStream in, int rowCache, int bufferSize) {
        return Excels.openStreamingWorkbook(in, null, rowCache, bufferSize);
    }

    public static Workbook openStreamingWorkbook(String file, String password, int rowCache, int bufferSize) {
        return Excels.openStreamingWorkbook(new File(file), password, rowCache, bufferSize);
    }

    public static Workbook openStreamingWorkbook(File file, String password, int rowCache, int bufferSize) {
        if (file.getName().toLowerCase().endsWith("xls")) {
            throw Exceptions.parse((String)"Cannot using streaming open 2003 workbook");
        }
        return Excels.openStreamingWorkbook(Files1.openInputStreamSafe((File)file), password, rowCache, bufferSize);
    }

    public static Workbook openStreamingWorkbook(InputStream in, String password, int rowCache, int bufferSize) {
        try {
            return StreamingReader.builder().password(password).rowCacheSize(rowCache).bufferSize(bufferSize).open(in);
        }
        catch (Exception e) {
            throw Exceptions.parse((String)"cannot open streaming excel file", (Throwable)e);
        }
    }

    public static boolean isStreamingWorkbook(Workbook workbook) {
        return workbook instanceof StreamingWorkbook;
    }

    public static boolean isStreamingWorkbook(Class<?> clazz) {
        return StreamingWorkbook.class.equals(clazz);
    }

    public static boolean isStreamingSheet(Sheet sheet) {
        return sheet instanceof StreamingSheet;
    }

    public static boolean isStreamingSheet(Class<?> clazz) {
        return StreamingSheet.class.equals(clazz);
    }
}

