/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.writer;

import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.office.csv.core.CsvWriter;
import cn.orionsec.kit.office.csv.writer.BaseCsvWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.function.Function;

public class CsvLambdaWriter<T>
extends BaseCsvWriter<Function<T, ?>, T> {
    public CsvLambdaWriter(String file) {
        this(new CsvWriter(file));
    }

    public CsvLambdaWriter(File file) {
        this(new CsvWriter(file));
    }

    public CsvLambdaWriter(OutputStream out) {
        this(new CsvWriter(out));
    }

    public CsvLambdaWriter(Writer writer) {
        this(new CsvWriter(writer));
    }

    public CsvLambdaWriter(CsvWriter writer) {
        super(writer);
    }

    public static <T> CsvLambdaWriter<T> create(String file) {
        return new CsvLambdaWriter<T>(file);
    }

    public static <T> CsvLambdaWriter<T> create(File file) {
        return new CsvLambdaWriter<T>(file);
    }

    public static <T> CsvLambdaWriter<T> create(OutputStream out) {
        return new CsvLambdaWriter<T>(out);
    }

    public static <T> CsvLambdaWriter<T> create(Writer writer) {
        return new CsvLambdaWriter<T>(writer);
    }

    public static <T> CsvLambdaWriter<T> create(CsvWriter writer) {
        return new CsvLambdaWriter<T>(writer);
    }

    @Override
    protected String[] parseRow(T row) {
        String[] store = super.capacityStore();
        for (int i = 0; i < store.length; ++i) {
            Function fun = (Function)this.mapping.get(i);
            if (fun == null) continue;
            Object v = fun.apply(row);
            store[i] = v != null ? Objects1.toString(v) : Objects1.toString(this.defaultValue.get(fun));
        }
        return store;
    }
}

