/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.writer;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Maps;
import cn.orionsec.kit.lang.utils.reflect.Annotations;
import cn.orionsec.kit.lang.utils.reflect.Fields;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import cn.orionsec.kit.office.csv.annotation.ExportField;
import cn.orionsec.kit.office.csv.annotation.ExportIgnore;
import cn.orionsec.kit.office.csv.annotation.ExportSetting;
import cn.orionsec.kit.office.csv.core.CsvWriter;
import cn.orionsec.kit.office.csv.option.CsvWriterOption;
import cn.orionsec.kit.office.csv.writer.BaseCsvWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CsvBeanWriter<T>
extends BaseCsvWriter<String, T> {
    private final Class<T> targetClass;
    private boolean addHeader;
    private boolean indexToSort;
    private Map<String, Method> getters;
    private Map<Integer, String> headers;

    public CsvBeanWriter(String file, Class<T> targetClass) {
        this(new CsvWriter(file), targetClass);
    }

    public CsvBeanWriter(File file, Class<T> targetClass) {
        this(new CsvWriter(file), targetClass);
    }

    public CsvBeanWriter(OutputStream out, Class<T> targetClass) {
        this(new CsvWriter(out), targetClass);
    }

    public CsvBeanWriter(Writer writer, Class<T> targetClass) {
        this(new CsvWriter(writer), targetClass);
    }

    public CsvBeanWriter(CsvWriter writer, Class<T> targetClass) {
        super(writer);
        this.targetClass = (Class)Valid.notNull(targetClass, (String)"target class is null", (Object[])new Object[0]);
        this.headers = new TreeMap<Integer, String>();
        this.parseClass();
        this.parseField();
    }

    public static <T> CsvBeanWriter<T> create(String file, Class<T> targetClass) {
        return new CsvBeanWriter<T>(file, targetClass);
    }

    public static <T> CsvBeanWriter<T> create(File file, Class<T> targetClass) {
        return new CsvBeanWriter<T>(file, targetClass);
    }

    public static <T> CsvBeanWriter<T> create(OutputStream out, Class<T> targetClass) {
        return new CsvBeanWriter<T>(out, targetClass);
    }

    public static <T> CsvBeanWriter<T> create(Writer writer, Class<T> targetClass) {
        return new CsvBeanWriter<T>(writer, targetClass);
    }

    public static <T> CsvBeanWriter<T> create(CsvWriter writer, Class<T> targetClass) {
        return new CsvBeanWriter<T>(writer, targetClass);
    }

    public CsvBeanWriter<T> mapping(int column, String field) {
        Method method = this.getters.get(field);
        if (method == null) {
            throw Exceptions.parse((String)("not found " + field + " getter method"));
        }
        return (CsvBeanWriter)super.mapping(column, field);
    }

    @Override
    protected String[] parseRow(T row) {
        String[] store = super.capacityStore();
        for (int i = 0; i < store.length; ++i) {
            String getter = (String)this.mapping.get(i);
            if (getter == null) continue;
            Method method = this.getters.get(getter);
            Object value = Methods.invokeMethod(row, (Method)method);
            store[i] = value != null ? Objects1.toString((Object)value) : Objects1.toString(this.defaultValue.get(getter));
        }
        return store;
    }

    protected void parseClass() {
        ExportSetting setting = (ExportSetting)Annotations.getAnnotation(this.targetClass, ExportSetting.class);
        CsvWriterOption option = new CsvWriterOption();
        if (setting == null) {
            this.writer.setOption(option);
            return;
        }
        option.setForceQualifier(setting.forceQualifier()).setTextQualifier(setting.textQualifier()).setUseTextQualifier(setting.useTextQualifier()).setDelimiter(setting.delimiter()).setLineDelimiter(setting.lineDelimiter()).setComment(setting.comment()).setEscapeMode(setting.escapeMode()).setUseTextQualifier(setting.useTextQualifier()).setCharset(Charset.forName(setting.charset())).setTrim(setting.trim());
        this.writer.setOption(option);
        this.indexToSort = setting.indexToSort();
    }

    protected void parseField() {
        List fieldList = Fields.getFieldsByCache(this.targetClass);
        List methodList = Methods.getGetterMethodsByCache(this.targetClass);
        this.getters = methodList.stream().collect(Collectors.toMap(Fields::getFieldNameByMethod, Function.identity()));
        for (Field field : fieldList) {
            this.parseColumn((ExportField)Annotations.getAnnotation((Field)field, ExportField.class), (ExportIgnore)Annotations.getAnnotation((Field)field, ExportIgnore.class), Methods.getGetterMethodByField(this.targetClass, (Field)field), field.getName());
        }
        for (Method method : methodList) {
            this.parseColumn((ExportField)Annotations.getAnnotation((Method)method, ExportField.class), (ExportIgnore)Annotations.getAnnotation((Method)method, ExportIgnore.class), method, null);
        }
        this.indexToSort();
        if (this.addHeader && this.headers != null) {
            Optional.ofNullable(Maps.last(this.headers)).map(Map.Entry::getKey).map(s -> new String[s + 1]).map(s -> {
                for (int i = 0; i < ((String[])s).length; ++i) {
                    s[i] = this.headers.get(i);
                }
                return s;
            }).ifPresent(this::headers);
        }
    }

    protected void parseColumn(ExportField field, ExportIgnore ignore, Method method, String fieldName) {
        if (field == null || ignore != null) {
            return;
        }
        if (method == null) {
            throw Exceptions.parse((String)("not found " + fieldName + "getter method"));
        }
        int index = field.value();
        String header = field.header();
        if (fieldName == null) {
            this.mapping.put(index, Fields.getFieldNameByMethod((Method)method));
        } else {
            this.mapping.put(index, fieldName);
        }
        if (!Strings.isEmpty((CharSequence)header)) {
            this.addHeader = true;
            this.headers.put(index, header);
        }
        this.maxColumnIndex = Math.max(this.maxColumnIndex, index);
    }

    protected void indexToSort() {
        if (!this.indexToSort) {
            return;
        }
        TreeMap<Integer, Integer> sortMapping = new TreeMap<Integer, Integer>();
        TreeMap<Integer, String> sortHeaders = new TreeMap<Integer, String>();
        int i = 0;
        Set mappingEntities = this.mapping.entrySet();
        for (Map.Entry mappingEntity : mappingEntities) {
            sortMapping.put(i, (Integer)mappingEntity.getValue());
            sortHeaders.put(i, this.headers.get(mappingEntity.getKey()));
            ++i;
        }
        this.mapping = sortMapping;
        this.headers = sortHeaders;
        this.maxColumnIndex = mappingEntities.size() - 1;
    }
}

