/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.writer;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.able.SafeFlushable;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.office.csv.core.CsvWriter;
import cn.orionsec.kit.office.csv.option.CsvWriterOption;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class BaseCsvWriter<K, V>
implements SafeCloseable,
SafeFlushable {
    protected final CsvWriter writer;
    protected boolean skipNullRows;
    protected final Map<K, Object> defaultValue;
    protected int capacity;
    protected int maxColumnIndex;
    protected Map<Integer, K> mapping;

    public BaseCsvWriter(CsvWriter writer) {
        Valid.notNull((Object)writer, (String)"csv writer is null", (Object[])new Object[0]);
        this.writer = writer;
        this.skipNullRows = true;
        this.capacity = -1;
        this.defaultValue = new HashMap<K, Object>();
        this.mapping = new TreeMap<Integer, K>();
    }

    public BaseCsvWriter<K, V> skip() {
        try {
            this.writer.newLine();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        return this;
    }

    public BaseCsvWriter<K, V> skip(int i) {
        for (int j = 0; j < i; ++j) {
            this.skip();
        }
        return this;
    }

    public BaseCsvWriter<K, V> capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public BaseCsvWriter<K, V> skipNullRows(boolean skip) {
        this.skipNullRows = skip;
        return this;
    }

    public BaseCsvWriter<K, V> mapping(int column, K k) {
        return this.mapping(column, k, null);
    }

    public BaseCsvWriter<K, V> mapping(int column, K k, Object defaultValue) {
        this.maxColumnIndex = Math.max(this.maxColumnIndex, column);
        this.mapping.put(column, (Integer)k);
        if (defaultValue != null) {
            this.defaultValue.put(k, defaultValue);
        }
        return this;
    }

    public BaseCsvWriter<K, V> defaultValue(K k, Object value) {
        this.defaultValue.put(k, value);
        return this;
    }

    public BaseCsvWriter<K, V> headers(String ... headers) {
        if (headers == null) {
            if (this.skipNullRows) {
                return this;
            }
            return this.skip();
        }
        try {
            this.writer.writeLine(headers);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        return this;
    }

    public BaseCsvWriter<K, V> addRows(Collection<V> list) {
        list.forEach(this::addRow);
        return this;
    }

    public BaseCsvWriter<K, V> addRow(V row) {
        if (row == null) {
            if (this.skipNullRows) {
                return this;
            }
            return this.skip();
        }
        String[] parseRow = this.parseRow(row);
        if (parseRow == null) {
            if (this.skipNullRows) {
                return this;
            }
            return this.skip();
        }
        try {
            this.writer.writeLine(parseRow);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        return this;
    }

    public BaseCsvWriter<K, V> addComments(Collection<String> comments) {
        comments.forEach(this::addComment);
        return this;
    }

    public BaseCsvWriter<K, V> addComment(String comment) {
        try {
            this.writer.writeComment(comment);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        return this;
    }

    protected String[] capacityStore() {
        if (this.capacity != -1) {
            return new String[this.capacity];
        }
        return new String[this.maxColumnIndex + 1];
    }

    protected abstract String[] parseRow(V var1);

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }

    public CsvWriter getWriter() {
        return this.writer;
    }

    public CsvWriterOption getOption() {
        return this.writer.getOption();
    }

    public int getCapacity() {
        return this.capacity;
    }
}

