/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.split;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.office.csv.CsvExt;
import cn.orionsec.kit.office.csv.core.CsvWriter;
import cn.orionsec.kit.office.csv.reader.CsvArrayReader;
import cn.orionsec.kit.office.csv.writer.CsvArrayWriter;
import cn.orionsec.kit.office.support.SplitTargetGenerator;
import java.util.Collection;

public class CsvRowSplit
extends SplitTargetGenerator {
    private final CsvArrayReader reader;
    private final int limit;
    private String[] header;
    private int[] columns;
    private boolean end;

    public CsvRowSplit(CsvExt ext, int limit) {
        this(ext.arrayReader(), limit);
    }

    public CsvRowSplit(CsvArrayReader reader, int limit) {
        Valid.notNull((Object)reader, (String)"reader is null", (Object[])new Object[0]);
        Valid.lte((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(limit), (String)"limit not be lte 0", (Object[])new Object[0]);
        this.reader = reader;
        this.limit = limit;
        this.suffix = "csv";
    }

    public CsvRowSplit suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public CsvRowSplit skip() {
        return this.skip(1);
    }

    public CsvRowSplit skip(int skip) {
        this.reader.skip(skip);
        return this;
    }

    public CsvRowSplit columns(int ... columns) {
        if (!Arrays1.isEmpty((int[])columns)) {
            this.columns = columns;
        }
        return this;
    }

    public CsvRowSplit header(String ... header) {
        this.header = header;
        return this;
    }

    public CsvRowSplit split() {
        do {
            if (!super.hasNext()) {
                this.end = true;
                break;
            }
            Collection rows = this.reader.clear().read(this.limit).getRows();
            if (rows.isEmpty()) {
                this.end = true;
                break;
            }
            if (rows.size() < this.limit) {
                this.end = true;
            }
            super.next();
            CsvArrayWriter currentWriter = new CsvArrayWriter(new CsvWriter(this.currentOutputStream, this.reader.getOption().toWriterOption()));
            if (!Arrays1.isEmpty((Object[])this.header)) {
                currentWriter.addRow(this.header);
            }
            if (Arrays1.isEmpty((int[])this.columns)) {
                currentWriter.addRows(rows);
            } else {
                for (String[] row : rows) {
                    int length = row.length;
                    String[] newRow = new String[this.columns.length];
                    for (int i = 0; i < this.columns.length; ++i) {
                        if (length <= this.columns[i]) continue;
                        newRow[i] = row[this.columns[i]];
                    }
                    currentWriter.addRow(newRow);
                }
            }
            currentWriter.flush();
            if (!this.autoClose) continue;
            currentWriter.close();
        } while (!this.end);
        return this;
    }

    public CsvArrayReader getReader() {
        return this.reader;
    }

    public int getLimit() {
        return this.limit;
    }
}

