/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.split;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.constant.Const;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.office.csv.CsvExt;
import cn.orionsec.kit.office.csv.reader.CsvArrayReader;
import cn.orionsec.kit.office.csv.writer.CsvArrayWriter;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;

public class CsvColumnSplit
implements SafeCloseable {
    private final CsvArrayReader reader;
    private final int[] columns;
    private String[] headers;
    private int bufferLine;

    public CsvColumnSplit(CsvExt ext, int ... columns) {
        this(ext.arrayReader(), columns);
    }

    public CsvColumnSplit(CsvArrayReader reader, int ... columns) {
        Valid.notNull((Object)reader, (String)"split reader is null", (Object[])new Object[0]);
        Valid.isFalse((boolean)Arrays1.isEmpty((int[])columns), (String)"split columns is null", (Object[])new Object[0]);
        this.reader = reader;
        this.columns = columns;
        this.bufferLine = Const.N_100;
    }

    public CsvColumnSplit bufferLine(int bufferLine) {
        this.bufferLine = bufferLine;
        return this;
    }

    public CsvColumnSplit skip() {
        this.reader.skip();
        return this;
    }

    public CsvColumnSplit skip(int skip) {
        this.reader.skip(skip);
        return this;
    }

    public CsvColumnSplit header(String ... headers) {
        this.headers = headers;
        return this;
    }

    public CsvColumnSplit split(File file) {
        return this.split(Files1.openOutputStreamSafe((File)file), false);
    }

    public CsvColumnSplit split(String file) {
        return this.split(Files1.openOutputStreamSafe((String)file), false);
    }

    public CsvColumnSplit split(OutputStream out) {
        return this.split(out, false);
    }

    public CsvColumnSplit split(OutputStream out, boolean close) {
        Collection rows;
        CsvArrayWriter writer = new CsvArrayWriter(out);
        int length = this.columns.length;
        writer.capacity(length);
        if (!Arrays1.isEmpty((Object[])this.headers)) {
            writer.headers(this.headers);
        }
        while (!Lists.isEmpty(rows = this.reader.clear().read(this.bufferLine).getRows())) {
            for (String[] row : rows) {
                int rowLength = row.length;
                String[] newRow = new String[length];
                for (int i = 0; i < length; ++i) {
                    if (rowLength <= this.columns[i]) continue;
                    newRow[i] = row[this.columns[i]];
                }
                writer.addRow(newRow);
            }
        }
        writer.flush();
        if (close) {
            writer.close();
        }
        return this;
    }

    public void close() {
        this.reader.close();
    }

    public CsvArrayReader getReader() {
        return this.reader;
    }

    public int[] getColumns() {
        return this.columns;
    }
}

