/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.reader;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.office.csv.core.CsvReader;
import cn.orionsec.kit.office.csv.reader.BaseCsvReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public class CsvArrayReader
extends BaseCsvReader<String[]> {
    protected int[] columns;
    protected int columnSize;
    private String columnEmpty;

    public CsvArrayReader(CsvReader reader) {
        this(reader, (Collection<String[]>)new ArrayList<String[]>(), (Consumer<String[]>)null);
    }

    public CsvArrayReader(CsvReader reader, Collection<String[]> rows) {
        this(reader, rows, (Consumer<String[]>)null);
    }

    public CsvArrayReader(CsvReader reader, Consumer<String[]> consumer) {
        this(reader, (Collection<String[]>)null, consumer);
    }

    protected CsvArrayReader(CsvReader reader, Collection<String[]> rows, Consumer<String[]> consumer) {
        super(reader, rows, consumer);
    }

    public CsvArrayReader columnOfNull(String text) {
        this.columnEmpty = text;
        return this;
    }

    public CsvArrayReader columnOfNullToEmpty() {
        this.columnEmpty = "";
        return this;
    }

    public CsvArrayReader columns(int ... columns) {
        this.columns = columns;
        this.columnSize = Arrays1.length((int[])columns);
        return this;
    }

    public CsvArrayReader capacity(int capacity) {
        if (!Arrays1.isEmpty((int[])this.columns)) {
            throw Exceptions.unsupported((String)"if the column is set, the capacity is not supported");
        }
        this.columnSize = capacity;
        return this;
    }

    @Override
    protected String[] parserRow(String[] row) {
        if (Arrays1.isEmpty((int[])this.columns) && (this.columnSize == 0 || row.length == this.columnSize)) {
            return row;
        }
        String[] array = new String[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            array[i] = Arrays1.isEmpty((int[])this.columns) ? this.get(row, i, this.columnEmpty) : this.get(row, this.columns[i], this.columnEmpty);
        }
        return array;
    }

    public int getColumnSize() {
        return this.columnSize;
    }
}

