/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.option;

import cn.orionsec.kit.office.csv.type.CsvEscapeMode;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CsvOption
implements Serializable {
    public static final int ESCAPE_MODE_DOUBLED = CsvEscapeMode.DOUBLE_QUALIFIER.getMode();
    public static final int ESCAPE_MODE_BACKSLASH = CsvEscapeMode.BACKSLASH.getMode();
    public static final int INITIAL_COLUMN_COUNT = 10;
    public static final int INITIAL_COLUMN_BUFFER_SIZE = 50;
    public static final int UNICODE = 1;
    public static final int OCTAL = 2;
    public static final int DECIMAL = 3;
    public static final int HEX = 4;
    protected char textQualifier;
    protected boolean useTextQualifier;
    protected char delimiter;
    protected char lineDelimiter;
    protected char comment;
    protected int escapeMode;
    protected boolean useCustomLineDelimiter;
    protected Charset charset;
    protected boolean trim;

    public CsvOption() {
        this.textQualifier = (char)34;
        this.useTextQualifier = true;
        this.delimiter = (char)44;
        this.lineDelimiter = '\u0000';
        this.comment = (char)35;
        this.escapeMode = ESCAPE_MODE_DOUBLED;
        this.charset = StandardCharsets.UTF_8;
        this.trim = false;
    }

    protected CsvOption(CsvOption option) {
        this.textQualifier = option.textQualifier;
        this.useTextQualifier = option.useTextQualifier;
        this.delimiter = option.delimiter;
        this.lineDelimiter = option.lineDelimiter;
        this.useCustomLineDelimiter = option.useCustomLineDelimiter;
        this.comment = option.comment;
        this.escapeMode = option.escapeMode;
        this.charset = option.charset;
        this.trim = option.trim;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public CsvOption setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
        return this;
    }

    public boolean isUseTextQualifier() {
        return this.useTextQualifier;
    }

    public CsvOption setUseTextQualifier(boolean useTextQualifier) {
        this.useTextQualifier = useTextQualifier;
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public CsvOption setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public char getLineDelimiter() {
        return this.lineDelimiter;
    }

    public CsvOption setLineDelimiter(char lineDelimiter) {
        this.useCustomLineDelimiter = lineDelimiter != '\u0000';
        this.lineDelimiter = lineDelimiter;
        return this;
    }

    public char getComment() {
        return this.comment;
    }

    public CsvOption setComment(char comment) {
        this.comment = comment;
        return this;
    }

    public int getEscapeMode() {
        return this.escapeMode;
    }

    public CsvOption setEscapeMode(int escapeMode) {
        this.escapeMode = escapeMode;
        return this;
    }

    public CsvOption setEscapeMode(CsvEscapeMode escapeMode) {
        this.escapeMode = escapeMode.getMode();
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public CsvOption setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public boolean isUseCustomLineDelimiter() {
        return this.useCustomLineDelimiter;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public CsvOption setTrim(boolean trim) {
        this.trim = trim;
        return this;
    }
}

