/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.core;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.able.SafeFlushable;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.office.csv.option.CsvOption;
import cn.orionsec.kit.office.csv.option.CsvWriterOption;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CsvWriter
implements SafeCloseable,
SafeFlushable {
    private Writer writer;
    private boolean firstColumn = true;
    private boolean closed;
    private CsvWriterOption option;

    public CsvWriter(String file) {
        this(file, ',', StandardCharsets.UTF_8);
    }

    public CsvWriter(String file, char delimiter) {
        this(file, delimiter, StandardCharsets.UTF_8);
    }

    public CsvWriter(String file, char delimiter, Charset charset) {
        Valid.notBlank((String)file, (String)"file can not be null", (Object[])new Object[0]);
        Valid.notNull((Object)charset, (String)"charset can not be null", (Object[])new Object[0]);
        this.option = new CsvWriterOption(delimiter, charset);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)Files1.openOutputStreamSafe((String)file), charset));
    }

    public CsvWriter(String file, CsvWriterOption option) {
        Valid.notBlank((String)file, (String)"file can not be null", (Object[])new Object[0]);
        Valid.notNull((Object)option, (String)"option not be null", (Object[])new Object[0]);
        Valid.notNull((Object)option.getCharset(), (String)"charset can not be null", (Object[])new Object[0]);
        this.option = option;
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)Files1.openOutputStreamSafe((String)file), option.getCharset()));
    }

    public CsvWriter(File file) {
        this(file, ',', StandardCharsets.UTF_8);
    }

    public CsvWriter(File file, char delimiter) {
        this(file, delimiter, StandardCharsets.UTF_8);
    }

    public CsvWriter(File file, char delimiter, Charset charset) {
        Valid.notNull((Object)file, (String)"file can not be null", (Object[])new Object[0]);
        Valid.notNull((Object)charset, (String)"charset can not be null", (Object[])new Object[0]);
        this.option = new CsvWriterOption(delimiter, charset);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)Files1.openOutputStreamSafe((File)file), charset));
    }

    public CsvWriter(File file, CsvWriterOption option) {
        Valid.notNull((Object)file, (String)"file can not be null", (Object[])new Object[0]);
        Valid.notNull((Object)option, (String)"option can not be null", (Object[])new Object[0]);
        Valid.notNull((Object)option.getCharset(), (String)"charset can not be null", (Object[])new Object[0]);
        this.option = option;
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)Files1.openOutputStreamSafe((File)file), option.getCharset()));
    }

    public CsvWriter(OutputStream out) {
        this((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), ',');
    }

    public CsvWriter(OutputStream out, char delimiter) {
        this((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), delimiter);
    }

    public CsvWriter(OutputStream out, char delimiter, Charset charset) {
        this((Writer)new OutputStreamWriter(out, charset), delimiter);
    }

    public CsvWriter(OutputStream out, CsvWriterOption option) {
        this((Writer)new OutputStreamWriter(out, option.getCharset()), option);
    }

    public CsvWriter(Writer writer) {
        this(writer, ',');
    }

    public CsvWriter(Writer writer, char delimiter) {
        Valid.notNull((Object)writer, (String)"writer can not be null", (Object[])new Object[0]);
        this.writer = writer;
        this.option = new CsvWriterOption(delimiter);
    }

    public CsvWriter(Writer writer, CsvWriterOption option) {
        Valid.notNull((Object)option, (String)"option can not be null", (Object[])new Object[0]);
        Valid.notNull((Object)writer, (String)"writer can not be null", (Object[])new Object[0]);
        this.writer = writer;
        this.option = option;
    }

    public void write(String content) throws IOException {
        this.write(content, !this.option.isTrim());
    }

    public void write(String content, boolean preserveSpaces) throws IOException {
        this.checkClosed();
        if (content == null) {
            content = "";
        }
        if (!this.firstColumn) {
            this.writer.write(this.option.getDelimiter());
        }
        boolean textQualify = this.option.isForceQualifier();
        if (!preserveSpaces && content.length() > 0) {
            content = content.trim();
        }
        if (!textQualify && this.option.isUseTextQualifier() && (content.indexOf(this.option.getTextQualifier()) > -1 || content.indexOf(this.option.getDelimiter()) > -1 || !this.option.isUseCustomLineDelimiter() && (content.indexOf(10) > -1 || content.indexOf(13) > -1) || this.option.isUseCustomLineDelimiter() && content.indexOf(this.option.getLineDelimiter()) > -1 || this.firstColumn && content.length() > 0 && content.charAt(0) == this.option.getComment() || this.firstColumn && content.length() == 0)) {
            textQualify = true;
        }
        if (this.option.isUseTextQualifier() && !textQualify && content.length() > 0 && preserveSpaces) {
            char lastLetter;
            char firstLetter = content.charAt(0);
            if (firstLetter == ' ' || firstLetter == '\t') {
                textQualify = true;
            }
            if (!(textQualify || content.length() <= 1 || (lastLetter = content.charAt(content.length() - 1)) != ' ' && lastLetter != '\t')) {
                textQualify = true;
            }
        }
        if (textQualify) {
            this.writer.write(this.option.getTextQualifier());
            if (this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_BACKSLASH) {
                content = CsvWriter.replace(content, "\\", "\\\\");
                content = CsvWriter.replace(content, "" + this.option.getTextQualifier(), "\\" + this.option.getTextQualifier());
            } else {
                content = CsvWriter.replace(content, "" + this.option.getTextQualifier(), "" + this.option.getTextQualifier() + this.option.getTextQualifier());
            }
        } else if (this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_BACKSLASH) {
            content = CsvWriter.replace(content, "\\", "\\\\");
            content = CsvWriter.replace(content, "" + this.option.getDelimiter(), "\\" + this.option.getDelimiter());
            if (this.option.isUseCustomLineDelimiter()) {
                content = CsvWriter.replace(content, "" + this.option.getLineDelimiter(), "\\" + this.option.getLineDelimiter());
            } else {
                content = CsvWriter.replace(content, "\r", "\\\r");
                content = CsvWriter.replace(content, "\n", "\\\n");
            }
            if (this.firstColumn && content.length() > 0 && content.charAt(0) == this.option.getComment()) {
                content = content.length() > 1 ? "\\" + this.option.getComment() + content.substring(1) : "\\" + this.option.getComment();
            }
        }
        this.writer.write(content);
        if (textQualify) {
            this.writer.write(this.option.getTextQualifier());
        }
        this.firstColumn = false;
    }

    public void writeComment(String comment) throws IOException {
        this.checkClosed();
        this.writer.write(this.option.getComment());
        this.writer.write(comment);
        if (this.option.isUseCustomLineDelimiter()) {
            this.writer.write(this.option.getLineDelimiter());
        } else {
            this.writer.write("\n");
        }
        this.firstColumn = true;
    }

    public void writeLine(String[] values) throws IOException {
        this.writeLine(values, !this.option.isTrim());
    }

    public void writeLine(String[] values, boolean preserveSpaces) throws IOException {
        if (values != null && values.length > 0) {
            for (String value : values) {
                this.write(value, preserveSpaces);
            }
            this.newLine();
        }
    }

    public void newLine() throws IOException {
        this.checkClosed();
        if (this.option.isUseCustomLineDelimiter()) {
            this.writer.write(this.option.getLineDelimiter());
        } else {
            this.writer.write("\n");
        }
        this.firstColumn = true;
    }

    public void flush() {
        Streams.flush((Flushable)this.writer);
    }

    private void checkClosed() {
        if (this.closed) {
            throw Exceptions.ioRuntime((String)"this instance already been closed");
        }
    }

    public void close() {
        if (!this.closed) {
            Streams.close((AutoCloseable)this.writer);
            this.writer = null;
            this.closed = true;
        }
    }

    public void setOption(CsvWriterOption option) {
        this.option = option;
    }

    public CsvWriterOption getOption() {
        return this.option;
    }

    private static String replace(String original, String pattern, String replace) {
        int len = pattern.length();
        int found = original.indexOf(pattern);
        if (found > -1) {
            StringBuilder sb = new StringBuilder();
            int start = 0;
            while (found != -1) {
                sb.append(original, start, found);
                sb.append(replace);
                start = found + len;
                found = original.indexOf(pattern, start);
            }
            sb.append(original.substring(start));
            return sb.toString();
        }
        return original;
    }
}

