/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv.convert.adapter;

import cn.orionsec.kit.lang.able.Adaptable;
import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.constant.Const;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.office.csv.CsvExt;
import cn.orionsec.kit.office.csv.reader.CsvArrayReader;
import cn.orionsec.kit.office.excel.writer.BaseExcelWriteable;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelAdapter
extends BaseExcelWriteable
implements Adaptable<ExcelAdapter>,
SafeCloseable {
    private final Sheet sheet;
    private final CsvArrayReader reader;
    private int skip;
    private String[] header;
    private int bufferLine;

    public ExcelAdapter(CsvExt csvExt) {
        this(csvExt.arrayReader());
    }

    public ExcelAdapter(CsvArrayReader reader) {
        super((Workbook)new XSSFWorkbook());
        this.reader = reader;
        this.sheet = this.workbook.createSheet();
        this.bufferLine = Const.N_100;
    }

    public ExcelAdapter bufferLine(int bufferLine) {
        this.bufferLine = bufferLine;
        return this;
    }

    public ExcelAdapter skip() {
        ++this.skip;
        return this;
    }

    public ExcelAdapter skip(int i) {
        this.skip += i;
        return this;
    }

    public ExcelAdapter header(String ... header) {
        this.header = header == null || header.length == 0 ? null : header;
        return this;
    }

    public ExcelAdapter forNew() {
        Collection lines;
        int i = 0;
        if (this.header != null) {
            Row headerRow = this.sheet.createRow(i++);
            for (int hi = 0; hi < this.header.length; ++hi) {
                Cell hc = headerRow.createCell(hi);
                hc.setCellValue(this.header[hi]);
            }
        }
        this.reader.skip(this.skip);
        while (!(lines = this.reader.clear().read(this.bufferLine).getRows()).isEmpty()) {
            for (String[] line : lines) {
                Row rr = this.sheet.createRow(i++);
                for (int ri = 0; ri < line.length; ++ri) {
                    Cell rc = rr.createCell(ri);
                    rc.setCellValue(line[ri]);
                }
            }
        }
        return this;
    }

    @Override
    public void close() {
        Streams.close((AutoCloseable)this.workbook);
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public CsvArrayReader getReader() {
        return this.reader;
    }
}

