/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.office.csv;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.define.collect.MutableMap;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.office.csv.core.CsvReader;
import cn.orionsec.kit.office.csv.option.CsvReaderOption;
import cn.orionsec.kit.office.csv.reader.CsvArrayReader;
import cn.orionsec.kit.office.csv.reader.CsvBeanReader;
import cn.orionsec.kit.office.csv.reader.CsvLambdaReader;
import cn.orionsec.kit.office.csv.reader.CsvMapReader;
import cn.orionsec.kit.office.csv.reader.CsvRawReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CsvExt
implements SafeCloseable {
    private final CsvReader reader;

    public CsvExt(File file) {
        this(Files1.openInputStreamSafe((File)file), null);
    }

    public CsvExt(File file, CsvReaderOption option) {
        this(Files1.openInputStreamSafe((File)file), option);
    }

    public CsvExt(String file) {
        this(Files1.openInputStreamSafe((String)file), null);
    }

    public CsvExt(String file, CsvReaderOption option) {
        this(Files1.openInputStreamSafe((String)file), option);
    }

    public CsvExt(InputStream in) {
        this(in, null);
    }

    public CsvExt(InputStream in, CsvReaderOption option) {
        this(new CsvReader(in, option));
    }

    public CsvExt(Reader reader) {
        this(reader, null);
    }

    public CsvExt(Reader reader, CsvReaderOption option) {
        this(new CsvReader(reader, option));
    }

    public CsvExt(CsvReader reader) {
        this.reader = reader;
    }

    public static CsvExt parse(String s) {
        return new CsvExt(CsvReader.parse(s));
    }

    public static CsvExt parse(String s, CsvReaderOption option) {
        return new CsvExt(CsvReader.parse(s, option));
    }

    public CsvArrayReader arrayReader() {
        return new CsvArrayReader(this.reader);
    }

    public CsvArrayReader arrayReader(Collection<String[]> rows) {
        return new CsvArrayReader(this.reader, rows);
    }

    public CsvArrayReader arrayReader(Consumer<String[]> consumer) {
        return new CsvArrayReader(this.reader, consumer);
    }

    public <K, V> CsvMapReader<K, V> mapReader() {
        return new CsvMapReader(this.reader);
    }

    public <K, V> CsvMapReader<K, V> mapReader(Collection<MutableMap<K, V>> rows) {
        return new CsvMapReader<K, V>(this.reader, rows);
    }

    public <K, V> CsvMapReader<K, V> mapReader(Consumer<MutableMap<K, V>> consumer) {
        return new CsvMapReader<K, V>(this.reader, consumer);
    }

    public <T> CsvBeanReader<T> beanReader(Class<T> targetClass) {
        return new CsvBeanReader<T>(this.reader, targetClass);
    }

    public <T> CsvBeanReader<T> beanReader(Class<T> targetClass, List<T> rows) {
        return new CsvBeanReader<T>(this.reader, targetClass, rows);
    }

    public <T> CsvBeanReader<T> beanReader(Class<T> targetClass, Consumer<T> consumer) {
        return new CsvBeanReader<T>(this.reader, targetClass, consumer);
    }

    public <T> CsvLambdaReader<T> lambdaReader(Supplier<T> supplier) {
        return new CsvLambdaReader<T>(this.reader, supplier);
    }

    public <T> CsvLambdaReader<T> lambdaReader(Collection<T> rows, Supplier<T> supplier) {
        return new CsvLambdaReader<T>(this.reader, rows, supplier);
    }

    public <T> CsvLambdaReader<T> lambdaReader(Consumer<T> consumer, Supplier<T> supplier) {
        return new CsvLambdaReader<T>(this.reader, consumer, supplier);
    }

    public CsvRawReader rawReader() {
        return new CsvRawReader(this.reader);
    }

    public CsvRawReader rawReader(Collection<String> rows) {
        return new CsvRawReader(this.reader, rows);
    }

    public CsvRawReader rawReader(Consumer<String> consumer) {
        return new CsvRawReader(this.reader, consumer);
    }

    public CsvReader getReader() {
        return this.reader;
    }

    public void close() {
        this.reader.close();
    }
}

