/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.VersionComparator;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class CharSequenceUtil {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    private static final int PAD_LIMIT = 8192;

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == CharSequenceUtil.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceUtil.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == CharSequenceUtil.isEmpty(str);
    }

    public static String emptyIfNull(CharSequence str) {
        return CharSequenceUtil.nullToEmpty(str);
    }

    public static String nullToEmpty(CharSequence str) {
        return CharSequenceUtil.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String emptyToDefault(CharSequence str, String defaultStr) {
        return CharSequenceUtil.isEmpty(str) ? defaultStr : str.toString();
    }

    public static String blankToDefault(CharSequence str, String defaultStr) {
        return CharSequenceUtil.isBlank(str) ? defaultStr : str.toString();
    }

    public static String emptyToNull(CharSequence str) {
        return CharSequenceUtil.isEmpty(str) ? null : str.toString();
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceUtil.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return false == CharSequenceUtil.hasEmpty(args);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return false == CharSequenceUtil.hasBlank(args);
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        if (null == str) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(str);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        if (CharSequenceUtil.isEmpty(str)) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(str);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        if (CharSequenceUtil.isBlank(str)) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(str);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        String strString = str.toString().trim();
        return NULL.equals(strString) || "undefined".equals(strString);
    }

    public static String trim(CharSequence str) {
        return null == str ? null : CharSequenceUtil.trim(str, 0);
    }

    public static String trimToEmpty(CharSequence str) {
        return str == null ? EMPTY : CharSequenceUtil.trim(str);
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = CharSequenceUtil.trim(str);
        return EMPTY.equals(trimStr) ? null : trimStr;
    }

    public static String trimStart(CharSequence str) {
        return CharSequenceUtil.trim(str, -1);
    }

    public static String trimEnd(CharSequence str) {
        return CharSequenceUtil.trim(str, 1);
    }

    public static String trim(CharSequence str, int mode) {
        String result;
        if (str == null) {
            result = null;
        } else {
            int start;
            int length = str.length();
            int end = length;
            if (mode <= 0) {
                for (start = 0; start < end && CharUtil.isBlankChar(str.charAt(start)); ++start) {
                }
            }
            if (mode >= 0) {
                while (start < end && CharUtil.isBlankChar(str.charAt(end - 1))) {
                    --end;
                }
            }
            result = start > 0 || end < length ? str.toString().substring(start, end) : str.toString();
        }
        return result;
    }

    public static boolean startWith(CharSequence str, char c) {
        if (CharSequenceUtil.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceUtil.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == prefix) {
            if (!ignoreEquals) {
                return false;
            }
            return null == str && null == prefix;
        }
        boolean isStartWith = ignoreCase ? str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase()) : str.toString().startsWith(prefix.toString());
        if (isStartWith) {
            return false == ignoreEquals || false == CharSequenceUtil.equals(str, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, false, true);
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, true);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence suffix : prefixes) {
            if (!CharSequenceUtil.startWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, char c) {
        if (CharSequenceUtil.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return null == str && null == suffix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.endWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceUtil.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceUtil.endWith(str, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return CharSequenceUtil.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceUtil.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!CharSequenceUtil.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (!CharSequenceUtil.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtil.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!str.toString().contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceUtil.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!CharSequenceUtil.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return CharSequenceUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return CharSequenceUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        if (CharSequenceUtil.isEmpty(str)) {
            return -1;
        }
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequenceUtil.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceUtil.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!CharSequenceUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequenceUtil.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceUtil.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!CharSequenceUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = CharSequenceUtil.indexOf(str, searchStr, index + 1, false)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(strToRemove)) {
            return CharSequenceUtil.str(str);
        }
        return str.toString().replace(strToRemove, EMPTY);
    }

    public static String removeAny(CharSequence str, CharSequence ... strsToRemove) {
        String result = CharSequenceUtil.str(str);
        if (CharSequenceUtil.isNotEmpty(str)) {
            for (CharSequence strToRemove : strsToRemove) {
                result = CharSequenceUtil.removeAll((CharSequence)result, strToRemove);
            }
        }
        return result;
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || ArrayUtil.isEmpty(chars)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (0 == len) {
            return CharSequenceUtil.str(str);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayUtil.contains(chars, c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeAllLineBreaks(CharSequence str) {
        return CharSequenceUtil.removeAll(str, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removePrefix(str, prefix));
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return CharSequenceUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().startsWith(prefix.toString().toLowerCase())) {
            return CharSequenceUtil.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return CharSequenceUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.str(str);
        }
        String str2 = str.toString();
        if (str2.toLowerCase().endsWith(suffix.toString().toLowerCase())) {
            return CharSequenceUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        return CharSequenceUtil.filter(str, c -> false == CharUtil.isBlankChar(c.charValue()));
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        if (CharSequenceUtil.equals(str, prefixOrSuffix)) {
            return EMPTY;
        }
        return CharSequenceUtil.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (CharSequenceUtil.startWith((CharSequence)str2, prefix)) {
            from = prefix.length();
        }
        if (CharSequenceUtil.endWith((CharSequence)str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(Math.min(from, to), Math.max(from, to));
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return CharSequenceUtil.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (CharSequenceUtil.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (CharSequenceUtil.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.prependIfMissing(str, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.appendIfMissing(str, suffix, suffix);
    }

    public static long[] splitToLong(CharSequence str, char separator) {
        return Convert.convert(long[].class, CharSequenceUtil.splitTrim(str, separator));
    }

    public static long[] splitToLong(CharSequence str, CharSequence separator) {
        return Convert.convert(long[].class, CharSequenceUtil.splitTrim(str, separator));
    }

    public static int[] splitToInt(CharSequence str, char separator) {
        return Convert.convert(int[].class, CharSequenceUtil.splitTrim(str, separator));
    }

    public static int[] splitToInt(CharSequence str, CharSequence separator) {
        return Convert.convert(int[].class, CharSequenceUtil.splitTrim(str, separator));
    }

    public static List<String> split(CharSequence str, char separator) {
        return CharSequenceUtil.split(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        return StrSplitter.splitToArray(str.toString(), CharSequenceUtil.str(separator), 0, false, false);
    }

    public static String[] splitToArray(CharSequence str, char separator) {
        return CharSequenceUtil.splitToArray(str, separator, 0);
    }

    public static String[] splitToArray(CharSequence str, char separator, int limit) {
        if (null == str) {
            return new String[0];
        }
        return StrSplitter.splitToArray(str.toString(), separator, limit, false, false);
    }

    public static List<String> split(CharSequence str, char separator, int limit) {
        return CharSequenceUtil.split(str, separator, limit, false, false);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return CharSequenceUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return CharSequenceUtil.splitTrim(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        return CharSequenceUtil.split(str, separator, limit, true, true);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        return CharSequenceUtil.split(str, separator, limit, true, true);
    }

    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        return CharSequenceUtil.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        return StrSplitter.split(str.toString(), separator, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return CharSequenceUtil.split(str, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (null == str) {
            return new ArrayList<String>(0);
        }
        String separatorStr = null == separator ? null : separator.toString();
        return StrSplitter.split(str.toString(), separatorStr, limit, isTrim, ignoreEmpty);
    }

    @Deprecated
    public static String[] split(CharSequence str, CharSequence separator) {
        return CharSequenceUtil.splitToArray(str, separator);
    }

    public static String[] split(CharSequence str, int len) {
        if (null == str) {
            return new String[0];
        }
        return StrSplitter.splitByLength(str.toString(), len);
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (null == str) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = NumberUtil.count(len, partLength);
        String[] array = new String[part];
        String str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = str2.substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subByCodePoint(CharSequence str, int fromIndex, int toIndex) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        str.toString().codePoints().skip(fromIndex).limit(subLen).forEach(v -> sb.append(Character.toChars(v)));
        return sb.toString();
    }

    public static String subPreGbk(CharSequence str, int len, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int counterOfDoubleByte = 0;
        byte[] b = str.toString().getBytes(CharsetUtil.CHARSET_GBK);
        if (b.length <= len) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            ++len;
        }
        return new String(b, 0, len, CharsetUtil.CHARSET_GBK) + suffix;
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        return CharSequenceUtil.sub(string, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (CharSequenceUtil.isEmpty(string)) {
            return null;
        }
        return CharSequenceUtil.sub(string, fromIndex, string.length());
    }

    public static String subSufByLength(CharSequence string, int length) {
        if (CharSequenceUtil.isEmpty(string)) {
            return null;
        }
        if (length <= 0) {
            return EMPTY;
        }
        return CharSequenceUtil.sub(string, -length, string.length());
    }

    public static String subWithLength(String input, int fromIndex, int length) {
        return CharSequenceUtil.sub(input, fromIndex, fromIndex + length);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            return null == string ? null : EMPTY;
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            return null == string ? null : EMPTY;
        }
        if (separator == null) {
            return EMPTY;
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            return null == string ? null : EMPTY;
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return EMPTY;
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return CharSequenceUtil.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String[] subBetweenAll(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.hasEmpty(str, prefix, suffix) || !CharSequenceUtil.contains(str, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = CharSequenceUtil.split(str, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (String fragment : split) {
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, suffixIndex));
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] subBetweenAll(CharSequence str, CharSequence prefixAndSuffix) {
        return CharSequenceUtil.subBetweenAll(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return EMPTY;
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(CharSequence str, int count) {
        int n;
        if (null == str) {
            return null;
        }
        if (count <= 0 || str.length() == 0) {
            return EMPTY;
        }
        if (count == 1) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String repeatByLength(CharSequence str, int padLen) {
        if (null == str) {
            return null;
        }
        if (padLen <= 0) {
            return EMPTY;
        }
        int strLen = str.length();
        if (strLen == padLen) {
            return str.toString();
        }
        if (strLen > padLen) {
            return CharSequenceUtil.subPre(str, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str.charAt(i % strLen);
        }
        return new String(padding);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence conjunction) {
        if (count <= 0) {
            return EMPTY;
        }
        StrBuilder builder = StrBuilder.create();
        boolean isFirst = true;
        while (count-- > 0) {
            if (isFirst) {
                isFirst = false;
            } else if (CharSequenceUtil.isNotEmpty(conjunction)) {
                builder.append(conjunction);
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        return CharSequenceUtil.equalsAny(str1, true, strs);
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        return CharSequenceUtil.equalsAny(str1, false, strs);
    }

    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return false;
        }
        for (CharSequence str : strs) {
            if (!CharSequenceUtil.equals(str1, str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsCharAt(CharSequence str, int position, char c) {
        if (null == str || position < 0) {
            return false;
        }
        return str.length() > position && c == str.charAt(position);
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return NULL;
        }
        if (ArrayUtil.isEmpty(params) || CharSequenceUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return CharSequenceUtil.bytes(str, CharsetUtil.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return CharSequenceUtil.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence str, String charset) {
        return CharSequenceUtil.bytes(str, CharSequenceUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static ByteBuffer byteBuffer(CharSequence str, String charset) {
        return ByteBuffer.wrap(CharSequenceUtil.bytes(str, charset));
    }

    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        return CharSequenceUtil.wrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        return CharSequenceUtil.nullToEmpty(prefix).concat(CharSequenceUtil.nullToEmpty(str)).concat(CharSequenceUtil.nullToEmpty(suffix));
    }

    public static String[] wrapAllWithPair(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharSequenceUtil.wrapAll(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrap(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        int len = 0;
        if (CharSequenceUtil.isNotEmpty(str)) {
            len += str.length();
        }
        if (CharSequenceUtil.isNotEmpty(prefix)) {
            len += str.length();
        }
        if (CharSequenceUtil.isNotEmpty(suffix)) {
            len += str.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (CharSequenceUtil.isNotEmpty(prefix) && !CharSequenceUtil.startWith(str, prefix)) {
            sb.append(prefix);
        }
        if (CharSequenceUtil.isNotEmpty(str)) {
            sb.append(str);
        }
        if (CharSequenceUtil.isNotEmpty(suffix) && !CharSequenceUtil.endWith(str, suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static String[] wrapAllWithPairIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        return CharSequenceUtil.wrapAllIfMissing(prefixAndSuffix, prefixAndSuffix, strs);
    }

    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrapIfMissing(strs[i], prefix, suffix);
        }
        return results;
    }

    public static String unWrap(CharSequence str, String prefix, String suffix) {
        if (CharSequenceUtil.isWrap(str, prefix, suffix)) {
            return CharSequenceUtil.sub(str, prefix.length(), str.length() - suffix.length());
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return CharSequenceUtil.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return CharSequenceUtil.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        if (ArrayUtil.hasNull(str, prefix, suffix)) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix) && str2.endsWith(suffix);
    }

    public static boolean isWrap(CharSequence str, String wrapper) {
        return CharSequenceUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char wrapper) {
        return CharSequenceUtil.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(CharSequence str, int length, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str, length);
        }
        return CharSequenceUtil.repeatByLength(padStr, length - strLen).concat(str.toString());
    }

    public static String padPre(CharSequence str, int length, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str, length);
        }
        return CharSequenceUtil.repeat(padChar, length - strLen).concat(str.toString());
    }

    public static String padAfter(CharSequence str, int length, char padChar) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.sub(str, strLen - length, strLen);
        }
        return str.toString().concat(CharSequenceUtil.repeat(padChar, length - strLen));
    }

    public static String padAfter(CharSequence str, int length, CharSequence padStr) {
        if (null == str) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subSufByLength(str, length);
        }
        return str.toString().concat(CharSequenceUtil.repeatByLength(padStr, length - strLen));
    }

    public static String center(CharSequence str, int size) {
        return CharSequenceUtil.center(str, size, ' ');
    }

    public static String center(CharSequence str, int size, char padChar) {
        if (str == null || size <= 0) {
            return CharSequenceUtil.str(str);
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.toString();
        }
        str = CharSequenceUtil.padPre(str, strLen + pads / 2, padChar);
        str = CharSequenceUtil.padAfter(str, size, padChar);
        return str.toString();
    }

    public static String center(CharSequence str, int size, CharSequence padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return CharSequenceUtil.str(str);
        }
        if (CharSequenceUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str.toString();
        }
        str = CharSequenceUtil.padPre(str, strLen + pads / 2, padStr);
        str = CharSequenceUtil.padAfter(str, size, padStr);
        return str.toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (CharSequenceUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        String content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharSequenceUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.toString().compareToIgnoreCase(str2.toString());
    }

    public static int compareVersion(CharSequence version1, CharSequence version2) {
        return VersionComparator.INSTANCE.compare(CharSequenceUtil.str(version1), CharSequenceUtil.str(version2));
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceUtil.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissingIgnoreCase(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceUtil.appendIfMissing(str, suffix, true, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str == null || CharSequenceUtil.isEmpty(suffix) || CharSequenceUtil.endWith(str, suffix, ignoreCase)) {
            return CharSequenceUtil.str(str);
        }
        if (ArrayUtil.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharSequenceUtil.endWith(str, testSuffix, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceUtil.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissingIgnoreCase(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceUtil.prependIfMissing(str, prefix, true, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || CharSequenceUtil.isEmpty(prefix) || CharSequenceUtil.startWith(str, prefix, ignoreCase)) {
            return CharSequenceUtil.str(str);
        }
        if (prefixes != null && prefixes.length > 0) {
            for (CharSequence s : prefixes) {
                if (!CharSequenceUtil.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceUtil.replace(str, 0, searchStr, replacement, true);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceUtil.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        return CharSequenceUtil.replace(str, 0, searchStr, replacement, ignoreCase);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        int index;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(searchStr)) {
            return CharSequenceUtil.str(str);
        }
        if (null == replacement) {
            replacement = EMPTY;
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return CharSequenceUtil.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StrBuilder result = StrBuilder.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        while ((index = CharSequenceUtil.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return CharSequenceUtil.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return CharSequenceUtil.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static String replace(CharSequence str, Pattern pattern, Func1<java.util.regex.Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str, pattern, replaceFun);
    }

    public static String replace(CharSequence str, String regex, Func1<java.util.regex.Matcher, String> replaceFun) {
        return ReUtil.replaceAll(str, regex, replaceFun);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return CharSequenceUtil.replace(str, startInclude, endExclude, '*');
    }

    public static String desensitized(CharSequence str, DesensitizedUtil.DesensitizedType desensitizedType) {
        return DesensitizedUtil.desensitized(str, desensitizedType);
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(chars)) {
            return CharSequenceUtil.str(str);
        }
        return CharSequenceUtil.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(chars)) {
            return CharSequenceUtil.str(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int byteLength(CharSequence cs, Charset charset) {
        return cs == null ? 0 : cs.toString().getBytes(charset).length;
    }

    public static int totalLength(CharSequence ... strs) {
        int totalLength = 0;
        for (CharSequence str : strs) {
            totalLength += null == str ? 0 : str.length();
        }
        return totalLength;
    }

    public static String maxLength(CharSequence string, int length) {
        Assert.isTrue(length > 0);
        if (null == string) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return CharSequenceUtil.sub(string, 0, length) + "...";
    }

    public <T extends CharSequence> T firstNonNull(T ... strs) {
        return (T)((CharSequence)ArrayUtil.firstNonNull(strs));
    }

    public <T extends CharSequence> T firstNonEmpty(T ... strs) {
        return (T)ArrayUtil.firstMatch(CharSequenceUtil::isNotEmpty, strs);
    }

    public <T extends CharSequence> T firstNonBlank(T ... strs) {
        return (T)ArrayUtil.firstMatch(CharSequenceUtil::isNotBlank, strs);
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + CharSequenceUtil.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + CharSequenceUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String lowerFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            return Character.toLowerCase(firstChar) + CharSequenceUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String filter(CharSequence str, Filter<Character> filter) {
        if (str == null || filter == null) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str) {
        if (null == str) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String swapCase(String str) {
        if (CharSequenceUtil.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String toUnderlineCase(CharSequence str) {
        return CharSequenceUtil.toSymbolCase(str, '_');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StrBuilder sb = new StrBuilder();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && !Character.isLowerCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (symbol != c && sb.length() > 0 && Character.isUpperCase(sb.charAt(-1)) && Character.isLowerCase(c)) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence name) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (CharSequenceUtil.contains((CharSequence)name2, '_')) {
            int length = name2.length();
            StringBuilder sb = new StringBuilder(length);
            boolean upperCase = false;
            for (int i = 0; i < length; ++i) {
                char c = name2.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return name2;
    }

    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        String str2 = str.toString();
        return str2.startsWith(prefix.toString()) && str2.endsWith(suffix.toString());
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StrBuilder strBuilder(CharSequence ... strs) {
        return StrBuilder.create(strs);
    }

    public static String getGeneralField(CharSequence getOrSetMethodName) {
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return CharSequenceUtil.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        if (getOrSetMethodNameStr.startsWith("is")) {
            return CharSequenceUtil.removePreAndLowerFirst(getOrSetMethodName, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return CharSequenceUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return CharSequenceUtil.upperFirstAndAddPre(fieldName, "get");
    }

    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        StrBuilder sb = new StrBuilder();
        for (CharSequence str : strs) {
            sb.append(isNullToEmpty ? CharSequenceUtil.nullToEmpty(str) : str);
        }
        return sb.toString();
    }

    public static String brief(CharSequence str, int maxLength) {
        if (null == str) {
            return null;
        }
        if (maxLength <= 0 || str.length() <= maxLength) {
            return str.toString();
        }
        int w = maxLength / 2;
        int l = str.length() + 3;
        String str2 = str.toString();
        return CharSequenceUtil.format("{}...{}", str2.substring(0, maxLength - w), str2.substring(l - w));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        return ArrayUtil.join(objs, conjunction);
    }

    public static <T> String join(CharSequence conjunction, Iterable<T> iterable) {
        return CollUtil.join(iterable, conjunction);
    }

    public static boolean isAllCharMatch(CharSequence value, Matcher<Character> matcher) {
        if (StrUtil.isBlank(value)) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (matcher.match(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static String move(CharSequence str, int startInclude, int endExclude, int moveLength) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (Math.abs(moveLength) > len) {
            moveLength %= len;
        }
        StrBuilder strBuilder = StrBuilder.create(len);
        if (moveLength > 0) {
            int endAfterMove = Math.min(endExclude + moveLength, str.length());
            strBuilder.append(str.subSequence(0, startInclude)).append(str.subSequence(endExclude, endAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(endAfterMove, str.length()));
        } else if (moveLength < 0) {
            int startAfterMove = Math.max(startInclude + moveLength, 0);
            strBuilder.append(str.subSequence(0, startAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(startAfterMove, startInclude)).append(str.subSequence(endExclude, str.length()));
        } else {
            return CharSequenceUtil.str(str);
        }
        return strBuilder.toString();
    }
}

