/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt;

import cn.hutool.jwt.Claims;
import java.util.Date;
import java.util.Map;

public class JWTPayload
extends Claims {
    private static final long serialVersionUID = 1L;
    public static String ISSUER = "iss";
    public static String SUBJECT = "sub";
    public static String AUDIENCE = "aud";
    public static String EXPIRES_AT = "exp";
    public static String NOT_BEFORE = "nbf";
    public static String ISSUED_AT = "iat";
    public static String JWT_ID = "jti";

    public JWTPayload setIssuer(String issuer) {
        this.setClaim(ISSUER, issuer);
        return this;
    }

    public JWTPayload setSubject(String subject) {
        this.setClaim(SUBJECT, subject);
        return this;
    }

    public JWTPayload setAudience(String ... audience) {
        this.setClaim(AUDIENCE, audience);
        return this;
    }

    public JWTPayload setExpiresAt(Date expiresAt) {
        this.setClaim(EXPIRES_AT, expiresAt);
        return this;
    }

    public JWTPayload setNotBefore(Date notBefore) {
        this.setClaim(NOT_BEFORE, notBefore);
        return this;
    }

    public JWTPayload setIssuedAt(Date issuedAt) {
        this.setClaim(ISSUED_AT, issuedAt);
        return this;
    }

    public JWTPayload setJWTId(String jwtId) {
        this.setClaim(JWT_ID, jwtId);
        return this;
    }

    public JWTPayload addPayloads(Map<String, ?> payloadClaims) {
        this.putAll(payloadClaims);
        return this;
    }
}

