/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.func.Func0;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.StampedLock;

public class SimpleCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> cache = new WeakHashMap();
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        long stamp = this.lock.readLock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Func0<V> supplier) {
        V v;
        block7: {
            if (null == supplier) {
                return this.get(key);
            }
            long stamp = this.lock.readLock();
            try {
                v = this.cache.get(key);
                if (null != v) break block7;
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (0L == writeStamp) {
                    this.lock.unlockRead(stamp);
                    writeStamp = this.lock.writeLock();
                }
                stamp = writeStamp;
                v = this.cache.get(key);
                if (null != v) break block7;
                try {
                    v = supplier.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.cache.put(key, v);
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        long stamp = this.lock.writeLock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        long stamp = this.lock.writeLock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

