/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha.generator;

import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -5514819971774091076L;
    private static final String operators = "+-*";
    private int numberLength;

    public MathGenerator() {
        this(2);
    }

    public MathGenerator(int numberLength) {
        this.numberLength = numberLength;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        String number1 = Integer.toString(RandomUtil.randomInt(limit));
        String number2 = Integer.toString(RandomUtil.randomInt(limit));
        number1 = StrUtil.padAfter((CharSequence)number1, this.numberLength, ' ');
        number2 = StrUtil.padAfter((CharSequence)number2, this.numberLength, ' ');
        String code = StrUtil.builder().append(number1).append(RandomUtil.randomChar(operators)).append(number2).append('=').toString();
        return code;
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int a = Integer.parseInt(StrUtil.sub(code, 0, this.numberLength).trim());
        char operator = code.charAt(this.numberLength);
        int b = Integer.parseInt(StrUtil.sub(code, this.numberLength + 1, this.numberLength + 1 + this.numberLength).trim());
        switch (operator) {
            case '+': {
                return a + b == result;
            }
            case '-': {
                return a - b == result;
            }
            case '*': {
                return a * b == result;
            }
        }
        return false;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat('0', this.numberLength));
    }
}

