/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.aio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.socket.SocketConfig;
import cn.hutool.socket.aio.AcceptHandler;
import cn.hutool.socket.aio.IoAction;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;

public class AioServer {
    private static final Log log = LogFactory.get();
    private static AcceptHandler ACCEPT_HANDLER = new AcceptHandler();
    private AsynchronousChannelGroup group;
    private AsynchronousServerSocketChannel channel;
    protected IoAction<ByteBuffer> ioAction;
    protected SocketConfig config;

    public AioServer(int port) {
        this(new InetSocketAddress(port), new SocketConfig());
    }

    public AioServer(InetSocketAddress address, SocketConfig config) {
        this.config = config;
        this.init(address);
    }

    public AioServer init(InetSocketAddress address) {
        try {
            this.group = AsynchronousChannelGroup.withFixedThreadPool(this.config.getThreadPoolSize(), ThreadFactoryBuilder.create().setNamePrefix("Huool-socket-").build());
            this.channel = AsynchronousServerSocketChannel.open(this.group).bind(address);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    public void start(boolean sync) {
        try {
            this.doStart(sync);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public <T> AioServer setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.ioAction;
    }

    public AioServer setIoAction(IoAction<ByteBuffer> ioAction) {
        this.ioAction = ioAction;
        return this;
    }

    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    public AioServer accept() {
        this.channel.accept(this, ACCEPT_HANDLER);
        return this;
    }

    public boolean isOpen() {
        return null == this.channel ? false : this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IoUtil.close(this.channel);
        if (null != this.group && !this.group.isShutdown()) {
            try {
                this.group.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        AioServer aioServer = this;
        synchronized (aioServer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart(boolean sync) throws IOException {
        log.debug("Aio Server started, waiting for accept.", new Object[0]);
        this.accept();
        if (sync) {
            AioServer aioServer = this;
            synchronized (aioServer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

