/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelBase<T extends ExcelBase<T>>
implements Closeable {
    protected boolean isClosed;
    protected Workbook workbook;
    protected Sheet sheet;

    public ExcelBase(Sheet sheet) {
        Assert.notNull(sheet, "No Sheet provided.", new Object[0]);
        this.sheet = sheet;
        this.workbook = sheet.getWorkbook();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public int getSheetCount() {
        return this.workbook.getNumberOfSheets();
    }

    public List<Sheet> getSheets() {
        int totalSheet = this.getSheetCount();
        ArrayList<Sheet> result = new ArrayList<Sheet>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i));
        }
        return result;
    }

    public List<String> getSheetNames() {
        int totalSheet = this.workbook.getNumberOfSheets();
        ArrayList<String> result = new ArrayList<String>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i).getSheetName());
        }
        return result;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public T setSheet(String sheetName) {
        this.sheet = this.workbook.getSheet(sheetName);
        if (null == this.sheet) {
            this.sheet = this.workbook.createSheet(sheetName);
        }
        return (T)this;
    }

    public T setSheet(int sheetIndex) {
        try {
            this.sheet = this.workbook.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException e) {
            this.sheet = this.workbook.createSheet();
        }
        if (null == this.sheet) {
            this.sheet = this.workbook.createSheet();
        }
        return (T)this;
    }

    public Cell getCell(int x, int y) {
        return this.getCell(x, y, false);
    }

    public Cell getOrCreateCell(int x, int y) {
        return this.getCell(x, y, true);
    }

    public Cell getCell(int x, int y, boolean isCreateIfNotExist) {
        Row row;
        Row row2 = row = isCreateIfNotExist ? RowUtil.getOrCreateRow(this.sheet, y) : this.sheet.getRow(y);
        if (null != row) {
            return isCreateIfNotExist ? CellUtil.getOrCreateCell(row, x) : row.getCell(x);
        }
        return null;
    }

    public Row getOrCreateRow(int y) {
        return RowUtil.getOrCreateRow(this.sheet, y);
    }

    public CellStyle getOrCreateCellStyle(int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = cell.getCellStyle();
        if (null == cellStyle) {
            cellStyle = this.workbook.createCellStyle();
            cell.setCellStyle(cellStyle);
        }
        return cellStyle;
    }

    public CellStyle getOrCreateRowStyle(int y) {
        Row row = this.getOrCreateRow(y);
        CellStyle rowStyle = row.getRowStyle();
        if (null == rowStyle) {
            rowStyle = this.workbook.createCellStyle();
            row.setRowStyle(rowStyle);
        }
        return rowStyle;
    }

    public CellStyle getOrCreateColumnStyle(int x) {
        CellStyle columnStyle = this.sheet.getColumnStyle(x);
        if (null == columnStyle) {
            columnStyle = this.workbook.createCellStyle();
            this.sheet.setDefaultColumnStyle(x, columnStyle);
        }
        return columnStyle;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.workbook);
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }
}

