/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.PoiChecker;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.sax.Excel03SaxReader;
import cn.hutool.poi.excel.sax.Excel07SaxReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelUtil {
    public static void readBySax(String path, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream(path), sheetIndex, rowHandler);
    }

    public static void readBySax(File file, int sheetIndex, RowHandler rowHandler) {
        ExcelUtil.readBySax(FileUtil.getInputStream(file), sheetIndex, rowHandler);
    }

    public static void readBySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        if (ExcelUtil.isXlsx(in = IoUtil.toMarkSupportStream(in))) {
            ExcelUtil.read07BySax(in, sheetIndex, rowHandler);
        } else {
            ExcelUtil.read03BySax(in, sheetIndex, rowHandler);
        }
    }

    public static Excel07SaxReader read07BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel07SaxReader(rowHandler).read(in, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel07SaxReader read07BySax(File file, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel07SaxReader(rowHandler).read(file, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel07SaxReader read07BySax(String path, int sheetIndex, RowHandler rowHandler) {
        try {
            return (Excel07SaxReader)new Excel07SaxReader(rowHandler).read(path, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel03SaxReader read03BySax(InputStream in, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel03SaxReader(rowHandler).read(in, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel03SaxReader read03BySax(File file, int sheetIndex, RowHandler rowHandler) {
        try {
            return new Excel03SaxReader(rowHandler).read(file, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Excel03SaxReader read03BySax(String path, int sheetIndex, RowHandler rowHandler) {
        try {
            return (Excel03SaxReader)new Excel03SaxReader(rowHandler).read(path, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelUtil.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelUtil.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        try {
            return new ExcelReader(bookFilePath, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        try {
            return new ExcelReader(bookFile, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        try {
            return new ExcelReader(bookFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelUtil.getReader(bookStream, 0, true);
    }

    public static ExcelReader getReader(InputStream bookStream, boolean closeAfterRead) {
        try {
            return ExcelUtil.getReader(bookStream, 0, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        try {
            return new ExcelReader(bookStream, sheetIndex, true);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetIndex, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        try {
            return new ExcelReader(bookStream, sheetName, true);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetName, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter() {
        try {
            return new ExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        try {
            return new ExcelWriter(isXlsx);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(String destFilePath) {
        try {
            return new ExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(File destFile) {
        try {
            return new ExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        try {
            return new ExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        try {
            return new ExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static boolean isXls(InputStream in) {
        PushbackInputStream pin = IoUtil.toPushbackStream(in, 8);
        try {
            return FileMagic.valueOf((InputStream)pin) == FileMagic.OLE2;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isXlsx(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            return FileMagic.valueOf((InputStream)in) == FileMagic.OOXML;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            throw PoiChecker.transError(e);
        }
    }

    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        if (null == book) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = StrUtil.isBlank(sheetName) ? "sheet1" : sheetName);
        if (null == sheet) {
            sheet = book.createSheet(sheetName);
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }
}

