/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.util.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.Connector;
import cn.hutool.extra.ssh.JschRuntimeException;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class JschUtil {
    public static final String SSH_NONE = "none";
    private static Map<String, Session> sessionPool = new ConcurrentHashMap<String, Session>();
    private static volatile AtomicInteger alternativePort = new AtomicInteger(10000);
    private static final Object lock = new Object();

    public static int generateLocalPort() {
        int validPort = alternativePort.get();
        while (!NetUtil.isUsableLocalPort(validPort)) {
            validPort = alternativePort.incrementAndGet();
        }
        return validPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key = StrUtil.format((CharSequence)"{}@{}:{}", sshUser, sshHost, sshPort);
        Session session = sessionPool.get(key);
        if (null == session) {
            Object object = lock;
            synchronized (object) {
                session = sessionPool.get(key);
                if (null == session || !session.isConnected()) {
                    session = JschUtil.openSession(sshHost, sshPort, sshUser, sshPass);
                    sessionPool.put(key, session);
                }
            }
        }
        return session;
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        Session session;
        if (StrUtil.isEmpty(sshHost) || sshPort < 0 || StrUtil.isEmpty(sshUser) || StrUtil.isEmpty(sshPass)) {
            return null;
        }
        try {
            session = new JSch().getSession(sshUser, sshHost, sshPort);
            session.setPassword(sshPass);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return session;
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws JschRuntimeException {
        if (session != null && session.isConnected()) {
            try {
                session.setPortForwardingL(localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                throw new JschRuntimeException("From [" + remoteHost + "] Mapping to [" + localPort + "] error\uff01", e);
            }
            return true;
        }
        return false;
    }

    public static boolean unBindPort(Session session, int localPort) {
        try {
            session.delPortForwardingL(localPort);
            return true;
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
    }

    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws JschRuntimeException {
        Session session = JschUtil.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        if (session == null) {
            throw new JschRuntimeException("Error to create SSH Session\uff01");
        }
        int localPort = JschUtil.generateLocalPort();
        JschUtil.bindPort(session, remoteHost, remotePort, localPort);
        return localPort;
    }

    public static void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static void close(String key) {
        Session session = sessionPool.get(key);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        sessionPool.remove(key);
    }

    public static void closeAll() {
        Collection<Session> sessions = sessionPool.values();
        for (Session session : sessions) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
        sessionPool.clear();
    }
}

