/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.Session;
import cn.hutool.db.SqlConnRunner;
import cn.hutool.db.SqlRunner;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlFormatter;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class DbUtil {
    private static final Log log = LogFactory.get();

    public static SqlConnRunner newSqlConnRunner(Dialect dialect) {
        return SqlConnRunner.create(dialect);
    }

    public static SqlConnRunner newSqlConnRunner(DataSource ds) {
        return SqlConnRunner.create(ds);
    }

    public static SqlConnRunner newSqlConnRunner(Connection conn) {
        return SqlConnRunner.create(DialectFactory.newDialect(conn));
    }

    public static SqlRunner newSqlRunner() {
        return SqlRunner.create(DbUtil.getDs());
    }

    public static SqlRunner newSqlRunner(DataSource ds) {
        return SqlRunner.create(ds);
    }

    public static SqlRunner newSqlRunner(DataSource ds, Dialect dialect) {
        return SqlRunner.create(ds, dialect);
    }

    public static Session newSession() {
        return Session.create(DbUtil.getDs());
    }

    public static Session newSession(DataSource ds) {
        return Session.create(ds);
    }

    public static Session newSession(Connection conn) {
        return Session.create(conn);
    }

    public static void close(Object ... objsToClose) {
        for (Object obj : objsToClose) {
            if (obj instanceof AutoCloseable) {
                IoUtil.close((AutoCloseable)obj);
                continue;
            }
            if (obj instanceof Closeable) {
                IoUtil.close((Closeable)obj);
                continue;
            }
            try {
                if (obj == null) continue;
                if (obj instanceof ResultSet) {
                    ((ResultSet)obj).close();
                    continue;
                }
                if (obj instanceof Statement) {
                    ((Statement)obj).close();
                    continue;
                }
                if (obj instanceof PreparedStatement) {
                    ((PreparedStatement)obj).close();
                    continue;
                }
                if (obj instanceof Connection) {
                    ((Connection)obj).close();
                    continue;
                }
                log.warn("Object {} not a ResultSet or Statement or PreparedStatement or Connection!", obj.getClass().getName());
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public static DataSource getDs() {
        return DSFactory.get();
    }

    public static DataSource getDs(String group) {
        return DSFactory.get(group);
    }

    public static DataSource getJndiDsWithLog(String jndiName) {
        try {
            return DbUtil.getJndiDs(jndiName);
        }
        catch (DbRuntimeException e) {
            log.error(e.getCause(), "Find JNDI datasource error!", new Object[0]);
            return null;
        }
    }

    public static DataSource getJndiDs(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static List<String> getTables(DataSource ds) {
        return DbUtil.getTables(ds, TableType.TABLE);
    }

    public static List<String> getTables(DataSource ds, TableType ... types) {
        return DbUtil.getTables(ds, null, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, TableType ... types) {
        return DbUtil.getTables(ds, schema, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, String tableName, TableType ... types) {
        ResultSet rs;
        Connection conn;
        ArrayList<String> tables;
        block6: {
            tables = new ArrayList<String>();
            conn = null;
            rs = null;
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getTables(conn.getCatalog(), schema, tableName, Convert.toStrArray(types));
            if (rs != null) break block6;
            List<String> list = null;
            DbUtil.close(rs, conn);
            return list;
        }
        try {
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                if (!StrUtil.isNotBlank(table)) continue;
                tables.add(table);
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return tables;
    }

    public static String[] getColumnNames(ResultSet rs) throws DbRuntimeException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(conn.getCatalog(), null, tableName, null);
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
            stringArray = columnNames.toArray(new String[columnNames.size()]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return stringArray;
    }

    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] columnNames = DbUtil.getColumnNames(ds, tableName);
        return Entity.create(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        Table table = Table.create(tableName);
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getPrimaryKeys(conn.getCatalog(), null, tableName);
            while (rs.next()) {
                table.addPk(rs.getString("COLUMN_NAME"));
            }
            rs = metaData.getColumns(conn.getCatalog(), null, tableName, null);
            while (rs.next()) {
                table.setColumn(Column.create(tableName, rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return table;
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Collection<Object> params) throws SQLException {
        return DbUtil.fillParams(ps, params.toArray(new Object[params.size()]));
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Object ... params) throws SQLException {
        if (ArrayUtil.isEmpty(params)) {
            return ps;
        }
        for (int i = 0; i < params.length; ++i) {
            int paramIndex = i + 1;
            Object param = params[i];
            if (null != param) {
                if (param instanceof java.util.Date) {
                    if (param instanceof Date) {
                        ps.setDate(paramIndex, (Date)param);
                        continue;
                    }
                    if (param instanceof Time) {
                        ps.setTime(paramIndex, (Time)param);
                        continue;
                    }
                    ps.setTimestamp(paramIndex, DbUtil.toSqlTimestamp((java.util.Date)param));
                    continue;
                }
                if (param instanceof Number) {
                    if (param instanceof BigInteger) {
                        ps.setLong(paramIndex, ((BigInteger)param).longValue());
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        ps.setBigDecimal(paramIndex, (BigDecimal)param);
                        continue;
                    }
                    ps.setObject(paramIndex, param);
                    continue;
                }
                ps.setObject(paramIndex, param);
                continue;
            }
            ParameterMetaData pmd = ps.getParameterMetaData();
            int sqlType = 12;
            try {
                sqlType = pmd.getParameterType(paramIndex);
            }
            catch (SQLException e) {
                // empty catch block
            }
            ps.setNull(paramIndex, sqlType);
        }
        return ps;
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Collection<Object> params) throws SQLException {
        return DbUtil.prepareStatement(conn, sql, params.toArray(new Object[params.size()]));
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        PreparedStatement ps = StrUtil.startWithIgnoreCase(sql, "insert") ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
        return DbUtil.fillParams(ps, params);
    }

    public static Long getGeneratedKeyOfLong(PreparedStatement ps) throws SQLException {
        Long l;
        ResultSet rs = null;
        try {
            rs = ps.getGeneratedKeys();
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            l = generatedKey;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return l;
    }

    public static List<Object> getGeneratedKeys(PreparedStatement ps) throws SQLException {
        ArrayList<Object> arrayList;
        ArrayList<Object> keys = new ArrayList<Object>();
        ResultSet rs = null;
        int i = 1;
        try {
            rs = ps.getGeneratedKeys();
            if (rs != null && rs.next()) {
                keys.add(rs.getObject(i++));
            }
            arrayList = keys;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return arrayList;
    }

    public static String buildEqualsWhere(Entity entity, List<Object> paramValues) {
        if (null == entity || entity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        boolean isNotFirst = false;
        for (Map.Entry entry : entity.entrySet()) {
            if (isNotFirst) {
                sb.append(" and ");
            } else {
                isNotFirst = true;
            }
            sb.append("`").append((String)entry.getKey()).append("`").append(" = ?");
            paramValues.add(entry.getValue());
        }
        return sb.toString();
    }

    public static Condition[] buildConditions(Entity entity) {
        if (null == entity || entity.isEmpty()) {
            return null;
        }
        Condition[] conditions = new Condition[entity.size()];
        int i = 0;
        for (Map.Entry entry : entity.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Condition) {
                conditions[i++] = (Condition)value;
                continue;
            }
            conditions[i++] = new Condition((String)entry.getKey(), value);
        }
        return conditions;
    }

    public static String buildLikeValue(String value, Condition.LikeType likeType, boolean withLikeKeyword) {
        if (null == value) {
            return value;
        }
        StringBuilder likeValue = StrUtil.builder(withLikeKeyword ? "LIKE " : "");
        switch (likeType) {
            case StartWith: {
                likeValue.append('%').append(value);
                break;
            }
            case EndWith: {
                likeValue.append(value).append('%');
                break;
            }
            case Contains: {
                likeValue.append('%').append(value).append('%');
                break;
            }
        }
        return likeValue.toString();
    }

    public static String identifyDriver(String nameContainsProductInfo) {
        return DialectFactory.identifyDriver(nameContainsProductInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String identifyDriver(DataSource ds) {
        Connection conn = null;
        String driver = null;
        try {
            try {
                conn = ds.getConnection();
            }
            catch (SQLException e) {
                throw new DbRuntimeException("Get Connection error !", e);
            }
            catch (NullPointerException e) {
                throw new DbRuntimeException("Unexpected NullPointException, maybe [jdbcUrl] or [url] is empty!", e);
            }
            driver = DbUtil.identifyDriver(conn);
        }
        catch (Throwable throwable) {
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(conn);
        return driver;
    }

    public static String identifyDriver(Connection conn) throws DbRuntimeException {
        String driver = null;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            driver = DbUtil.identifyDriver(meta.getDatabaseProductName());
            if (StrUtil.isBlank(driver)) {
                driver = DbUtil.identifyDriver(meta.getDriverName());
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Identify driver error!", e);
        }
        return driver;
    }

    public static void validateEntity(Entity entity) throws DbRuntimeException {
        if (null == entity) {
            throw new DbRuntimeException("Entity is null !");
        }
        if (StrUtil.isBlank(entity.getTableName())) {
            throw new DbRuntimeException("Entity`s table name is null !");
        }
        if (entity.isEmpty()) {
            throw new DbRuntimeException("No filed and value in this entity !");
        }
    }

    public static String rowIdToString(RowId rowId) {
        return StrUtil.str(rowId.getBytes(), CharsetUtil.CHARSET_ISO_8859_1);
    }

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoUtil.read(reader);
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close(reader);
        }
    }

    public static String blobToStr(Blob blob, Charset charset) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IoUtil.read(in, charset);
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static Date toSqlDate(java.util.Date date) {
        return new Date(date.getTime());
    }

    public static Timestamp toSqlTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime());
    }

    public static void setShowSqlGlobal(boolean isShowSql, boolean isFormatSql) {
        SqlBuilder.setShowSql(true, isFormatSql);
    }
}

