/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.function.AnsiTrimEmulationFunction;
import org.hibernate.dialect.function.CharIndexFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class Kingbase8SqlserverDialect
extends PostgreSQLDialect {
    private static final Pattern SELECT_DISTINCT_PATTERN = Kingbase8SqlserverDialect.buildShallowIndexPattern("select\\s+distinct", true);
    private static final Pattern SELECT_PATTERN = Kingbase8SqlserverDialect.buildShallowIndexPattern("select", true);

    public Kingbase8SqlserverDialect() {
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(16, "bool");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(2005, "varchar(MAX)");
        this.registerColumnType(2004, "varbinary(MAX)");
        this.registerColumnType(-2, "bytea");
        this.registerColumnType(5, "tinyint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "int");
        this.registerColumnType(-3, "varbinary(MAX)");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        this.registerColumnType(-4, "varbinary(MAX)");
        this.registerColumnType(-1, "varchar(MAX)");
        this.registerColumnType(12, "varchar(MAX)");
        this.registerColumnType(12, 8000L, "varchar($l)");
        this.registerColumnType(1111, "varchar(MAX)");
        this.registerHibernateType(1111, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(1, Integer.MAX_VALUE, StandardBasicTypes.STRING.getName());
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)StandardBasicTypes.CHARACTER));
        this.registerFunction("len", (SQLFunction)new StandardSQLFunction("len", (Type)StandardBasicTypes.LONG));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("str", (SQLFunction)new StandardSQLFunction("str", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim"));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction("reverse"));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)StandardBasicTypes.STRING));
        this.registerFunction("user", (SQLFunction)new NoArgSQLFunction("user", (Type)StandardBasicTypes.STRING));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("getdate", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("getdate", (Type)StandardBasicTypes.TIME));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("getdate", (Type)StandardBasicTypes.DATE));
        this.registerFunction("getdate", (SQLFunction)new NoArgSQLFunction("getdate", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("getutcdate", (SQLFunction)new NoArgSQLFunction("getutcdate", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("datename", (SQLFunction)new StandardSQLFunction("datename", (Type)StandardBasicTypes.STRING));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("square", (SQLFunction)new StandardSQLFunction("square"));
        this.registerFunction("rand", (SQLFunction)new StandardSQLFunction("rand", (Type)StandardBasicTypes.FLOAT));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling"));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor"));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull"));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "(", "+", ")"));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("len", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("trim", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "ltrim(rtrim(?1))"));
        this.registerFunction("locate", (SQLFunction)new CharIndexFunction());
        this.registerFunction("second", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "datepart(second, ?1)"));
        this.registerFunction("minute", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "datepart(minute, ?1)"));
        this.registerFunction("hour", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "datepart(hour, ?1)"));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction("charindex", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("extract", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "datepart(?1, ?3)"));
        this.registerFunction("mod", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1 % ?2"));
        this.registerFunction("bit_length", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "datalength(?1) * 8"));
        this.registerFunction("trim", (SQLFunction)new AnsiTrimEmulationFunction());
        this.registerKeyword("top");
    }

    public String getSelectGUIDString() {
        return "select sys_guid_name()";
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuilder(querySelect.length() + 8).append(querySelect).insert(Kingbase8SqlserverDialect.getAfterSelectInsertPoint(querySelect), " top " + limit).toString();
    }

    static int getAfterSelectInsertPoint(String sql) {
        Matcher matcherSelect = SELECT_PATTERN.matcher(sql);
        Matcher matcherSelectDistinct = SELECT_DISTINCT_PATTERN.matcher(sql);
        int selectIndex = -1;
        String selectStr = null;
        int selectDistinctIndex = -1;
        String selectDistinctStr = null;
        if (matcherSelect.find()) {
            selectIndex = matcherSelect.start(0);
            selectStr = matcherSelect.group(0);
        }
        if (matcherSelectDistinct.find()) {
            selectDistinctIndex = matcherSelectDistinct.start(0);
            selectDistinctStr = matcherSelectDistinct.group(0);
        }
        if (selectDistinctStr == null) {
            selectDistinctStr = "";
        }
        if (selectStr == null) {
            selectStr = "";
        }
        return selectIndex + (selectDistinctIndex == selectIndex ? selectDistinctStr.length() : selectStr.length());
    }

    public String getLimitString(String sql, boolean hasOffset) {
        throw new UnsupportedOperationException("Paged queries not supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public Class getNativeIdentifierGeneratorClass() {
        return IdentityGenerator.class;
    }

    public String getIdentitySelectString() {
        return "select @@identity";
    }

    private static Pattern buildShallowIndexPattern(String pattern, boolean wordBoundary) {
        return Pattern.compile("(" + (wordBoundary ? "\\b" : "") + pattern + (wordBoundary ? "\\b" : "") + ")(?![^\\(|\\[]*(\\)|\\]))", 2);
    }
}

