/*
 * Decompiled with CFR 0.152.
 */
package cn.chenlichao.wmi4j;

import cn.chenlichao.wmi4j.SWbemLastError;
import cn.chenlichao.wmi4j.SWbemNamedValueSet;
import cn.chenlichao.wmi4j.SWbemPrivilege;
import cn.chenlichao.wmi4j.SWbemServices;
import cn.chenlichao.wmi4j.WMIException;
import cn.chenlichao.wmi4j.consts.Flags;
import java.net.UnknownHostException;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWbemLocator {
    private static final Logger logger = LoggerFactory.getLogger(SWbemLocator.class);
    private static final String WMI_CLSID = "76A6415B-CB41-11d1-8B02-00600806D9B6";
    private JISession session;
    private SWbemServices services;
    private IJIDispatch servicesDispatch;
    private final String server;
    private final String username;
    private final String password;
    private final String namespace;

    public SWbemLocator(String server, String username, String password, String namespace) {
        this.server = server;
        this.username = username;
        this.password = password;
        this.namespace = namespace;
    }

    public SWbemServices connectServer(String locale, String authority, Flags.SecurityFlag securityFlag, SWbemNamedValueSet objwbemNamedValueSet) throws WMIException, UnknownHostException {
        if (this.services != null) {
            return this.services;
        }
        String hostPath = "\\\\" + this.server + "\\" + this.namespace;
        logger.info("Connect to {} ...", (Object)hostPath);
        try {
            try {
                JISystem.setAutoRegisteration((boolean)true);
                JISystem.setInBuiltLogHandler((boolean)false);
                JISystem.getLogger().setLevel(Level.OFF);
            }
            catch (Exception e) {
                logger.warn("Exception occurred when disable integrated log.");
            }
            String userDomain = "";
            String user = this.username;
            if (this.username.contains("\\")) {
                String[] du = this.username.split("\\\\");
                if (du.length != 2) {
                    throw new IllegalArgumentException("Invalid username: " + this.username);
                }
                userDomain = du[0];
                user = du[1];
            }
            this.session = JISession.createSession((String)userDomain, (String)user, (String)this.password);
            this.session.useSessionSecurity(true);
            this.session.setGlobalSocketTimeout(300000);
            JIComServer comStub = new JIComServer(JIProgId.valueOf((String)"WbemScripting.SWbemLocator"), this.server, this.session);
            IJIComObject unknown = comStub.createInstance();
            IJIComObject wbemLocatorObj = unknown.queryInterface(WMI_CLSID);
            IJIDispatch wbemLocatorDispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)wbemLocatorObj.queryInterface("00020400-0000-0000-c000-000000000046"));
            JIVariant[] results = wbemLocatorDispatch.callMethodA("ConnectServer", new Object[]{JIVariant.OPTIONAL_PARAM(), this.namespace == null ? JIVariant.OPTIONAL_PARAM() : new JIString(this.namespace), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), locale == null ? JIVariant.OPTIONAL_PARAM() : new JIString(locale), authority == null ? JIVariant.OPTIONAL_PARAM() : new JIString(authority), securityFlag == null ? 0 : securityFlag.getValue(), objwbemNamedValueSet == null ? JIVariant.OPTIONAL_PARAM() : objwbemNamedValueSet.getDispatch()});
            this.servicesDispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
            this.servicesDispatch.addRef();
            this.services = new SWbemServices(this.servicesDispatch);
        }
        catch (JIException e) {
            throw new WMIException(e.getErrorCode(), e.getMessage(), e.getCause());
        }
        return this.services;
    }

    public SWbemServices connectServer() throws WMIException, UnknownHostException {
        return this.connectServer(null, null, null, null);
    }

    public SWbemServices getSWbemServices() {
        if (this.services == null) {
            throw new IllegalStateException("Please connect to the server first.");
        }
        return this.services;
    }

    public <T> T createObject(Class<T> objectType) throws WMIException {
        String typeName = objectType.getSimpleName();
        logger.debug("Create object {}...", (Object)typeName);
        if (SWbemPrivilege.class.equals(objectType)) {
            return (T)new SWbemPrivilege(this.co("WbemScripting." + typeName));
        }
        if (SWbemNamedValueSet.class.equals(objectType)) {
            return (T)new SWbemNamedValueSet(this.co("WbemScripting." + typeName));
        }
        if (SWbemLastError.class.equals(objectType)) {
            return (T)new SWbemLastError(this.co("WbemScripting." + typeName));
        }
        return null;
    }

    private IJIDispatch co(String progId) throws WMIException {
        try {
            JISession tmpSession = JISession.createSession((JISession)this.session);
            JIComServer tmpSever = new JIComServer(JIProgId.valueOf((String)progId), this.server, tmpSession);
            IJIComObject unknown = tmpSever.createInstance();
            IJIDispatch dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
            return dispatch;
        }
        catch (JIException e) {
            throw new WMIException(e);
        }
        catch (UnknownHostException e) {
            throw new WMIException(0, "Unknown host.");
        }
    }

    public void disconnect() throws WMIException {
        try {
            this.services = null;
            this.servicesDispatch = null;
            JISession.destroySession((JISession)this.session);
        }
        catch (JIException e) {
            throw new WMIException(e);
        }
    }

    public boolean isConnected() {
        if (this.services == null || this.servicesDispatch == null) {
            return false;
        }
        try {
            this.servicesDispatch.queryInterface("00020400-0000-0000-c000-000000000046");
            return true;
        }
        catch (JIException e) {
            if (e.getErrorCode() == -2147352577) {
                logger.debug("Connection has been disconnected.");
                return false;
            }
            throw new IllegalStateException();
        }
    }
}

