/*
 * Decompiled with CFR 0.152.
 */
package cn.chenlichao.wmi4j;

import cn.chenlichao.wmi4j.WMIException;
import cn.chenlichao.wmi4j.WMIVariant;
import java.lang.reflect.InvocationTargetException;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractScriptingObject {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    final IJIDispatch dispatch;

    AbstractScriptingObject(final IJIDispatch dispatch) {
        this.dispatch = dispatch;
        this.dispatch.registerUnreferencedHandler(new IJIUnreferenced(){

            public void unReferenced() {
                try {
                    dispatch.addRef();
                    AbstractScriptingObject.this.logger.debug("Add reference to {}", (Object)dispatch);
                }
                catch (JIException e) {
                    AbstractScriptingObject.this.logger.warn("Exception occurred when add reference to dispatch.", (Throwable)e);
                }
            }
        });
    }

    IJIDispatch getDispatch() {
        return this.dispatch;
    }

    <T> T callMethod(Class<?> returnType, String methodName, Object ... params) throws WMIException {
        this.logger.debug("Execute {}.{}.{} method...", new Object[]{this.getClass().getSimpleName(), methodName, this.formatParams(params)});
        Object retVal = null;
        try {
            JIVariant[] results = this.dispatch.callMethodA(methodName, params);
            if (returnType == null) {
                return null;
            }
            if (AbstractScriptingObject.class.isAssignableFrom(returnType)) {
                IJIDispatch resultDispatch;
                IJIComObject comObject = JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
                if ("00020400-0000-0000-c000-000000000046".equalsIgnoreCase(comObject.getInterfaceIdentifier())) {
                    resultDispatch = (IJIDispatch)comObject;
                } else {
                    IJIComObject d = JIObjectFactory.narrowObject((IJIComObject)comObject.queryInterface("00020400-0000-0000-c000-000000000046"));
                    resultDispatch = (IJIDispatch)d;
                }
                retVal = returnType.getDeclaredConstructor(IJIDispatch.class).newInstance(resultDispatch);
            } else if (Boolean.class.equals(returnType)) {
                retVal = results[0].getObjectAsBoolean();
            } else if (String.class.equals(returnType)) {
                retVal = results[0].getObjectAsString2();
            }
        }
        catch (JIException e) {
            throw new WMIException(e);
        }
        catch (InvocationTargetException e) {
            throw new WMIException(0x1000001, "Bug of wmi4j, please send log to reacher-chen@163.com.", e);
        }
        catch (NoSuchMethodException e) {
            throw new WMIException(0x1000001, "Bug of wmi4j, please send log to reacher-chen@163.com.", e);
        }
        catch (InstantiationException e) {
            throw new WMIException(0x1000001, "Bug of wmi4j, please send log to reacher-chen@163.com.", e);
        }
        catch (IllegalAccessException e) {
            throw new WMIException(0x1000001, "Bug of wmi4j, please send log to reacher-chen@163.com.", e);
        }
        return (T)retVal;
    }

    <T> T getProperty(Class<?> returnType, String name) throws WMIException {
        try {
            JIVariant result = this.dispatch.get(name);
            if (String.class.equals(returnType)) {
                return (T)result.getObjectAsString2();
            }
            if (Boolean.class.equals(returnType)) {
                return (T)Boolean.valueOf(result.getObjectAsBoolean());
            }
            if (Integer.class.equals(returnType)) {
                return (T)Integer.valueOf(result.getObjectAsInt());
            }
            if (AbstractScriptingObject.class.isAssignableFrom(returnType)) {
                IJIComObject resultObject = result.getObjectAsComObject();
                IJIDispatch resultDispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)resultObject.queryInterface("00020400-0000-0000-c000-000000000046"));
                return (T)returnType.getDeclaredConstructor(IJIDispatch.class).newInstance(resultDispatch);
            }
            return (T)new WMIVariant(result);
        }
        catch (JIException e) {
            throw new WMIException(e);
        }
        catch (Exception e) {
            throw new WMIException(0x1000001, "Unsupported cim type");
        }
    }

    void putProperty(String propName, JIVariant value) throws WMIException {
        try {
            this.dispatch.put(propName, value);
        }
        catch (JIException e) {
            throw new WMIException(e);
        }
    }

    private Object[] formatParams(Object[] ps) {
        Object[] result = new Object[ps.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ps[i] instanceof JIString ? ((JIString)ps[i]).getString() : (JIVariant.OPTIONAL_PARAM().toString().equals(ps[i].toString()) ? null : ps[i]);
        }
        return result;
    }
}

