/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.core.httpclient;

import com.google.gson.Gson;
import com.zhipu.oapi.Constants;
import com.zhipu.oapi.core.httpclient.BaseHttpTransport;
import com.zhipu.oapi.core.request.RawRequest;
import com.zhipu.oapi.core.response.RawResponse;
import com.zhipu.oapi.service.v4.api.ChatApiService;
import com.zhipu.oapi.service.v4.model.ModelData;
import io.reactivex.Flowable;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpTransport
extends BaseHttpTransport {
    private static final Logger log = LoggerFactory.getLogger(OkHttpTransport.class);
    private OkHttpClient okHttpClient;

    public OkHttpTransport(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public RawResponse executePost(RawRequest request) throws Exception {
        String reqBodyStr = new Gson().toJson(request.getBody());
        RequestBody formBody = RequestBody.create((MediaType)Constants.jsonMediaType, (String)reqBodyStr);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", request.getToken());
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        Request okHttpRequest = new Request.Builder().url(request.getReqUrl()).post(formBody).headers(Headers.of(headers)).build();
        Response okHttpResp = this.okHttpClient.newCall(okHttpRequest).execute();
        ResponseBody respBody = okHttpResp.body();
        String resultDataStr = respBody.string();
        RawResponse resp = this.extractResp(resultDataStr);
        return resp;
    }

    @Override
    public RawResponse executeGet(RawRequest request) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", request.getToken());
        headers.put("Content-Type", "application/json; charset=utf-8");
        headers.put("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        Request okHttpReq = new Request.Builder().url(request.getReqUrl()).headers(Headers.of(headers)).build();
        Response okHttpResp = this.okHttpClient.newCall(okHttpReq).execute();
        ResponseBody respBody = okHttpResp.body();
        String resultDataStr = respBody.string();
        RawResponse resp = this.extractResp(resultDataStr);
        return resp;
    }

    @Override
    public RawResponse sseExecute(RawRequest request) throws Exception {
        Flowable<ModelData> flowable;
        ChatApiService service = new ChatApiService(request.getToken());
        RawResponse resp = new RawResponse();
        try {
            flowable = service.streamChatCompletion(request.getBody());
        }
        catch (Exception e) {
            System.out.println("streamChatCompletion error:" + e.getMessage());
            resp.setStatusCode(500);
            resp.setSuccess(false);
            return resp;
        }
        resp.setSuccess(true);
        resp.setStatusCode(200);
        resp.setFlowable(flowable);
        return resp;
    }
}

