/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports.sax;

import cn.afterturn.easypoi.excel.entity.enmus.CellValueType;
import cn.afterturn.easypoi.excel.entity.sax.SaxReadCellEntity;
import cn.afterturn.easypoi.excel.imports.sax.parse.ISaxRowRead;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SheetHandler
extends DefaultHandler {
    private SharedStringsTable sharedStringsTable;
    private StylesTable stylesTable;
    private String lastContents;
    private boolean lastContentObtained;
    private int curRow = 0;
    private int curCol = 0;
    private CellValueType type;
    private String currentLocation = "A_";
    private String prevLocation;
    private ISaxRowRead read;
    private List<SaxReadCellEntity> rowList = new ArrayList<SaxReadCellEntity>();

    public SheetHandler(SharedStringsTable sharedStringsTable, StylesTable stylesTable, ISaxRowRead rowRead) {
        this.sharedStringsTable = sharedStringsTable;
        this.stylesTable = stylesTable;
        this.read = rowRead;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.lastContents = "";
        this.lastContentObtained = false;
        if ("c".equals(name)) {
            String cellType = attributes.getValue("t");
            if ("A_".equalsIgnoreCase(this.currentLocation)) {
                this.currentLocation = attributes.getValue("r");
                this.prevLocation = "A" + this.getRowCell(this.currentLocation)[1];
            } else {
                this.prevLocation = this.currentLocation;
                this.currentLocation = attributes.getValue("r");
            }
            if ("s".equals(cellType)) {
                this.type = CellValueType.String;
                return;
            }
            if ("b".equals(cellType)) {
                this.type = CellValueType.Boolean;
                return;
            }
            if ("d".equals(cellType)) {
                this.type = CellValueType.Date;
                return;
            }
            if ("inlineStr".equals(cellType)) {
                this.type = CellValueType.InlineStr;
                return;
            }
            if ("str".equals(cellType)) {
                this.type = CellValueType.Formula;
                return;
            }
            if ("n".equals(cellType)) {
                this.type = CellValueType.Number;
                return;
            }
            try {
                short nfId = (short)this.stylesTable.getCellXfAt(Integer.parseInt(attributes.getValue("s"))).getNumFmtId();
                String numberFormat = ((String)this.stylesTable.getNumberFormats().get(nfId)).toUpperCase();
                if (StringUtils.isNotEmpty((CharSequence)numberFormat) && (numberFormat.contains("Y") || numberFormat.contains("M") || numberFormat.contains("D") || numberFormat.contains("H") || numberFormat.contains("S") || numberFormat.contains("\u5e74") || numberFormat.contains("\u6708") || numberFormat.contains("\u65e5") || numberFormat.contains("\u65f6") || numberFormat.contains("\u5206") || numberFormat.contains("\u79d2"))) {
                    this.type = CellValueType.Date;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.type = CellValueType.Number;
        } else if ("t".equals(name)) {
            this.type = CellValueType.TElement;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (CellValueType.String.equals((Object)this.type)) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = this.sharedStringsTable.getItemAt(idx).getString();
            }
            catch (Exception idx) {
                // empty catch block
            }
        }
        if (("c".equals(name) || "v".equals(name)) && StringUtils.isNotEmpty((CharSequence)this.prevLocation)) {
            this.addNullCell(this.prevLocation, this.currentLocation);
            this.prevLocation = this.currentLocation;
        }
        if (CellValueType.TElement.equals((Object)this.type)) {
            String value = this.lastContents.trim();
            this.rowList.add(this.curCol, new SaxReadCellEntity(CellValueType.String, value));
            this.lastContentObtained = true;
            ++this.curCol;
            this.type = CellValueType.None;
        } else if ("v".equals(name)) {
            String value = this.lastContents.trim();
            String string = value = "".equals(value) ? " " : value;
            if (CellValueType.Date.equals((Object)this.type)) {
                Date date = HSSFDateUtil.getJavaDate((double)Double.valueOf(value));
                this.rowList.add(this.curCol, new SaxReadCellEntity(CellValueType.Date, date));
                this.lastContentObtained = true;
            } else if (CellValueType.Number.equals((Object)this.type)) {
                BigDecimal bd = new BigDecimal(value);
                this.rowList.add(this.curCol, new SaxReadCellEntity(CellValueType.Number, bd));
                this.lastContentObtained = true;
            } else if (CellValueType.String.equals((Object)this.type) || CellValueType.Formula.equals((Object)this.type) || CellValueType.InlineStr.equals((Object)this.type)) {
                this.rowList.add(this.curCol, new SaxReadCellEntity(CellValueType.String, value));
                this.lastContentObtained = true;
            }
            ++this.curCol;
        } else if ("c".equals(name) && !this.lastContentObtained) {
            this.rowList.add(this.curCol, new SaxReadCellEntity(CellValueType.String, ""));
            ++this.curCol;
        } else if ("row".equals(name)) {
            this.read.parse(this.curRow, this.rowList);
            this.rowList.clear();
            ++this.curRow;
            this.curCol = 0;
            this.currentLocation = "A_";
        }
    }

    private void addNullCell(String prevLocation, String currentLocation) {
        String[] current;
        String[] prev = this.getRowCell(prevLocation);
        if (prev[1].equalsIgnoreCase((current = this.getRowCell(currentLocation))[1])) {
            int prevCell = this.getCellNum(prev[0]) + 1;
            int currentCell = this.getCellNum(current[0]);
            for (int i = prevCell; i < currentCell; ++i) {
                this.rowList.add(this.curCol, new SaxReadCellEntity(CellValueType.String, ""));
                ++this.curCol;
            }
        }
    }

    private int getCellNum(String cell) {
        if (StringUtils.isEmpty((CharSequence)cell)) {
            return 0;
        }
        char[] chars = cell.toUpperCase().toCharArray();
        int n = 0;
        int i = cell.length() - 1;
        int j = 1;
        while (i >= 0) {
            char c = chars[i];
            if (c < 'A' || c > 'Z') {
                return 0;
            }
            n += (c - 64) * j;
            --i;
            j *= 26;
        }
        return n;
    }

    private String[] getRowCell(String prevLocation) {
        StringBuilder row = new StringBuilder();
        StringBuilder cell = new StringBuilder();
        char[] chars = prevLocation.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                cell.append(chars[i]);
                continue;
            }
            row.append(chars[i]);
        }
        return new String[]{row.toString(), cell.toString()};
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }
}

