/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.util.SolarUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ExactDate {
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT+8");

    public static Calendar fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance(TIME_ZONE);
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, 0);
        if (0 == year) {
            c.add(1, 1);
        }
        return c;
    }

    public static Calendar fromYmd(int year, int month, int day) {
        return ExactDate.fromYmdHms(year, month, day, 0, 0, 0);
    }

    public static Calendar fromDate(Date date) {
        Calendar c = Calendar.getInstance(TIME_ZONE);
        c.setTime(date);
        c.set(14, 0);
        return c;
    }

    public static int getDaysBetween(int ay, int am, int ad, int by, int bm, int bd) {
        int n;
        if (ay == by) {
            n = SolarUtil.getDaysInYear(by, bm, bd) - SolarUtil.getDaysInYear(ay, am, ad);
        } else if (ay > by) {
            int days = SolarUtil.getDaysOfYear(by) - SolarUtil.getDaysInYear(by, bm, bd);
            for (int i = by + 1; i < ay; ++i) {
                days += SolarUtil.getDaysOfYear(i);
            }
            n = -(days += SolarUtil.getDaysInYear(ay, am, ad));
        } else {
            int days = SolarUtil.getDaysOfYear(ay) - SolarUtil.getDaysInYear(ay, am, ad);
            for (int i = ay + 1; i < by; ++i) {
                days += SolarUtil.getDaysOfYear(i);
            }
            n = days += SolarUtil.getDaysInYear(by, bm, bd);
        }
        return n;
    }

    public static int getDaysBetween(Calendar calendar0, Calendar calendar1) {
        return ExactDate.getDaysBetween(calendar0.get(1), calendar0.get(2) + 1, calendar0.get(5), calendar1.get(1), calendar1.get(2) + 1, calendar1.get(5));
    }
}

