/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.SSU_U03_SPECIMEN;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.SAC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSU_U03_SPECIMEN_CONTAINER
extends AbstractGroup {
    public SSU_U03_SPECIMEN_CONTAINER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SAC.class, true, false, false);
            this.add(OBX.class, false, true, false);
            this.add(SSU_U03_SPECIMEN.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SSU_U03_SPECIMEN_CONTAINER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public SAC getSAC() {
        SAC retVal = (SAC)this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public SSU_U03_SPECIMEN getSPECIMEN() {
        SSU_U03_SPECIMEN retVal = (SSU_U03_SPECIMEN)this.getTyped("SPECIMEN", SSU_U03_SPECIMEN.class);
        return retVal;
    }

    public SSU_U03_SPECIMEN getSPECIMEN(int rep) {
        SSU_U03_SPECIMEN retVal = (SSU_U03_SPECIMEN)this.getTyped("SPECIMEN", rep, SSU_U03_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<SSU_U03_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", SSU_U03_SPECIMEN.class);
    }

    public void insertSPECIMEN(SSU_U03_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public SSU_U03_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (SSU_U03_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public SSU_U03_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (SSU_U03_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

