/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OML_O35_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v26.group.OML_O35_TIMING;
import ca.uhn.hl7v2.model.v26.segment.BLG;
import ca.uhn.hl7v2.model.v26.segment.CTI;
import ca.uhn.hl7v2.model.v26.segment.FT1;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OML_O35_ORDER
extends AbstractGroup {
    public OML_O35_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(OML_O35_TIMING.class, false, true, false);
            this.add(OML_O35_OBSERVATION_REQUEST.class, false, false, false);
            this.add(FT1.class, false, true, false);
            this.add(CTI.class, false, true, false);
            this.add(BLG.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O35_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OML_O35_TIMING getTIMING() {
        OML_O35_TIMING retVal = (OML_O35_TIMING)this.getTyped("TIMING", OML_O35_TIMING.class);
        return retVal;
    }

    public OML_O35_TIMING getTIMING(int rep) {
        OML_O35_TIMING retVal = (OML_O35_TIMING)this.getTyped("TIMING", rep, OML_O35_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<OML_O35_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", OML_O35_TIMING.class);
    }

    public void insertTIMING(OML_O35_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public OML_O35_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OML_O35_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OML_O35_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OML_O35_TIMING)super.removeRepetition("TIMING", rep);
    }

    public OML_O35_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OML_O35_OBSERVATION_REQUEST retVal = (OML_O35_OBSERVATION_REQUEST)this.getTyped("OBSERVATION_REQUEST", OML_O35_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public FT1 getFT1() {
        FT1 retVal = (FT1)this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public FT1 getFT1(int rep) {
        FT1 retVal = (FT1)this.getTyped("FT1", rep, FT1.class);
        return retVal;
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public BLG getBLG() {
        BLG retVal = (BLG)this.getTyped("BLG", BLG.class);
        return retVal;
    }
}

