/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.ueditor.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static boolean copyFile(String srcFileName, String descFileName) {
        return FileUtils.copyFileCover(srcFileName, descFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileCover(String srcFileName, String descFileName, boolean coverlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 " + srcFileName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcFile.isFile()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c" + srcFileName + " \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6!");
            return false;
        }
        File descFile = new File(descFileName);
        if (descFile.exists()) {
            if (!coverlay) {
                logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtils.delFile(descFileName)) {
                logger.debug("\u5220\u9664\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5931\u8d25!");
                return false;
            }
        } else if (!descFile.getParentFile().exists()) {
            logger.debug("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u76ee\u5f55!");
            if (!descFile.getParentFile().mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        int readByte = 0;
        FileInputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new FileInputStream(srcFile);
            outs = new FileOutputStream(descFile);
            byte[] buf = new byte[1024];
            while ((readByte = ((InputStream)ins).read(buf)) != -1) {
                outs.write(buf, 0, readByte);
            }
            logger.debug("\u590d\u5236\u5355\u4e2a\u6587\u4ef6 " + srcFileName + " \u5230" + descFileName + "\u6210\u529f!");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (IOException oute) {
                    oute.printStackTrace();
                }
            }
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ine) {
                    ine.printStackTrace();
                }
            }
        }
    }

    public static boolean copyDirectory(String srcDirName, String descDirName) {
        return FileUtils.copyDirectoryCover(srcDirName, descDirName, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean copyDirectoryCover(String srcDirName, String descDirName, boolean coverlay) {
        File descDir;
        File srcDir = new File(srcDirName);
        if (!srcDir.exists()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c\u6e90\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcDir.isDirectory()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c" + srcDirName + " \u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55!");
            return false;
        }
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            if (!coverlay) {
                logger.debug("\u76ee\u6807\u76ee\u5f55\u590d\u5236\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtils.delFile(descDirNames)) {
                logger.debug("\u5220\u9664\u76ee\u5f55 " + descDirNames + " \u5931\u8d25!");
                return false;
            }
        } else {
            logger.debug("\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa!");
            if (!descDir.mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        boolean flag = true;
        File[] files = srcDir.listFiles();
        for (int i = 0; !(i >= files.length || files[i].isFile() && !(flag = FileUtils.copyFile(files[i].getAbsolutePath(), descDirName + files[i].getName())) || files[i].isDirectory() && !(flag = FileUtils.copyDirectory(files[i].getAbsolutePath(), descDirName + files[i].getName()))); ++i) {
        }
        if (!flag) {
            logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u5931\u8d25!");
            return false;
        }
        logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u6210\u529f!");
        return true;
    }

    public static boolean delFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            logger.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
            return true;
        }
        if (file.isFile()) {
            return FileUtils.deleteFile(fileName);
        }
        return FileUtils.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u6210\u529f!");
                return true;
            }
            logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u5931\u8d25!");
            return false;
        }
        logger.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
        return true;
    }

    public static boolean deleteDirectory(String dirName) {
        File dirFile;
        String dirNames = dirName;
        if (!dirNames.endsWith(File.separator)) {
            dirNames = dirNames + File.separator;
        }
        if (!(dirFile = new File(dirNames)).exists() || !dirFile.isDirectory()) {
            logger.debug(dirNames + " \u76ee\u5f55\u4e0d\u5b58\u5728!");
            return true;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtils.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = FileUtils.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            logger.debug("\u5220\u9664\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        if (dirFile.delete()) {
            logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u6210\u529f!");
            return true;
        }
        logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u5931\u8d25!");
        return false;
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            logger.debug("\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descFileName.endsWith(File.separator)) {
            logger.debug(descFileName + " \u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55!");
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.debug("\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        try {
            if (file.createNewFile()) {
                logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f!");
                return true;
            }
            logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descDir.mkdirs()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u6210\u529f!");
            return true;
        }
        logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u5931\u8d25!");
        return false;
    }

    public static void writeToFile(String fileName, String content, boolean append) {
        try {
            FileUtils.write((File)new File(fileName), (CharSequence)content, (String)"utf-8", (boolean)append);
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    public static void writeToFile(String fileName, String content, String encoding, boolean append) {
        try {
            FileUtils.write((File)new File(fileName), (CharSequence)content, (String)encoding, (boolean)append);
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    private static String getEntryName(String dirPath, File file) {
        String dirPaths = dirPath;
        if (!dirPaths.endsWith(File.separator)) {
            dirPaths = dirPaths + File.separator;
        }
        String filePath = file.getAbsolutePath();
        if (file.isDirectory()) {
            filePath = filePath + "/";
        }
        int index = filePath.indexOf(dirPaths);
        return filePath.substring(index + dirPaths.length());
    }

    public static String getContentType(String returnFileName) {
        String contentType = "application/octet-stream";
        if (returnFileName.lastIndexOf(".") < 0) {
            return contentType;
        }
        returnFileName = returnFileName.toLowerCase();
        if ((returnFileName = returnFileName.substring(returnFileName.lastIndexOf(".") + 1)).equals("html") || returnFileName.equals("htm") || returnFileName.equals("shtml")) {
            contentType = "text/html";
        } else if (returnFileName.equals("apk")) {
            contentType = "application/vnd.android.package-archive";
        } else if (returnFileName.equals("sis")) {
            contentType = "application/vnd.symbian.install";
        } else if (returnFileName.equals("sisx")) {
            contentType = "application/vnd.symbian.install";
        } else if (returnFileName.equals("exe")) {
            contentType = "application/x-msdownload";
        } else if (returnFileName.equals("msi")) {
            contentType = "application/x-msdownload";
        } else if (returnFileName.equals("css")) {
            contentType = "text/css";
        } else if (returnFileName.equals("xml")) {
            contentType = "text/xml";
        } else if (returnFileName.equals("gif")) {
            contentType = "image/gif";
        } else if (returnFileName.equals("jpeg") || returnFileName.equals("jpg")) {
            contentType = "image/jpeg";
        } else if (returnFileName.equals("js")) {
            contentType = "application/x-javascript";
        } else if (returnFileName.equals("atom")) {
            contentType = "application/atom+xml";
        } else if (returnFileName.equals("rss")) {
            contentType = "application/rss+xml";
        } else if (returnFileName.equals("mml")) {
            contentType = "text/mathml";
        } else if (returnFileName.equals("txt")) {
            contentType = "text/plain";
        } else if (returnFileName.equals("jad")) {
            contentType = "text/vnd.sun.j2me.app-descriptor";
        } else if (returnFileName.equals("wml")) {
            contentType = "text/vnd.wap.wml";
        } else if (returnFileName.equals("htc")) {
            contentType = "text/x-component";
        } else if (returnFileName.equals("png")) {
            contentType = "image/png";
        } else if (returnFileName.equals("tif") || returnFileName.equals("tiff")) {
            contentType = "image/tiff";
        } else if (returnFileName.equals("wbmp")) {
            contentType = "image/vnd.wap.wbmp";
        } else if (returnFileName.equals("ico")) {
            contentType = "image/x-icon";
        } else if (returnFileName.equals("jng")) {
            contentType = "image/x-jng";
        } else if (returnFileName.equals("bmp")) {
            contentType = "image/x-ms-bmp";
        } else if (returnFileName.equals("svg")) {
            contentType = "image/svg+xml";
        } else if (returnFileName.equals("jar") || returnFileName.equals("var") || returnFileName.equals("ear")) {
            contentType = "application/java-archive";
        } else if (returnFileName.equals("doc")) {
            contentType = "application/msword";
        } else if (returnFileName.equals("pdf")) {
            contentType = "application/pdf";
        } else if (returnFileName.equals("rtf")) {
            contentType = "application/rtf";
        } else if (returnFileName.equals("xls")) {
            contentType = "application/vnd.ms-excel";
        } else if (returnFileName.equals("ppt")) {
            contentType = "application/vnd.ms-powerpoint";
        } else if (returnFileName.equals("7z")) {
            contentType = "application/x-7z-compressed";
        } else if (returnFileName.equals("rar")) {
            contentType = "application/x-rar-compressed";
        } else if (returnFileName.equals("swf")) {
            contentType = "application/x-shockwave-flash";
        } else if (returnFileName.equals("rpm")) {
            contentType = "application/x-redhat-package-manager";
        } else if (returnFileName.equals("der") || returnFileName.equals("pem") || returnFileName.equals("crt")) {
            contentType = "application/x-x509-ca-cert";
        } else if (returnFileName.equals("xhtml")) {
            contentType = "application/xhtml+xml";
        } else if (returnFileName.equals("zip")) {
            contentType = "application/zip";
        } else if (returnFileName.equals("mid") || returnFileName.equals("midi") || returnFileName.equals("kar")) {
            contentType = "audio/midi";
        } else if (returnFileName.equals("mp3")) {
            contentType = "audio/mpeg";
        } else if (returnFileName.equals("ogg")) {
            contentType = "audio/ogg";
        } else if (returnFileName.equals("m4a")) {
            contentType = "audio/x-m4a";
        } else if (returnFileName.equals("ra")) {
            contentType = "audio/x-realaudio";
        } else if (returnFileName.equals("3gpp") || returnFileName.equals("3gp")) {
            contentType = "video/3gpp";
        } else if (returnFileName.equals("mp4")) {
            contentType = "video/mp4";
        } else if (returnFileName.equals("mpeg") || returnFileName.equals("mpg")) {
            contentType = "video/mpeg";
        } else if (returnFileName.equals("mov")) {
            contentType = "video/quicktime";
        } else if (returnFileName.equals("flv")) {
            contentType = "video/x-flv";
        } else if (returnFileName.equals("m4v")) {
            contentType = "video/x-m4v";
        } else if (returnFileName.equals("mng")) {
            contentType = "video/x-mng";
        } else if (returnFileName.equals("asx") || returnFileName.equals("asf")) {
            contentType = "video/x-ms-asf";
        } else if (returnFileName.equals("wmv")) {
            contentType = "video/x-ms-wmv";
        } else if (returnFileName.equals("avi")) {
            contentType = "video/x-msvideo";
        }
        return contentType;
    }

    public static List<String> findChildrenList(File dir, boolean searchDirs) {
        ArrayList files = Lists.newArrayList();
        for (String subFiles : dir.list()) {
            File file = new File(dir + "/" + subFiles);
            if ((!searchDirs || !file.isDirectory()) && (searchDirs || file.isDirectory())) continue;
            files.add(file.getName());
        }
        return files;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1) {
            return null;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static File renameFile(File file) {
        String body = "";
        String ext = "";
        Date date = new Date();
        int pot = file.getName().lastIndexOf(".");
        if (pot != -1) {
            body = UUID.randomUUID().toString().replace("-", "");
            ext = file.getName().substring(pot);
        } else {
            body = new Date().getTime() + "";
            ext = "";
        }
        String newName = body + ext;
        file = new File(file.getParent(), newName);
        return file;
    }
}

