/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component
public class SvgUtil {
    private static final Logger log = LoggerFactory.getLogger(SvgUtil.class);
    @Value(value="${mp.im.svg_path}")
    private String svgPath;

    public String svg2Png(String svgName, String svgColor) {
        String svgFillColorPath = this.svgFillColor(svgName, svgColor);
        if (!StrUtil.isNotEmpty((CharSequence)svgFillColorPath)) {
            return null;
        }
        File inSvg = new File(svgFillColorPath);
        String prefix = FileUtil.getPrefix((String)inSvg.getName());
        File outputPng = new File(this.svgPath + prefix + ".png");
        if (FileUtil.exist((File)outputPng) && FileUtil.size((File)outputPng) > 0L) {
            System.out.println("\u5f53\u524dpng\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u76f4\u63a5\u8fd4\u56de~~~");
            return outputPng.getAbsolutePath();
        }
        try {
            String svgURI = inSvg.toURI().toURL().toString();
            TranscoderInput input = new TranscoderInput(svgURI);
            OutputStream pngOStream = Files.newOutputStream(outputPng.toPath(), new OpenOption[0]);
            TranscoderOutput output = new TranscoderOutput(pngOStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(512.0f));
            transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(512.0f));
            transcoder.transcode(input, output);
            pngOStream.flush();
            pngOStream.close();
            System.out.println("\u8f6c\u6362\u5b8c\u6210\uff0c\u8f6c\u6362\u540e\u7684png\u6587\u4ef6\u4e3a\uff1a" + outputPng.getAbsolutePath());
            return outputPng.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            outputPng.deleteOnExit();
            return null;
        }
    }

    public String svgFillColor(String svgName, String svgColor) {
        String resSvg = this.svgPath + svgName + ".svg";
        if (!FileUtil.exist((String)resSvg)) {
            throw new RuntimeException(resSvg + " \u4e0d\u5b58\u5728!");
        }
        if (!this.isValidHexColor(svgColor)) {
            System.out.println("\u989c\u8272\u683c\u5f0f\u975e\u6cd5\uff0c\u8fd4\u56de\u9ed8\u8ba4\u56fe");
            return resSvg;
        }
        svgColor = StrUtil.subSuf((CharSequence)svgColor, (int)1);
        File outputSvg = new File(this.svgPath + svgName + "_" + svgColor + ".svg");
        try {
            if (outputSvg.exists() && outputSvg.length() > 0L) {
                System.out.println("\u8981\u8f6c\u6362\u7684svg\u5df2\u5b58\u5728,\u5c06\u76f4\u63a5\u8fdb\u884csvg2png\u8f6c\u6362......");
                return outputSvg.getAbsolutePath();
            }
            System.out.println("\u5f00\u59cb\u8f6c\u6362\uff0c\u8f6c\u6362\u540e\u7684svg\u76ee\u5f55\u4e3a\uff1a" + outputSvg.getAbsolutePath());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(resSvg));
            Element root = document.getDocumentElement();
            root.setAttribute("viewBox", "0 0 512 512");
            root.setAttribute("preserveAspectRatio", "xMidYMid meet");
            String svgNS = "http://www.w3.org/2000/svg";
            Element rect = document.createElementNS(svgNS, "rect");
            rect.setAttribute("width", "100%");
            rect.setAttribute("height", "100%");
            rect.setAttribute("fill", "#" + svgColor);
            root.insertBefore(rect, root.getFirstChild());
            NodeList paths = document.getElementsByTagName("path");
            for (int i = 0; i < paths.getLength(); ++i) {
                Element path = (Element)paths.item(i);
                float scale = 0.33f;
                float originalWidth = 512.0f;
                float originalHeight = 512.0f;
                float originalCenterX = originalWidth / 2.0f;
                float originalCenterY = originalHeight / 2.0f;
                float canvasCenterX = 256.0f;
                float canvasCenterY = 256.0f;
                float translateX = canvasCenterX / 2.0f - originalCenterX / 2.0f * scale;
                float translateY = canvasCenterY / 2.0f - originalCenterY / 2.0f * scale;
                path.setAttribute("transform", "translate(" + translateX + "," + translateY + ") scale(" + scale + ")");
                path.setAttribute("fill", "#FFFFFF");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(outputSvg);
            transformer.transform(source, result);
            ThreadUtil.safeSleep((long)10L);
            return outputSvg.getAbsolutePath();
        }
        catch (Exception e) {
            System.out.println("\u62a5\u9519\u4e86\uff01\uff01\uff01");
            outputSvg.deleteOnExit();
            return null;
        }
    }

    public boolean isValidHexColor(String colorStr) {
        return StrUtil.isNotBlank((CharSequence)colorStr) && colorStr.matches("^#[0-9a-fA-F]{6}$");
    }
}

