/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.organization.dao.PushMapper;
import com.jxdinfo.mp.organization.model.push.PushDO;
import com.jxdinfo.mp.organization.service.PushService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="com.jxdinfo.mp.organization.service.impl.PushServiceImpl")
@HussarDs(value="master")
public class PushServiceImpl
extends ServiceImpl<PushMapper, PushDO>
implements PushService {
    @Resource
    private PushMapper pushMapper;
    @Resource
    private RedisTemplate redisTemplate;

    @Transactional
    public boolean addPush(String channelID, String resource, CurrentLoginUser currentLoginUser) {
        boolean flag;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PushDO::getUserID, (Object)currentLoginUser.getId())).or()).eq(PushDO::getChannelID, (Object)channelID);
        PushDO pushDO = new PushDO();
        pushDO.setUserID(currentLoginUser.getId());
        pushDO.setChannelID(channelID);
        pushDO.setResource(resource);
        this.pushMapper.delete((Wrapper)queryWrapper);
        boolean bl = flag = this.pushMapper.insert(pushDO) > 0;
        if (flag) {
            String key = "push:" + currentLoginUser.getId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("channelid", channelID);
            map.put("resource", resource);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(map);
                String encodeChannelID = Base64.getEncoder().encodeToString(bos.toByteArray());
                System.out.println("\u63a8\u9001\u7684token:" + encodeChannelID);
                HussarCacheUtil.put((String)"eim_cache", (Object)key, (Object)encodeChannelID);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return flag;
    }

    public boolean delPush(String channelID, String resource, CurrentLoginUser currentLoginUser) {
        boolean flag;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PushDO::getUserID, (Object)currentLoginUser.getId())).eq(PushDO::getChannelID, (Object)channelID)).eq(PushDO::getResource, (Object)resource);
        boolean bl = flag = this.pushMapper.delete((Wrapper)queryWrapper) > 0;
        if (flag) {
            String key = "push:" + currentLoginUser.getId();
            HussarCacheUtil.evict((String)"eim_cache", (Object)key);
        }
        return flag;
    }

    public void cleanInvalidPushToken() {
        this.pushMapper.cleanInvalidPushToken();
    }
}

