/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.MobileClient;
import com.jxdinfo.mp.common.model.MobileUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.Role;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.organization.dao.DeviceLoginRecordMapper;
import com.jxdinfo.mp.organization.dao.DeviceMapper;
import com.jxdinfo.mp.organization.model.device.DeviceDO;
import com.jxdinfo.mp.organization.model.device.DeviceDataStatus;
import com.jxdinfo.mp.organization.model.device.DeviceLoginRecordDO;
import com.jxdinfo.mp.organization.model.device.DeviceType;
import com.jxdinfo.mp.organization.service.DeviceLoginRecordService;
import com.jxdinfo.mp.organization.service.DeviceService;
import com.jxdinfo.mp.organization.util.DeviceUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarDs(value="master")
public class DeviceServiceImpl
extends ServiceImpl<DeviceMapper, DeviceDO>
implements DeviceService {
    @Resource
    private DeviceLoginRecordMapper deviceLoginRecordMapper;
    @Resource
    private Environment environment;
    @Resource
    private DeviceLoginRecordService deviceLoginRecordService;

    public Result<PageDTO<DeviceDO>> getAllDeviceList(PageInfo pageInfo, String searchKey, Integer dataStatus, CurrentLoginUser currentLoginUser) {
        boolean isNotPcLoginOrIsNotAdmin;
        String userId = String.valueOf(currentLoginUser.getId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        queryWrapper.like(StrUtil.isNotEmpty((CharSequence)searchKey), DeviceDO::getUserName, (Object)StringUtil.replaceSpecialChar((String)searchKey));
        boolean bl = isNotPcLoginOrIsNotAdmin = !this.isAdmin(currentLoginUser);
        if (isNotPcLoginOrIsNotAdmin) {
            queryWrapper.eq(DeviceDO::getUserID, (Object)userId);
        }
        if (dataStatus != null) {
            queryWrapper.eq(DeviceDO::getDataStatus, (Object)dataStatus);
        } else {
            queryWrapper.ne(DeviceDO::getDataStatus, (Object)DeviceDataStatus.DELETED.ordinal());
        }
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        Page deviceDOPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(Integer.parseInt(String.valueOf(page.getCurrent()))));
        pageDTO.setPageSize(Integer.valueOf(Integer.parseInt(String.valueOf(page.getSize()))));
        pageDTO.setPageCount(Integer.valueOf(Integer.parseInt(String.valueOf(deviceDOPage.getTotal()))));
        pageDTO.setList(deviceDOPage.getRecords());
        return Result.succeed((Object)pageDTO);
    }

    public Result<PageDTO<DeviceLoginRecordDO>> getDeviceLoginRecordList(PageInfo pageInfo, Long deviceId, CurrentLoginUser currentLoginUser) {
        if (this.isMine(currentLoginUser, deviceId) || this.isAdmin(currentLoginUser)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(DeviceLoginRecordDO::getDeviceID, (Object)deviceId)).orderByDesc(HussarBaseEntity::getCreateTime);
            Page page = HussarPageUtils.convert((PageInfo)pageInfo);
            page = (Page)this.deviceLoginRecordService.page((IPage)page, (Wrapper)queryWrapper);
            PageDTO pageDTO = new PageDTO();
            pageDTO.setPageNum(Integer.valueOf(Integer.parseInt(String.valueOf(page.getCurrent()))));
            pageDTO.setPageSize(Integer.valueOf(Integer.parseInt(String.valueOf(page.getSize()))));
            pageDTO.setPageCount(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
            pageDTO.setList(page.getRecords());
            return Result.succeed((Object)pageDTO);
        }
        return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c!");
    }

    @Transactional
    public boolean removeDevice(List<Long> deviceId, CurrentLoginUser currentLoginUser) {
        boolean flag = false;
        if (this.isLogin(currentLoginUser)) {
            List deviceDO = this.listByIds(deviceId);
            List userIds = deviceDO.stream().map(DeviceDO::getUserID).collect(Collectors.toList());
            boolean bl = flag = HussarUtils.isNotEmpty((Object)deviceDO) && userIds.contains(currentLoginUser.getId());
        }
        if (flag || this.isAdmin(currentLoginUser)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(DeviceDO::getDataStatus, (Object)0);
            updateWrapper.in(DeviceDO::getDeviceId, deviceId);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(DeviceLoginRecordDO::getDeviceID, deviceId);
            this.deviceLoginRecordMapper.delete((Wrapper)new LambdaQueryWrapper().in(DeviceLoginRecordDO::getDeviceID, deviceId));
            return this.update((Wrapper)updateWrapper);
        }
        return false;
    }

    public Result<Boolean> updateDevice(List<Long> deviceId, CurrentLoginUser currentLoginUser) {
        boolean flag = false;
        if (this.isLogin(currentLoginUser)) {
            List deviceDO = this.listByIds(deviceId);
            List userIds = deviceDO.stream().map(DeviceDO::getUserID).collect(Collectors.toList());
            boolean bl = flag = HussarUtils.isNotEmpty((Object)deviceDO) && userIds.contains(currentLoginUser.getId());
        }
        if (flag || this.isAdmin(currentLoginUser)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(DeviceDO::getDataStatus, (Object)1)).in(DeviceDO::getDeviceId, deviceId);
            return Result.succeed((Object)this.update((Wrapper)updateWrapper));
        }
        return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c!");
    }

    public DeviceDO getDeviceDO(String identifier, Long userID, int dataStatus) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DeviceDO::getIdentifier, (Object)identifier)).eq(DeviceDO::getUserID, (Object)userID)).eq(DeviceDO::getDataStatus, (Object)dataStatus);
        return (DeviceDO)this.getOne((Wrapper)queryWrapper);
    }

    public DeviceDO getExistedDeviceDO(String identifier, Long userID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"IDENTIFIER", (Object)identifier)).eq((Object)"USER_ID", (Object)userID)).ne((Object)"DATA_STATUS", (Object)DeviceDataStatus.DELETED.ordinal());
        return (DeviceDO)this.getOne((Wrapper)queryWrapper);
    }

    public boolean manageDevice(MobileUser mobileUser) {
        boolean isAndroid;
        MobileClient mobileClient = mobileUser.getMobileClient();
        boolean deviceIsControlled = Boolean.parseBoolean(this.environment.getProperty("mp.device.controlled"));
        boolean isIos = DeviceType.IOS.ordinal() == Integer.valueOf(mobileClient.getDeviceTag()).intValue();
        boolean bl = isAndroid = DeviceType.ANDROID.ordinal() == Integer.valueOf(mobileClient.getDeviceTag()).intValue();
        if (deviceIsControlled && (isIos || isAndroid)) {
            DeviceDO auditedDeviceDO = this.getDeviceDO(mobileClient.getUniqueIdentifier(), mobileUser.getUserID(), DeviceDataStatus.AUDITED.ordinal());
            if (auditedDeviceDO == null) {
                if (this.getDeviceDO(mobileClient.getUniqueIdentifier(), mobileUser.getUserID(), DeviceDataStatus.UNAUDITED.ordinal()) == null) {
                    this.save(DeviceUtil.getDeviceDO(mobileUser));
                }
                return false;
            }
            DeviceLoginRecordDO deviceLoginRecordDO = DeviceUtil.getDeviceLoginRecordDO(mobileClient);
            deviceLoginRecordDO.setDeviceID(auditedDeviceDO.getDeviceId());
            deviceLoginRecordDO.setStatus(Integer.valueOf(1));
            this.deviceLoginRecordMapper.insert(deviceLoginRecordDO);
        } else {
            DeviceDO existedDeviceDO = this.getExistedDeviceDO(mobileClient.getUniqueIdentifier(), mobileUser.getUserID());
            if (existedDeviceDO == null) {
                DeviceDO deviceDO = DeviceUtil.getDeviceDO(mobileUser);
                deviceDO.setDataStatus(Integer.valueOf(DeviceDataStatus.AUDITED.ordinal()));
                this.save(deviceDO);
                DeviceLoginRecordDO deviceLoginRecordDO = DeviceUtil.getDeviceLoginRecordDO(mobileClient);
                deviceLoginRecordDO.setDeviceID(deviceDO.getDeviceId());
                deviceLoginRecordDO.setStatus(Integer.valueOf(1));
                this.deviceLoginRecordMapper.insert(deviceLoginRecordDO);
            } else {
                DeviceLoginRecordDO deviceLoginRecordDO = DeviceUtil.getDeviceLoginRecordDO(mobileClient);
                deviceLoginRecordDO.setDeviceID(existedDeviceDO.getDeviceId());
                deviceLoginRecordDO.setStatus(Integer.valueOf(1));
                this.deviceLoginRecordMapper.insert(deviceLoginRecordDO);
            }
        }
        return true;
    }

    boolean isLogin(CurrentLoginUser currentLoginUser) {
        return currentLoginUser != null;
    }

    public boolean isMine(CurrentLoginUser currentLoginUser, Long id) {
        if (this.isLogin(currentLoginUser)) {
            DeviceDO deviceDO = (DeviceDO)this.getById(id);
            return deviceDO != null && currentLoginUser.getId().equals(deviceDO.getUserID());
        }
        return false;
    }

    public boolean isAdmin(CurrentLoginUser currentLoginUser) {
        List collect = currentLoginUser.getRoles().stream().map(Role::getRoleId).collect(Collectors.toList());
        Long roleId = Long.valueOf(Objects.requireNonNull(this.environment.getProperty("mp.role.sysAdmin")));
        Long jqxAdminRoleId = Long.valueOf(Objects.requireNonNull(this.environment.getProperty("mp.role.jqx_admin_role")));
        return this.isLogin(currentLoginUser) && (collect.contains(roleId) || collect.contains(jqxAdminRoleId));
    }
}

