/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.NotifyType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.dto.ThumbnailDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.mp.common.config.OrganizationProperties;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.MobileClient;
import com.jxdinfo.mp.common.model.MobileUser;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterDO;
import com.jxdinfo.mp.common.model.RosterDTO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.im.service.IIMService;
import com.jxdinfo.mp.organization.dao.IHeadImgMapper;
import com.jxdinfo.mp.organization.dao.PlatBindMapper;
import com.jxdinfo.mp.organization.dao.SysUserJqxMapper;
import com.jxdinfo.mp.organization.dao.UserMapperJqx;
import com.jxdinfo.mp.organization.dao.UserMessageMapper;
import com.jxdinfo.mp.organization.feign.EimPubPlatService2;
import com.jxdinfo.mp.organization.model.device.DeviceType;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.model.mainuser.CSTypeVO;
import com.jxdinfo.mp.organization.model.mobileclient.MobileAppVO;
import com.jxdinfo.mp.organization.model.mobileuser.MobileUserVO;
import com.jxdinfo.mp.organization.model.mobileuser.UserVO;
import com.jxdinfo.mp.organization.model.platBind.PlatBindDO;
import com.jxdinfo.mp.organization.model.platBind.PlatBindDTO;
import com.jxdinfo.mp.organization.service.ClearCacheService;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.DeviceService;
import com.jxdinfo.mp.organization.service.LinkManService;
import com.jxdinfo.mp.organization.service.UserCacheService;
import com.jxdinfo.mp.organization.service.UserService;
import com.jxdinfo.mp.organization.util.DeviceUtil;
import com.jxdinfo.mp.organization.util.SvgUtil;
import com.jxdinfo.mp.zone.service.IZoneBoService;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarDs(value="master")
public class UserServiceImpl
extends ServiceImpl<UserMapperJqx, RosterDO>
implements UserService {
    @Resource
    private UserMapperJqx userMapperJqx;
    @Resource
    private PlatBindMapper platBindMapper;
    @Resource
    private UserCacheService userCacheService;
    @Resource
    private IZoneBoService zoneBoService;
    @Resource
    private EimPubPlatService2 eimPubPlatService2;
    @Resource
    private IIMService imService;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private DeviceService deviceService;
    @Resource
    private OrganizationProperties organizationProperties;
    @Resource
    private UserMessageMapper userMessageMapper;
    @Autowired
    private IHeadImgMapper headImgMapper;
    @Resource
    private ContactService contactService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private SysUserJqxMapper sysUserJqxMapper;
    @Resource
    private IHussarBaseStaffBoService staffBoService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ClearCacheService clearCacheService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private SvgUtil sysUtil;
    @Resource
    private LinkManService linkManService;

    public boolean updateUserRemind(CurrentLoginUser currentLoginUser, Integer isVibrateRemind, Integer isSoundRemind) {
        RosterDO eimUser = new RosterDO();
        eimUser.setUserID(currentLoginUser.getId());
        eimUser.setIsVibrateRemind(isVibrateRemind);
        eimUser.setIsSoundRemind(isSoundRemind);
        this.saveOrUpdate(eimUser);
        this.userCacheService.clearUserAll();
        this.redisTemplate.delete((Object)("soundRemind:" + currentLoginUser.getId()));
        return true;
    }

    public Map<String, Integer> getUserRemind(CurrentLoginUser currentLoginUser) {
        return this.userMapperJqx.getUserRemind(currentLoginUser.getId());
    }

    public Result<Boolean> bindPlat(Long userID, PlatBindDTO platBindDTO) {
        String time = DateUtil.now();
        PlatBindDO platBindDO = new PlatBindDO();
        if ("1".equals(platBindDTO.getOperateType())) {
            if (this.userMapperJqx.getBingingCount(platBindDTO.getPlatType(), platBindDTO.getPlatID()) > 0) {
                return Result.succeed((Object)false);
            }
            platBindDO.setObjID(Long.valueOf(IdWorker.getId((Object)platBindDO)));
            platBindDO.setUserID(userID);
            platBindDO.setCreateTime(time);
            platBindDO.setModifyTime(time);
            BeanUtil.copyProperties((Object)platBindDTO, (Object)platBindDO, (String[])new String[0]);
            return Result.succeed((Object)(this.platBindMapper.insert(platBindDO) > 0 ? 1 : 0));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PlatBindDO::getUserID, (Object)userID)).eq(PlatBindDO::getPlatID, (Object)platBindDTO.getPlatID())).eq(PlatBindDO::getPlatType, (Object)platBindDTO.getPlatType());
        return Result.succeed((Object)(this.platBindMapper.delete((Wrapper)queryWrapper) > 0 ? 1 : 0));
    }

    @HussarTokenDs
    public Result platLogin(PlatBindDTO platBindDTO) {
        MobileUserVO mobileUserVO = this.userMapperJqx.platLogin(platBindDTO.getPlatType(), platBindDTO.getPlatID());
        if (mobileUserVO == null) {
            return Result.failed((Object)false, (String)"\u672a\u7ed1\u5b9a\u4e09\u65b9\u5e73\u53f0");
        }
        String password = mobileUserVO.getPassword();
        PlatBindDO platBindDO = new PlatBindDO();
        platBindDO.setPlatHeadUrl(platBindDTO.getPlatHeadUrl());
        platBindDO.setPlatName(platBindDTO.getPlatName());
        platBindDO.setModifyTime(DateUtil.now());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PlatBindDO::getUserID, (Object)mobileUserVO.getUid())).eq(PlatBindDO::getPlatID, (Object)platBindDTO.getPlatID())).eq(PlatBindDO::getPlatType, (Object)platBindDTO.getPlatType());
        this.platBindMapper.update(platBindDO, (Wrapper)wrapper);
        mobileUserVO.setPassword(password);
        if (mobileUserVO.getDeptId().equals(this.organizationProperties.getDepartingOrgId())) {
            return Result.failed((Object)false, (String)"\u4eba\u5458\u5df2\u79bb\u804c\uff0c\u62d2\u7edd\u767b\u5f55");
        }
        MobileUser mobileUser = platBindDTO.getMobileUser();
        if (mobileUser != null && DeviceUtil.needDeviceManagement(mobileUser)) {
            mobileUser.setUsername(mobileUserVO.getName());
            mobileUser.setUserID(mobileUserVO.getUid());
            if (!this.deviceService.manageDevice(mobileUser)) {
                return Result.failed((String)"\u8be5\u8bbe\u5907\u9996\u6b21\u767b\u5f55\u9700\u8981\u8ba4\u8bc1\uff01");
            }
        }
        return Result.succeed((Object)mobileUserVO);
    }

    public List<Map<String, String>> getPlatStatus(Long userID) {
        List<Map<String, String>> platStatus = this.userMapperJqx.getPlatStatus(userID);
        if (!platStatus.isEmpty()) {
            return platStatus;
        }
        return new ArrayList<Map<String, String>>();
    }

    public Result<MobileAppVO> getMobileApp(MobileClient mobileClient) {
        String version;
        String clientDevice = mobileClient.getDeviceType();
        String string = version = mobileClient.getAppVersion() == null ? "" : mobileClient.getAppVersion();
        if (!StrUtil.isEmpty((CharSequence)clientDevice)) {
            MobileAppVO pcApp;
            MobileAppVO androidApp;
            MobileAppVO iosApp;
            if (("iphone".equals(clientDevice = clientDevice.toLowerCase()) || "ipad".equals(clientDevice)) && (iosApp = this.userMapperJqx.getIosApp()) != null && !version.equals(iosApp.getVersionCode())) {
                return Result.succeed((Object)iosApp);
            }
            if ("android".equals(clientDevice) && (androidApp = this.userMapperJqx.getAndroidApp()) != null && !version.equals(androidApp.getVersionCode())) {
                return Result.succeed((Object)androidApp);
            }
            if ("pc".equals(clientDevice) && (pcApp = this.userMapperJqx.getPcApp()) != null && !version.equals(pcApp.getVersionCode())) {
                return Result.succeed((Object)pcApp);
            }
        }
        return Result.succeed(null);
    }

    public JSONObject getJobNum(String companyID) {
        JSONObject jsonObject = new JSONObject();
        StaffBo staff = this.staffBoService.findStaffByUserId(BaseSecurityUtil.getUser().getUserId());
        if (StrUtil.isEmpty((CharSequence)staff.getWorkId())) {
            jsonObject.put("success", (Object)false);
            jsonObject.put("errorcode", (Object)100);
        } else {
            jsonObject.put("success", (Object)true);
            jsonObject.put("jobnum", (Object)staff.getWorkId());
        }
        return jsonObject;
    }

    public Map<String, Object> sycConfig(CurrentLoginUser currentLoginUser, String time, String zoneTime) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String newTime = DateUtil.now();
        int unReadZoneMsg = 1;
        if (!StrUtil.isEmpty((CharSequence)zoneTime)) {
            String unReadCount = this.zoneBoService.getUnreadMessage(zoneTime, currentLoginUser);
            unReadZoneMsg = unReadCount != null ? Integer.valueOf(unReadCount) : 0;
        }
        Long userId = currentLoginUser.getId();
        List groupVOList = this.imService.getGroupStatus(currentLoginUser, time);
        List data = (List)this.eimPubPlatService2.getPubStatus(currentLoginUser, time).getData();
        Map<String, Integer> remindMap = this.userMapperJqx.getUserRemind(userId);
        List rosterVOList = this.linkManService.getTopFriend(userId, time);
        resultMap.put("room", groupVOList);
        resultMap.put("pubplat", data);
        resultMap.put("userconfig", remindMap);
        resultMap.put("time", newTime);
        resultMap.put("zoneunread", unReadZoneMsg);
        resultMap.put("user", rosterVOList);
        MobileClient mobileClient = (MobileClient)HussarCacheUtil.get((String)"eim_cache", (Object)("mobileClient:" + BaseSecurityUtil.getTokenValue()));
        if (mobileClient != null) {
            String appVersion = mobileClient.getAppVersion();
            String deviceType = mobileClient.getDeviceType();
            if (!StrUtil.isEmpty((CharSequence)appVersion) && !StrUtil.isEmpty((CharSequence)deviceType) && (DeviceType.ANDROID.name().equalsIgnoreCase(deviceType) && UserServiceImpl.compareVersions(appVersion, "3.2.9") < 0 || DeviceType.IOS.name().equalsIgnoreCase(deviceType) && UserServiceImpl.compareVersions(appVersion, "3.2.0") < 0)) {
                HussarCacheUtil.put((String)"eim_cache", (Object)("badgecache:" + currentLoginUser.getId()), (Object)"0");
            }
        }
        return resultMap;
    }

    public static int compareVersions(String version1, String version2) {
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        int maxLength = Math.max(v1.length, v2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < v1.length ? Integer.parseInt(v1[i]) : 0;
            int n = num2 = i < v2.length ? Integer.parseInt(v2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }

    public boolean updateUserMessage(RosterDTO rosterDTO, Long userID) {
        if (NotifyType.USER_CHANGE.getCode().equals(rosterDTO.getNotifyType())) {
            SysUsers sysUsers = new SysUsers();
            BeanUtil.copyProperties((Object)rosterDTO, (Object)sysUsers, (String[])new String[0]);
            sysUsers.setId(Long.valueOf(Long.parseLong(rosterDTO.getUserID())));
            sysUsers.setUserAccount(rosterDTO.getUserCode());
            sysUsers.setPassword(rosterDTO.getEncryptedPassword());
            sysUsers.setAccountStatus(String.valueOf(rosterDTO.getDataStatus()));
            sysUsers.setUserNamePinyinFull(rosterDTO.getCharIndex());
            sysUsers.setCorporationId(rosterDTO.getCompanyID());
            sysUsers.setDepartmentId(rosterDTO.getOrganiseID());
            sysUsers.setMobile(rosterDTO.getPhoneNum());
            sysUsers.setTelephone(rosterDTO.getOfficePhoneNum());
            sysUsers.setUserOrder(rosterDTO.getShowOrder());
            if (rosterDTO.getChangeType().intValue() == DataChangeType.INSERT.getCode() || rosterDTO.getChangeType().intValue() == DataChangeType.UPDATE.getCode()) {
                this.sysUsersService.saveOrUpdate((Object)sysUsers);
            } else if (rosterDTO.getChangeType().intValue() == DataChangeType.DELETE.getCode()) {
                this.sysUsersService.removeById((Object)sysUsers);
            } else if (rosterDTO.getChangeType().intValue() == DataChangeType.RELATE.getCode()) {
                // empty if block
            }
            this.log.error("\u7528\u6237\u53d8\u66f4\u901a\u77e5");
        } else if (NotifyType.STAFF_CHANGE.getCode().equals(rosterDTO.getNotifyType())) {
            SysStaff sysStaff = new SysStaff();
            BeanUtil.copyProperties((Object)rosterDTO, (Object)sysStaff, (String[])new String[0]);
            sysStaff.setId(rosterDTO.getStaffId());
            sysStaff.setWorkId(rosterDTO.getJobNum());
            sysStaff.setStaffPosition(String.valueOf(rosterDTO.getPositionID()));
            if (rosterDTO.getChangeType().intValue() == DataChangeType.INSERT.getCode() || rosterDTO.getChangeType().intValue() == DataChangeType.UPDATE.getCode()) {
                sysStaff.setDelFlag("0");
                this.sysStaffService.saveOrUpdate((Object)sysStaff);
            } else if (rosterDTO.getChangeType().intValue() == DataChangeType.DELETE.getCode()) {
                this.sysStaffService.removeById((Object)sysStaff);
            } else if (rosterDTO.getChangeType().intValue() == DataChangeType.RELATE.getCode()) {
                // empty if block
            }
            this.log.error("\u4eba\u5458\u53d8\u66f4\u901a\u77e5");
        }
        return true;
    }

    @Transactional
    public boolean updateHeadImg(Long userID, String headImgId) {
        HeadingImg head = new HeadingImg();
        head.setHeadimgId(userID);
        head.setFileName("");
        head.setFileId(Long.valueOf(Long.parseLong(headImgId)));
        head.setFilePath("");
        head.setFileSize(BigDecimal.valueOf(0L));
        HeadingImg headingImg = (HeadingImg)this.headImgMapper.selectById(userID);
        if (null == headingImg || HussarUtils.isEmpty((Object)headingImg.getFileId())) {
            this.headImgMapper.insert(head);
        } else {
            this.headImgMapper.updateById(head);
        }
        RosterDO rosterDO = new RosterDO();
        rosterDO.setUserID(userID);
        this.userMessageMapper.updateById(rosterDO);
        this.clearCacheService.clearCacheByUserID(userID);
        return true;
    }

    public CSTypeVO getCsType(Long typeID, int pageSize, int pageNum) {
        CSTypeVO csTypeVO = new CSTypeVO();
        PageVO pageVO = new PageVO();
        if (typeID != null) {
            csTypeVO = this.userMessageMapper.getCustomTypeByTypeID(typeID);
        }
        csTypeVO.setCsTypes(this.userMessageMapper.getCustomTypeUserByTypeID(typeID));
        List<RosterVO> rosterVOList = this.userMessageMapper.getCustomUserByTypeID(typeID);
        int start = PageUtil.transToStartEnd((int)pageNum, (int)pageSize)[0];
        int end = PageUtil.transToStartEnd((int)pageNum, (int)pageSize)[1];
        rosterVOList = start >= rosterVOList.size() ? new ArrayList<RosterVO>() : (end >= rosterVOList.size() ? rosterVOList.subList(start, rosterVOList.size()) : rosterVOList.subList(start, end));
        pageVO.setList(rosterVOList);
        pageVO.setPageCount(Integer.valueOf(this.userMessageMapper.getCustomUserNumByTypeID(typeID)));
        csTypeVO.setMembersCount(pageVO.getPageCount().intValue());
        csTypeVO.setUsers(pageVO);
        return csTypeVO;
    }

    public List<UserStaffVo> getUser(List<Long> userIDs, String searchKey, Long currentUserID, int pageNum, int pageSize, String orgIDs, String roleIDs) {
        List collect;
        Long departOrganiseId = 1696830512947708241L;
        List sysUsers = new ArrayList();
        if (HussarUtils.isNotEmpty(userIDs)) {
            Map userInfo = this.userBoService.getUserInfo(userIDs);
            Iterator iterator = userInfo.keySet().iterator();
            while (iterator.hasNext()) {
                sysUsers.add(userInfo.get(iterator.next()));
            }
        } else {
            sysUsers = this.sysUserJqxMapper.selectList((Wrapper)new LambdaQueryWrapper().ne(SysUsers::getDepartmentId, (Object)departOrganiseId));
        }
        if (!HussarUtils.isEmpty((Object)orgIDs)) {
            List orgIDList = Arrays.stream(orgIDs.split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
            int i = 0;
            while (i < orgIDList.size()) {
                List childList = this.contactService.getAllChildList((Long)orgIDList.get(i));
                int finalI = i++;
                childList.removeIf(n -> n.equals(orgIDList.get(finalI)));
                orgIDList.addAll(childList);
            }
            sysUsers.stream().filter(f -> orgIDList.contains(f.getDepartmentId())).collect(Collectors.toList());
        }
        if (!HussarUtils.isEmpty((Object)roleIDs)) {
            List roleIds = Arrays.stream(roleIDs.split(",")).map(Long::valueOf).collect(Collectors.toList());
            List roleUserDOS = this.userBoService.getUserInfoByRoleId(roleIds);
            List userid = roleUserDOS.stream().map(UserVo::getId).collect(Collectors.toList());
            sysUsers.stream().filter(f -> userid.contains(f.getId())).collect(Collectors.toList());
        }
        List<Long> userId = sysUsers.stream().map(SysUsers::getId).collect(Collectors.toList());
        List<com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo> userAndStaffInfo = this.sysUserJqxMapper.getUserAndStaffInfo(userId);
        if (HussarUtils.isNotEmpty((Object)searchKey)) {
            List userStaffVoList = userAndStaffInfo.stream().filter(f -> ToolUtil.isNotEmpty((Object)f.getUserName()) && f.getUserName().contains(searchKey) || ToolUtil.isNotEmpty((Object)f.getWorkId()) && f.getWorkId().contains(searchKey)).collect(Collectors.toList());
            collect = userStaffVoList.stream().map(com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo::getUserId).collect(Collectors.toList());
        } else {
            collect = userAndStaffInfo.stream().map(com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo::getUserId).collect(Collectors.toList());
        }
        if (HussarUtils.isEmpty(collect)) {
            return new ArrayList<UserStaffVo>();
        }
        return this.contactService.getUserStaff(collect);
    }

    public void getUserImage(HttpServletResponse response, String type, Long userId, String imageType) {
        ApiResponse sysApplicationVoApiResponse;
        SysApplicationVo sysApplicationVo;
        Long fileId = null;
        if (type == null || type.equals("0") || type.equals("1")) {
            HeadingImg headingImg = (HeadingImg)this.headImgMapper.selectById(userId);
            if (headingImg != null && StringUtil.isNotEmpty((Object)headingImg.getFileId())) {
                fileId = headingImg.getFileId();
            }
        } else if (type.equals("2") && (sysApplicationVo = (SysApplicationVo)(sysApplicationVoApiResponse = this.sysApplicationService.getNoAuthAppDetail(userId)).getData()) != null && StringUtil.isNotEmpty((Object)sysApplicationVo.getAppIcon())) {
            if (sysApplicationVo.getAppIconType().equals("2")) {
                fileId = Long.parseLong(sysApplicationVo.getAppIcon());
            } else {
                String svgPath = this.sysUtil.svg2Png(sysApplicationVo.getAppIcon(), sysApplicationVo.getAppIconColor());
                if (StrUtil.isNotEmpty((CharSequence)svgPath)) {
                    try {
                        FileUtil.writeToStream((String)svgPath, (OutputStream)response.getOutputStream());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("\u8bfb\u53d6svg\u56fe\u6807\u5931\u8d25");
                    }
                }
                return;
            }
        }
        if (fileId != null) {
            AttachmentManagerModel modelById = this.attachmentManagerService.getModelById(fileId);
            this.log.warn("\u83b7\u53d6\u5230\u5934\u50cf\u7684\u6587\u4ef6\u4fe1\u606f\uff1a" + modelById);
            if (modelById == null || modelById.getId() == null || modelById.getId() == 0L) {
                return;
            }
            ThumbnailDto thumbnailDto = new ThumbnailDto();
            if (imageType != null && imageType.equals("100*100")) {
                thumbnailDto.setHeight(Integer.valueOf(100));
                thumbnailDto.setWidth(Integer.valueOf(100));
            }
            try {
                this.attachmentManagerService.fileDownload(response, fileId, thumbnailDto);
            }
            catch (Exception e) {
                this.log.warn("\u83b7\u53d6\u7528\u6237\u5934\u50cf\u5931\u8d25:" + e.getMessage());
            }
        }
    }

    public List<RosterVO> getUserDetailList(List<Long> userIdList) {
        return this.userMapperJqx.getUserDetailList(userIdList);
    }

    public UserVO getUserInfo(Long userId) {
        UserVO userVO = new UserVO();
        StaffBo staff = this.staffBoService.findStaffByUserId(userId);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(userId);
        Map userInfo = this.userBoService.getUserInfo(ids);
        BeanUtil.copyProperties((Object)staff, (Object)userVO, (String[])new String[0]);
        return userVO;
    }
}

