/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.mp.common.model.MobileClient;
import com.jxdinfo.mp.common.model.MobileUser;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.organization.dao.UserMapperJqx;
import com.jxdinfo.mp.organization.model.mobileuser.MobileUserVO;
import com.jxdinfo.mp.organization.service.DeviceService;
import com.jxdinfo.mp.organization.service.LoginService;
import com.jxdinfo.mp.organization.service.UserCacheService;
import com.jxdinfo.mp.organization.util.DeviceUtil;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class LoginServiceImpl
implements LoginService {
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private UserCacheService userCacheService;
    @Resource
    private DeviceService deviceService;
    @Resource
    private UserMapperJqx userMapperJqx;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;

    public Result login(MobileUser mobileUser) {
        RosterVO rosterVO;
        String token = BaseSecurityUtil.getTokenValue();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        MobileUserVO mobileUserVO = new MobileUserVO();
        mobileUserVO.setUid(securityUser.getUserId());
        mobileUserVO.setName(securityUser.getUserName());
        mobileUserVO.setCode(securityUser.getAccount());
        mobileUserVO.setDeptId(securityUser.getDeptId());
        mobileUserVO.setDeptName(securityUser.getDeptName());
        mobileUserVO.setCompId(securityUser.getTenantId());
        mobileUserVO.setCompName(securityUser.getTenantName());
        String compName = "";
        mobileUserVO.setCompName(compName);
        if (DeviceUtil.needDeviceManagement(mobileUser)) {
            mobileUser.setUsername(mobileUserVO.getName());
            mobileUser.setUserID(securityUser.getUserId());
            if (!this.deviceService.manageDevice(mobileUser)) {
                return Result.failed((String)"\u8be5\u8bbe\u5907\u9996\u6b21\u767b\u5f55\u9700\u8981\u8ba4\u8bc1\uff01");
            }
        }
        if (ToolUtil.isNotEmpty((Object)(rosterVO = this.userMapperJqx.userDetail(mobileUserVO.getUid())))) {
            mobileUserVO.setChar1(rosterVO.getChar1());
            mobileUserVO.setHeadImgId(rosterVO.getHeadImgId());
        } else {
            Map map = this.hussarBaseUserBoService.getUserInfo(Collections.singletonList(mobileUserVO.getUid()));
            if (ToolUtil.isNotEmpty(map.get(mobileUserVO.getUid()))) {
                mobileUserVO.setChar1(((SysUsers)map.get(mobileUserVO.getUid())).getChar1());
            }
        }
        MobileClient mobileClient = mobileUser.getMobileClient();
        if (mobileClient != null) {
            HussarCacheUtil.put((String)"eim_cache", (Object)("mobileClient:" + token), (Object)mobileClient);
        }
        return Result.succeed((Object)mobileUserVO);
    }

    public SecurityUser testLogin() {
        return BaseSecurityUtil.getUser();
    }
}

