/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.pubplat.PubPlatMenuVO;
import com.jxdinfo.mp.organization.model.menu.PubPlatAuthorizeDTO;
import com.jxdinfo.mp.organization.model.menu.PubPlatMenuDO;
import com.jxdinfo.mp.organization.model.menu.PubPlatMenuDTO;
import com.jxdinfo.mp.organization.service.IPubPlatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u5e94\u7528\u540e\u53f0\u7ba1\u7406"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/pubPlat/manager"})
public class PubPlatManageController {
    private static final Logger log = LoggerFactory.getLogger(PubPlatManageController.class);
    @Resource
    private IPubPlatService iPubPlatService;

    @ApiOperation(value="\u5fae\u5e94\u7528\u83dc\u5355\u6388\u6743")
    @PostMapping(value={"/menu/grant"})
    @Permission(manage={AdminEnum.PUB_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> powerMenuView(@RequestBody PubPlatAuthorizeDTO authorizeDTO) {
        return Result.succeed((Object)this.iPubPlatService.powerPerson(authorizeDTO.getPubMenuId(), authorizeDTO.getUserIds(), authorizeDTO.getOrganiseIds(), authorizeDTO.getRoleIds(), "pubMenu"));
    }

    @ApiOperation(value="\u6839\u636e\u5fae\u5e94\u7528\u7684id\u67e5\u8be2\u67e5\u770b\u8be5\u5fae\u5e94\u7528\u83dc\u5355\u7684\u4eba\u5458\uff0c\u90e8\u95e8\uff0c\u89d2\u8272")
    @GetMapping(value={"/menu/view"})
    public Result<Map<String, List>> getMenuViewer(@RequestParam(value="pubMenuID") @ApiParam(value="\u5fae\u5e94\u7528id") String pubMenuID) {
        return Result.succeed((Object)this.iPubPlatService.getUsersByObjID(pubMenuID, "menuView"));
    }

    @ApiOperation(value="\u52a0\u8f7d\u5fae\u5e94\u7528\u83dc\u5355\u6811")
    @GetMapping(value={"/menuTree"})
    public Result<List<PubPlatMenuVO>> loadMenuTree(@RequestParam(value="objId") @ApiParam(value="\u5fae\u5e94\u7528id") String objID) {
        return Result.succeed((Object)this.iPubPlatService.loadMenuTree(objID));
    }

    @ApiOperation(value="\u52a0\u8f7d\u7528\u6237\u7684\u5fae\u5e94\u7528\u83dc\u5355\u6811")
    @GetMapping(value={"/menuTreeByUser"})
    public Result<List<PubPlatMenuVO>> loadMenuTreeByPermission(@RequestParam(value="objId") @ApiParam(value="\u5fae\u5e94\u7528id") String objID) {
        return Result.succeed((Object)this.iPubPlatService.loadMenuTreeByPermission(objID));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5fae\u5e94\u7528\u83dc\u5355\u5217\u8868")
    @GetMapping(value={"/menuList"})
    public Result<PageDTO<PubPlatMenuVO>> selectMenuList(@RequestParam(value="objId", required=false) @ApiParam(value="\u5fae\u5e94\u7528id") String objID, @RequestParam(value="menuName", required=false) @ApiParam(value="\u83dc\u5355\u540d\u79f0") String menuName, @RequestParam(value="parentMenuId", required=false) @ApiParam(value="\u7236\u7ea7\u83dc\u5355ID") String parentMenuID, @RequestParam(value="pageIndex", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageIndex, @RequestParam(value="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        return Result.succeed((Object)this.iPubPlatService.selectMenuList(objID, menuName, parentMenuID, pageIndex, pageSize));
    }

    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u4fe1\u606f")
    @PostMapping(value={"/menu/save"})
    @Permission(manage={AdminEnum.PUB_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> saveMenu(@RequestBody @ApiParam(value="\u5fae\u5e94\u7528\u83dc\u5355\u4fe1\u606f") PubPlatMenuDTO pubPlatMenuDTO) {
        return this.iPubPlatService.saveMenu(pubPlatMenuDTO);
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355\u4fe1\u606f")
    @PostMapping(value={"/menu/edit"})
    @Permission(manage={AdminEnum.PUB_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> editMenu(@RequestBody @ApiParam(value="\u5fae\u5e94\u7528\u83dc\u5355\u4fe1\u606f") PubPlatMenuDO pubPlatMenuDO) {
        return this.iPubPlatService.editMenu(pubPlatMenuDO);
    }

    @ApiOperation(value="\u5220\u9664\u83dc\u5355\u4fe1\u606f")
    @GetMapping(value={"/menu/delete"})
    @Permission(manage={AdminEnum.PUB_MANAGER_ROLE, AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> deleteMenus(@RequestParam(value="menuId") @ApiParam(value="\u83dc\u5355id") String menuID, @LoginUser(isFull=true) CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.iPubPlatService.deleteMenus(menuID));
    }

    @ApiOperation(value="\u67e5\u8be2\u5fae\u5e94\u7528\u63a8\u9001\u5217\u8868")
    @GetMapping(value={"/push/list"})
    public Result<PageDTO<Map<String, Object>>> queryPubMsgPush(@RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @RequestParam(value="mode", defaultValue="1") @ApiParam(value="\u63a8\u9001\u6a21\u5f0f\uff1a1-\u5df2\u63a8\u9001\uff0c2-\u5b9a\u65f6\u5f85\u63a8\u9001") int mode) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.iPubPlatService.queryPubMsgPush(pageDTO, searchKey, mode));
    }

    @ApiOperation(value="\u67e5\u8be2\u5fae\u5e94\u7528\u63a8\u9001\u7684\u4eba")
    @GetMapping(value={"/msgReceiver"})
    public Result<Page<String>> getReceiver(@RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @RequestParam @ApiParam(value="\u63a8\u9001\u5386\u53f2id") String msgID, @RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID, @RequestParam(required=false) String orgIDs, @RequestParam(required=false) String roleIDs) {
        return this.iPubPlatService.getReceiver(pageNum, pageSize, searchKey, msgID, pubPlatID, orgIDs, roleIDs);
    }
}

