/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eim.application.extend.dao.SysEimApplicationExtendMapper;
import com.jxdinfo.hussar.eim.application.extend.model.SysEimApplicationExtend;
import com.jxdinfo.hussar.eim.application.extend.service.ISysEimApplicationExtendService;
import com.jxdinfo.hussar.eim.application.extend.vo.SysEimApplicationExtendVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeService;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.application.vo.WorkstationApplicationVo;
import com.jxdinfo.mp.organization.model.device.DeviceType;
import com.jxdinfo.mp.organization.model.pubPlat.ApplicationExtendVo;
import com.jxdinfo.mp.organization.model.pubPlat.EimPubplatAttention;
import com.jxdinfo.mp.organization.model.pubPlat.SysAppExtendGroupVo;
import com.jxdinfo.mp.organization.service.IEimPubplatAttentionService;
import com.jxdinfo.mp.organization.service.IPubPlatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5fae\u5e94\u7528"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/pubPlat"})
public class PubPlatController {
    private static final Logger log = LoggerFactory.getLogger(PubPlatController.class);
    @Resource
    private IPubPlatService pubPlatService;
    @Autowired
    private ISysAppVisitAuthorizeService sysAppVisitAuthorizeService;
    @Autowired
    private ISysEimApplicationExtendService eimApplicationExtendService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private IEimPubplatAttentionService eimPubplatAttentionService;
    @Resource
    private SysEimApplicationExtendMapper sysEimApplicationExtendMapper;

    @GetMapping(value={"/eim/manager/pageList"})
    @ApiOperation(value="\u67e5\u5fae\u5e94\u7528")
    public Result<Page<WorkstationApplicationVo>> getPageList(@RequestParam(value="searchKey", required=false) String searchKey, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="30") int pageSize, @RequestParam(value="classifyId", required=false) String classifyID, @RequestParam(value="appTypes", required=false) String appTypes) {
        return this.pubPlatService.getPageList(searchKey, pageNum, pageSize, classifyID, appTypes);
    }

    @GetMapping(value={"/mobileType/manager/pageList"})
    @ApiOperation(value="\u67e5\u5fae\u5e94\u7528")
    public Result<Page<WorkstationApplicationVo>> getMobileTypePageList(@RequestParam(value="searchKey", required=false) String searchKey, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="30") int pageSize, @RequestParam(value="classifyId", required=false) String classifyID, @RequestParam(value="appTypes", required=false) String appTypes, @RequestParam(value="mobileType", required=false) String mobileType) {
        Page page = (Page)this.pubPlatService.getPageList(searchKey, 1, Integer.MAX_VALUE, classifyID, appTypes).getData();
        List appList = page.getRecords();
        List extendList = this.sysEimApplicationExtendMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysEimApplicationExtend::getMobileAppType, Arrays.asList(mobileType.split(","))));
        ArrayList<WorkstationApplicationVo> resultList = new ArrayList<WorkstationApplicationVo>();
        for (WorkstationApplicationVo workstationApplicationVo : appList) {
            List extendList1 = extendList.stream().filter(a -> a.getAppId().equals(workstationApplicationVo.getId())).collect(Collectors.toList());
            if (!ToolUtil.isNotEmpty(extendList1)) continue;
            resultList.add(workstationApplicationVo);
        }
        Page resultPage = new Page();
        resultPage.setSize((long)pageSize);
        resultPage.setCurrent((long)pageNum);
        resultPage.setRecords(resultList.subList((pageNum - 1) * pageSize, Math.min(pageNum * pageSize, resultList.size())));
        resultPage.setTotal((long)resultList.size());
        return Result.succeed((Object)resultPage);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5217\u8868", notes="\u67e5\u8be2\u5e94\u7528\u5217\u8868")
    public ApiResponse<List<SysAppGroupVo>> getAppList(@ApiParam(value="\u5e94\u7528\u540d\u79f0") @RequestParam(required=false) String appName, @ApiParam(value="\u5e73\u53f0\u7c7b\u578b") @RequestParam String platform, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) List<String> appType) {
        return ApiResponse.success((Object)this.sysAppVisitAuthorizeService.getAppList(appName, platform, appType));
    }

    @GetMapping(value={"/getAppListWithExtend"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5217\u8868\u5e26\u6269\u5c55\u4fe1\u606f", notes="\u67e5\u8be2\u5e94\u7528\u5217\u8868\u5e26\u6269\u5c55\u4fe1\u606f")
    public ApiResponse<PageDTO<ApplicationExtendVo>> getAppListWithExtend(@ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser, @ApiParam(value="\u5e94\u7528\u540d\u79f0") @RequestParam(required=false) String appName, @ApiParam(value="\u5e73\u53f0\u7c7b\u578b") @RequestParam String platform, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) List<String> appType, @ApiParam(value="\u8bbe\u5907\u7c7b\u578b") @RequestParam(required=false) String deviceType, @ApiParam(value="\u5206\u9875\u53c2\u6570size") @RequestParam Integer size, @ApiParam(value="\u5206\u9875\u53c2\u6570current") @RequestParam Integer current) {
        return ApiResponse.success((Object)this.pubPlatService.getAppListWithExtend(appName, platform, appType, deviceType, size, current, currentLoginUser));
    }

    @GetMapping(value={"/getAppGroupListWithExtend"})
    @ApiOperation(value="\u67e5\u8be2\u5206\u7ec4\u5e94\u7528\u5217\u8868\u5e26\u6269\u5c55\u4fe1\u606f,\u63d0\u4f9b\u7ed9\u79fb\u52a8\u7aef\u7528\u7684", notes="\u67e5\u8be2\u5206\u7ec4\u5e94\u7528\u5217\u8868\u5e26\u6269\u5c55\u4fe1\u606f")
    public ApiResponse<List<SysAppExtendGroupVo>> getAppGroupListWithExtend(@ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser, @ApiParam(value="\u5e94\u7528\u540d\u79f0") @RequestParam(required=false) String appName, @ApiParam(value="\u5e73\u53f0\u7c7b\u578b") @RequestParam String platform, @ApiParam(value="\u5e94\u7528\u7c7b\u578b") @RequestParam(required=false) List<String> appType, @ApiParam(value="\u8bbe\u5907\u7c7b\u578b") @RequestParam(required=false) String deviceType) {
        return ApiResponse.success((Object)this.pubPlatService.getAppGroupListWithExtend(appName, platform, appType, deviceType));
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u8be6\u60c5")
    public ApiResponse<ApplicationExtendVo> getAppDetail(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId, @ApiParam(value="\u8bbe\u5907\u7c7b\u578b") @RequestParam(required=false) String deviceType, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        EimPubplatAttention eimPubplatAttention;
        List pubPlatMenuVOList;
        ApiResponse sysApplicationVoApiResponse = this.sysApplicationService.getNoAuthAppDetail(appId);
        SysApplicationVo source = (SysApplicationVo)sysApplicationVoApiResponse.getData();
        if (source == null) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        ApplicationExtendVo applicationExtendVo = new ApplicationExtendVo();
        BeanUtil.copyProperties((Object)source, (Object)applicationExtendVo);
        String appType = applicationExtendVo.getAppType();
        ApiResponse sysEimApplicationExtendVoApiResponse = this.eimApplicationExtendService.getApplicationExtendInfo(appId, appType);
        SysEimApplicationExtendVo sysEimApplicationExtendVo = (SysEimApplicationExtendVo)sysEimApplicationExtendVoApiResponse.getData();
        if (sysEimApplicationExtendVo != null) {
            BeanUtil.copyProperties((Object)sysEimApplicationExtendVo, (Object)applicationExtendVo);
            applicationExtendVo.setId(source.getId());
            applicationExtendVo.setExtendId(sysEimApplicationExtendVo.getId());
            String fileInfo = sysEimApplicationExtendVo.getFileInfo();
            if (StringUtil.isNotEmpty((Object)fileInfo)) {
                Integer fileType = null;
                if (DeviceType.ANDROID.name().equalsIgnoreCase(deviceType)) {
                    fileType = 0;
                } else if (DeviceType.IOS.name().equalsIgnoreCase(deviceType)) {
                    fileType = 1;
                } else if (DeviceType.PC.name().equalsIgnoreCase(deviceType)) {
                    fileType = 2;
                }
                JSONArray jsonArray = JSONArray.parseArray((String)fileInfo);
                if (CollectionUtil.isNotEmpty((Collection)jsonArray)) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        Integer thisFileType = jsonObject.getInteger("fileType");
                        if (!thisFileType.equals(fileType)) continue;
                        applicationExtendVo.setCodeFileId(jsonObject.getString("fileId"));
                    }
                }
            }
            if ("19".equals(applicationExtendVo.getAppType())) {
                applicationExtendVo.setAppType(sysEimApplicationExtendVo.getMobileAppType());
            }
            if (StringUtil.isNotEmpty((Object)deviceType)) {
                applicationExtendVo.setWebUrl(applicationExtendVo.getMobileUrl());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(pubPlatMenuVOList = this.pubPlatService.loadMenuTreeByPermission(appId.toString())))) {
            applicationExtendVo.setMenuList(pubPlatMenuVOList);
        }
        if (ToolUtil.isNotEmpty((Object)(eimPubplatAttention = this.eimPubplatAttentionService.getInfo(currentLoginUser.getId(), appId)))) {
            applicationExtendVo.setRemind(eimPubplatAttention.getIsRemind());
            applicationExtendVo.setTop(eimPubplatAttention.getIsTop());
        } else {
            applicationExtendVo.setTop(0);
            applicationExtendVo.setRemind(1);
        }
        return ApiResponse.success((Object)applicationExtendVo);
    }

    @GetMapping(value={"/remind"})
    @ApiOperation(value="\u5fae\u5e94\u7528\u6d88\u606f\u662f\u5426\u63d0\u9192 'J_PUB_0006'", notes="\u8bbe\u7f6e\u5fae\u5e94\u7528\u6d88\u606f\u662f\u5426\u63d0\u9192")
    public ApiResponse<Boolean> updateRemind(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId, @ApiParam(value="\u662f\u5426\u63d0\u9192") @RequestParam int remindFlag, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        EimPubplatAttention eimPubplatAttention = new EimPubplatAttention();
        eimPubplatAttention.setPubPlatId(appId);
        eimPubplatAttention.setIsRemind(remindFlag);
        eimPubplatAttention.setIsTop(0);
        eimPubplatAttention.setUserId(currentLoginUser.getId());
        eimPubplatAttention.setLastTime(LocalDateTime.now());
        eimPubplatAttention.setLastEditor(BaseSecurityUtil.getUser().getUserId());
        try {
            if (this.eimPubplatAttentionService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EimPubplatAttention::getPubPlatId, (Object)appId)).eq(EimPubplatAttention::getUserId, (Object)BaseSecurityUtil.getUser().getUserId())) > 1L) {
                this.eimPubplatAttentionService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EimPubplatAttention::getPubPlatId, (Object)appId)).eq(EimPubplatAttention::getUserId, (Object)BaseSecurityUtil.getUser().getUserId()));
            }
            this.eimPubplatAttentionService.saveOrUpdate((Object)eimPubplatAttention, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EimPubplatAttention::getPubPlatId, (Object)appId)).eq(EimPubplatAttention::getUserId, (Object)BaseSecurityUtil.getUser().getUserId()));
            this.pubPlatService.cleanPubPlatCache(currentLoginUser, appId.toString());
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.success((Object)false);
        }
    }

    @GetMapping(value={"/top"})
    @ApiOperation(value="\u5fae\u5e94\u7528\u6d88\u606f\u662f\u5426\u7f6e\u9876 'J_PUB_0010'", notes="\u8bbe\u7f6e\u5fae\u5e94\u7528\u7f6e\u9876")
    public ApiResponse<Boolean> updateTop(@ApiParam(value="\u5e94\u7528Id") @RequestParam Long appId, @ApiParam(value="\u662f\u5426\u7f6e\u9876") @RequestParam int topFlag, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        EimPubplatAttention eimPubplatAttention = new EimPubplatAttention();
        eimPubplatAttention.setPubPlatId(appId);
        eimPubplatAttention.setIsTop(topFlag);
        eimPubplatAttention.setIsRemind(1);
        eimPubplatAttention.setUserId(currentLoginUser.getId());
        eimPubplatAttention.setLastTime(LocalDateTime.now());
        eimPubplatAttention.setLastEditor(BaseSecurityUtil.getUser().getUserId());
        try {
            if (this.eimPubplatAttentionService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EimPubplatAttention::getPubPlatId, (Object)appId)).eq(EimPubplatAttention::getUserId, (Object)BaseSecurityUtil.getUser().getUserId())) > 1L) {
                this.eimPubplatAttentionService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EimPubplatAttention::getPubPlatId, (Object)appId)).eq(EimPubplatAttention::getUserId, (Object)BaseSecurityUtil.getUser().getUserId()));
            }
            this.eimPubplatAttentionService.saveOrUpdate((Object)eimPubplatAttention, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EimPubplatAttention::getPubPlatId, (Object)appId)).eq(EimPubplatAttention::getUserId, (Object)BaseSecurityUtil.getUser().getUserId()));
            this.pubPlatService.cleanPubPlatCache(currentLoginUser, appId.toString());
            return ApiResponse.success((Object)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.success((Object)false);
        }
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u83dc\u5355\u53d1\u6d88\u606f 'J_PUB_0011'")
    @PostMapping
    public Result<Boolean> getPubPlatMenuAutoReplyMessage(@RequestParam @ApiParam(value="\u7528\u6237id\u62fc\u63a5\u4e32") String userID, @RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID, @RequestParam @ApiParam(value="\u5fae\u5e94\u7528\u540d\u79f0") String pubPlatName, @RequestParam @ApiParam(value="\u83dc\u5355id\u62fc\u63a5\u4e32") String menuUrl, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return Result.succeed((Object)this.pubPlatService.pubMenuSendMsg(userID, pubPlatID, pubPlatName, menuUrl, currentLoginUser));
    }
}

