/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeLazyDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.RosterDO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.organization.ContactVO;
import com.jxdinfo.mp.common.utils.JqxSpringUtil;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.organization.dao.ContactMapper;
import com.jxdinfo.mp.organization.dao.SysUserJqxMapper;
import com.jxdinfo.mp.organization.dao.UserMapperJqx;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.LinkManService;
import com.jxdinfo.mp.organization.service.UserService;
import com.jxdinfo.mp.organization.util.InitialUtil;
import com.jxdinfo.mp.zone.commen.ApiConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ContactServiceImpl
implements ContactService {
    private static final Logger log = LoggerFactory.getLogger(ContactServiceImpl.class);
    @Resource
    public Environment environment;
    @Value(value="${mp.organization.departing-stru-id}")
    private String departingStruId;
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private LinkManService linkManService;
    @Resource
    private UserService userService;
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IHussarBaseStaffBoService staffBoService;
    @Resource
    private SysUserJqxMapper sysUserJqxMapper;
    @Resource
    private UserMapperJqx userMapperJqx;
    private static final long STRU_ID_PEIXUNXUEXIAO = 100071L;

    public Map<String, Object> getContactByOrgID(Long orgID) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Long> organList = new ArrayList<Long>();
        organList.add(orgID);
        List usersByOrganUser = this.hussarBaseUserBoService.getUsersByOrganUser(organList, null);
        List collect = usersByOrganUser.stream().map(UserVo::getId).collect(Collectors.toList());
        Map serviceUserInfo = this.hussarBaseUserBoService.getUserInfo(collect);
        Iterator iterator = serviceUserInfo.keySet().iterator();
        ArrayList sysUsers = new ArrayList();
        while (iterator.hasNext()) {
            sysUsers.add(serviceUserInfo.get(iterator.next()));
        }
        if (IMConstants.ORG_LEADER_ID.equals(orgID)) {
            if (usersByOrganUser != null && usersByOrganUser.size() > 2) {
                Collections.swap(usersByOrganUser, 1, 2);
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.apply("1=1", new Object[0]);
            PageInfo pageInfo = new PageInfo();
            pageInfo.setCurrent(0L);
            pageInfo.setSize(10L);
            ArrayList<Long> userList = new ArrayList<Long>();
            userList.add(0L);
            userList.add(1L);
            Map userInfo = this.hussarBaseUserBoService.getUserInfo(userList);
            if (HussarUtils.isNotEmpty((Object)userInfo)) {
                sysUsers.add(userInfo.get(0L));
                sysUsers.add(userInfo.get(1L));
            }
        }
        if (HussarUtils.isNotEmpty(sysUsers)) {
            resultMap.put("users", sysUsers);
        }
        List organizationsByParentId = this.organizationBoService.findOrganizationsByParentId(orgID);
        resultMap.put("orgs", organizationsByParentId);
        resultMap.put("orgsCount", organizationsByParentId.size());
        resultMap.put("membersCount", null);
        return resultMap;
    }

    public PageVO<ContactVO> getContactInfo(Long orgID, boolean needFriendState, Integer pageSize, Integer pageNum) {
        String isJxdCompany = this.environment.getProperty("mp.company.is_jxd_company", "0");
        long start = System.currentTimeMillis();
        PageVO pageVO = new PageVO();
        pageVO.setList(new ArrayList());
        pageVO.setPageNum(pageNum);
        pageVO.setPageSize(pageSize);
        ContactVO allContact = new ContactVO();
        allContact.setOrgs(new ArrayList());
        allContact.setUsers(new ArrayList());
        OrganTreeLazyDto organTreeLazyDto = new OrganTreeLazyDto();
        organTreeLazyDto.setResultType(Integer.valueOf(2));
        organTreeLazyDto.setNeedParentOrganInfo(Boolean.valueOf(true));
        organTreeLazyDto.setShowPartOrgan(Boolean.valueOf(false));
        organTreeLazyDto.setParentOrganId(orgID);
        List organUserTreeVoList = this.hussarBaseUserBoService.lazyOrganUserTreeFilter(organTreeLazyDto);
        OrganUserTreeVo parentOrgan = (OrganUserTreeVo)organUserTreeVoList.get(0);
        List children = parentOrgan.getChildren();
        System.out.println("\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u6811\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        if ("1".equals(isJxdCompany)) {
            List<Long> peixunXuexiaoIds = ContactServiceImpl.getPeixunXuexiaoIds(children);
            children = children.stream().filter(a -> !peixunXuexiaoIds.contains(a.getId())).collect(Collectors.toList());
            for (OrganUserTreeVo organUserTreeVo : children) {
                if (!"organ".equals(organUserTreeVo.getTypes())) continue;
                if (((Long)organUserTreeVo.getId()).equals(100071L)) {
                    organUserTreeVo.setUserCount(Integer.valueOf(this.contactMapper.getPersonInSchool()));
                    continue;
                }
                Integer userCount = organUserTreeVo.getUserCount();
                organUserTreeVo.setUserCount(userCount);
            }
        }
        int memberCount = parentOrgan.getUserCount();
        if (((Long)parentOrgan.getId()).equals(100071L)) {
            memberCount = this.contactMapper.getPersonInSchool();
        }
        int firstIndex = (pageNum - 1) * pageSize;
        int lastIndex = pageNum * pageSize;
        int pageCount = children.size();
        pageVO.setPageCount(Integer.valueOf(pageCount));
        if (pageCount <= firstIndex) {
            return pageVO;
        }
        if (pageCount < lastIndex) {
            lastIndex = pageCount;
        }
        List<OrganUserTreeVo> pagedChildren = children.subList(firstIndex, lastIndex);
        pagedChildren.forEach(treeVo -> {
            if ("organ".equals(treeVo.getTypes())) {
                if (!this.departingStruId.equals(((Long)treeVo.getId()).toString()) && treeVo.getUserCount() > 0) {
                    ContactVO contactVO = new ContactVO();
                    contactVO.setOrgID((Long)treeVo.getId());
                    contactVO.setOrgName(treeVo.getLabel());
                    contactVO.setParentOrgID((Long)treeVo.getParentId());
                    contactVO.setOrgsCount(Integer.valueOf(treeVo.getChildren().size()));
                    contactVO.setMembersCount(treeVo.getUserCount());
                    allContact.getOrgs().add(contactVO);
                }
            } else if ("user".equals(treeVo.getTypes())) {
                RosterVO rosterVO = new RosterVO();
                rosterVO.setUserId((Long)treeVo.getId());
                rosterVO.setUserName(treeVo.getLabel());
                rosterVO.setOrganiseID((Long)treeVo.getParentId());
                allContact.getUsers().add(rosterVO);
            }
        });
        List users = allContact.getUsers();
        List<Long> userIdList = users.stream().map(RosterVO::getUserId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(userIdList)) {
            if (Objects.equals(orgID, ApiConstants.DEFAULT_ROOT_DEPT_ID)) {
                memberCount = this.contactMapper.getTotalCount();
            }
            allContact.setMembersCount(Integer.valueOf(memberCount));
            pageVO.getList().add(allContact);
            System.out.println("\u52a0\u8f7d\u6240\u6709\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return pageVO;
        }
        Map userInfo = this.hussarBaseUserBoService.getUserInfo(userIdList);
        List<RosterVO> rosterVOList = this.userMapperJqx.getUserDetailList(userIdList);
        Map<Long, RosterVO> rosterVOMap = rosterVOList.stream().collect(Collectors.toMap(RosterVO::getUserId, rosterVO -> rosterVO, (v1, v2) -> v2));
        allContact.getUsers().forEach(user -> {
            SysUsers sysUsers = (SysUsers)userInfo.get(user.getUserId());
            RosterVO rosterVO = (RosterVO)rosterVOMap.get(user.getUserId());
            if (rosterVO != null && rosterVO.getTopManager() == 1) {
                user.setTopManager(rosterVO.getTopManager());
                user.setMobile(StringUtil.replaceSecretPhone((String)sysUsers.getMobile()));
                user.seteMail(StringUtil.replaceSecretPhone((String)sysUsers.geteMail()));
            } else {
                user.setMobile(sysUsers.getMobile());
                user.seteMail(sysUsers.geteMail());
            }
            if (rosterVO != null) {
                user.setHeadImgId(rosterVO.getHeadImgId());
                user.setModifyTime(rosterVO.getModifyTime());
            }
            user.setChar1(sysUsers.getChar1());
        });
        if (CollectionUtil.isNotEmpty((Collection)allContact.getOrgs())) {
            allContact.setUsers(null);
        }
        if (Objects.equals(orgID, ApiConstants.DEFAULT_ROOT_DEPT_ID)) {
            memberCount = this.contactMapper.getTotalCount();
        }
        System.out.println("\u90e8\u95e8\u603b\u4eba\u6570\uff0cmemberCount:" + memberCount);
        allContact.setMembersCount(Integer.valueOf(memberCount));
        pageVO.getList().add(allContact);
        return pageVO;
    }

    @NotNull
    private static List<Long> getPeixunXuexiaoIds(List<OrganUserTreeVo> organUserTreeVos) {
        ArrayList<Long> peixunXuexiaoIds = new ArrayList<Long>();
        organUserTreeVos.forEach(treeVo -> {
            String patternStr = "2099.*";
            Pattern pattern = Pattern.compile(patternStr);
            if ("user".equals(treeVo.getTypes())) {
                RosterVO rosterVO = new RosterVO();
                rosterVO.setUserId((Long)treeVo.getId());
                rosterVO.setOrganiseID((Long)treeVo.getParentId());
                if (pattern.matcher(rosterVO.getUserId().toString()).find() && rosterVO.getOrganiseID().equals(100071L)) {
                    peixunXuexiaoIds.add((Long)treeVo.getId());
                }
            }
        });
        return peixunXuexiaoIds;
    }

    public PageDTO searchContact(String searchKey, Long orgID, PageDTO pageDTO, Long currentUserID) {
        QueryUserDto queryUserDto = new QueryUserDto();
        queryUserDto.setDepStruId(orgID);
        PageDTO<RosterVO> rosterVOPageDTO = this.contactMapper.searchUser2(pageDTO, searchKey);
        HashMap rosterVOMap = new HashMap();
        rosterVOPageDTO.getRecords().forEach(rosterVO -> {
            RosterVO old = (RosterVO)rosterVOMap.get(rosterVO.getUserId());
            if (old == null) {
                rosterVOMap.put(rosterVO.getUserId(), rosterVO);
            } else {
                String struSeq = rosterVO.getStruSeq();
                String oldStruSeq = old.getStruSeq();
                if (StrUtil.isNotEmpty((CharSequence)struSeq) && StrUtil.isNotEmpty((CharSequence)oldStruSeq)) {
                    if (struSeq.compareTo(oldStruSeq) < 0) {
                        rosterVOMap.put(rosterVO.getUserId(), rosterVO);
                    }
                } else if (StrUtil.isEmpty((CharSequence)oldStruSeq)) {
                    rosterVOMap.put(rosterVO.getUserId(), rosterVO);
                }
            }
        });
        rosterVOPageDTO.setRecords(new ArrayList(rosterVOMap.values()));
        return rosterVOPageDTO;
    }

    public PageDTO<RosterVO> searchContactWithIsFriend(String userName, Long orgID, PageDTO<RosterVO> pageDTO, Long currentUserID) {
        List attentionRosterList = this.searchContact(userName, orgID, pageDTO, currentUserID).getList();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setSize(pageDTO.getSize());
        pageInfo.setCurrent(pageDTO.getCurrent());
        PageDTO linkManList = this.linkManService.getLinkManList(pageInfo, currentUserID);
        List eimUserList = linkManList.getRecords();
        List rosterVOList = BeanUtil.copyProperties((Collection)attentionRosterList, RosterVO.class);
        rosterVOList.forEach(rosterVO -> rosterVO.setFriends(Boolean.valueOf(eimUserList.stream().map(RosterVO::getUserId).collect(Collectors.toList()).contains(rosterVO.getUserId()))));
        pageDTO.setList(rosterVOList);
        return pageDTO;
    }

    public List<Long> getAllChildList(Long orgID) {
        List orgsList = this.organizationBoService.findOrganizationsByParentId(orgID);
        ArrayList<Long> orgIDList = new ArrayList<Long>();
        if (CollUtil.isNotEmpty((Collection)orgsList)) {
            orgsList.forEach(org -> orgIDList.add(org.getId()));
        }
        return orgIDList;
    }

    public List<Long> getAllParentList(Long orgID) {
        List orgsList = this.organizationBoService.findParentOrganizationsByOrganId(orgID);
        ArrayList<Long> orgIDList = new ArrayList<Long>();
        if (CollUtil.isNotEmpty((Collection)orgsList)) {
            orgsList.forEach(org -> orgIDList.add(org.getId()));
        }
        return orgIDList;
    }

    private List<Long> getAllID(Map<String, Object> map) {
        ArrayList<Long> result = new ArrayList<Long>();
        List mapList = new ArrayList<Map<String, Object>>();
        mapList.add(map);
        result.add((Long)map.get("orgID"));
        while (CollUtil.isNotEmpty(mapList) && CollUtil.isNotEmpty((Map)((Map)mapList.get(0)))) {
            if (!CollUtil.isNotEmpty(mapList = (List)((Map)mapList.get(0)).get("orgs")) || !CollUtil.isNotEmpty((Map)((Map)mapList.get(0)))) continue;
            result.add((Long)((Map)mapList.get(0)).get("orgID"));
        }
        return result;
    }

    public List<OrganizationTreeVo> getOrgTree(String isShow, String searchKey, Long parentOrgID, PageDTO<OrganizationTreeVo> pageDTO) {
        List organizationTreeVos = this.organizationBoService.lazyLoadOrganizationTree(parentOrgID, "");
        return organizationTreeVos;
    }

    public OrganizationBo getOrganise(Long orgID) {
        OrganizationBo organization = this.organizationBoService.findOrganizationById(orgID);
        return organization;
    }

    public List<UserStaffVo> getUserStaff(List<Long> userIds) {
        List staffInfo = this.staffBoService.findStaffsByUserIds(userIds);
        List staffIds = staffInfo.stream().map(StaffBo::getId).collect(Collectors.toList());
        Map staffBoMap = staffInfo.stream().collect(Collectors.toMap(StaffBo::getId, Function.identity()));
        List sysUsers = this.sysUserJqxMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, staffIds));
        ArrayList<UserStaffVo> userStaffVos = new ArrayList<UserStaffVo>();
        sysUsers.forEach(sysUsers1 -> {
            UserStaffVo linkManVo = new UserStaffVo();
            StaffBo staffBo = (StaffBo)staffBoMap.get(sysUsers1.getEmployeeId());
            BeanUtil.copyProperties((Object)staffBo, (Object)linkManVo);
            BeanUtil.copyProperties((Object)sysUsers1, (Object)linkManVo);
            linkManVo.setUserId(sysUsers1.getId());
            linkManVo.setChar1(sysUsers1.getChar1());
            userStaffVos.add(linkManVo);
        });
        Map<Long, Integer> rosterMap = this.userService.listByIds(userIds).stream().collect(Collectors.toMap(RosterDO::getUserID, RosterDO::getTopManager, (v1, v2) -> v1));
        if (HussarUtils.isNotEmpty(userStaffVos)) {
            userStaffVos.forEach(f -> {
                if (HussarUtils.isNotEmpty((Object)rosterMap) && 1 == (ToolUtil.isNotEmpty(rosterMap.get(f.getUserId())) ? (Integer)rosterMap.get(f.getUserId()) : 0)) {
                    f.setEmail(StringUtil.replaceSecretEmail((String)f.getEmail()));
                    f.setMobile(StringUtil.replaceSecretPhone((String)f.getMobile()));
                    f.setTelephone("****");
                }
            });
        }
        return userStaffVos;
    }

    public List<OrganizationBo> getAllOrgList() {
        ArrayList returnOrganizationList = new ArrayList();
        List organizationBoList = this.organizationBoService.findOrganizationsByParentId(IMConstants.DEFAULT_COMPANY_ID);
        return this.getAllChildOrgList(organizationBoList);
    }

    public List<RosterDO> getAllOrgUserNotInGroup(Long groupID, List<Long> struIdList) {
        return this.contactMapper.getAllOrgUserNotInGroup(groupID, struIdList);
    }

    private List<OrganizationBo> getAllChildOrgList(List<OrganizationBo> organizationBoList) {
        ArrayList<OrganizationBo> returnOrganizationList = new ArrayList<OrganizationBo>();
        returnOrganizationList.addAll(organizationBoList);
        List idList = organizationBoList.stream().map(OrganizationBo::getId).collect(Collectors.toList());
        List list = this.organizationBoService.findOrganizationsByParentsIds(idList);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            ArrayList<OrganizationBo> parentList = new ArrayList<OrganizationBo>();
            list.stream().map(parentList::addAll).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(parentList)) {
                returnOrganizationList.addAll(this.getAllChildOrgList(parentList));
            }
        }
        return returnOrganizationList;
    }

    public PageVO<UserStaffVo> searchUser(Long userID, String searchKey, List<Long> orgIDs, String roleIDs, String isShow, PageDTO pageDTO, Long objID) {
        PageInfo page = new PageInfo();
        page.setSize(pageDTO.getSize());
        page.setCurrent(page.getCurrent());
        String searchString = JqxSpringUtil.replaceSpecialChar((String)searchKey.trim());
        ArrayList userLists = new ArrayList();
        Page userListByCode = this.hussarBaseUserBoService.getUserList(page, null, searchString);
        Page userListByName = this.hussarBaseUserBoService.getUserList(page, searchString, null);
        userLists.addAll(userListByName.getRecords());
        userLists.addAll(userListByCode.getRecords());
        ArrayList<Long> userIds = new ArrayList<Long>();
        userLists.forEach(f -> {
            if (orgIDs.contains(f.getDepartmentId())) {
                userIds.add(f.getId());
            }
        });
        List<UserStaffVo> userStaffVos = this.getUserStaff(userIds);
        PageVO pageVO = new PageVO();
        BeanUtil.copyProperties((Object)pageDTO, (Object)pageVO);
        pageVO.setList(userStaffVos);
        return pageVO;
    }

    private void execute(Long userID, Long organiseID) {
    }

    public boolean generateInitials(String full) {
        QueryWrapper rosterWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)full)) {
            ((QueryWrapper)((QueryWrapper)rosterWrapper.isNull((Object)"CHAR_INDEX")).or()).eq((Object)"CHAR_INDEX", (Object)"");
        } else {
            ((QueryWrapper)((QueryWrapper)rosterWrapper.isNull((Object)"NAME_INDEX")).or()).eq((Object)"NAME_INDEX", (Object)"");
        }
        PageDTO page = new PageDTO();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(-1));
        List<RosterVO> rosterVOList = this.contactMapper.searchUser(page, (Wrapper)rosterWrapper).getList();
        List userIds = rosterVOList.stream().map(RosterVO::getUserId).collect(Collectors.toList());
        Map userInfo = this.hussarBaseUserBoService.getUserInfo(userIds);
        Collection sysUsers = userInfo.values();
        rosterVOList = rosterVOList.stream().peek(m -> sysUsers.stream().filter(s -> m.getUserId().equals(s.getId())).forEach(m1 -> m.setUserName(m1.getUserName()))).collect(Collectors.toList());
        ArrayList rosterDOList = new ArrayList();
        if (!rosterVOList.isEmpty()) {
            rosterVOList.forEach(rosterVO -> {
                RosterDO rosterDO = new RosterDO();
                rosterDO.setUserID(rosterVO.getUserId());
                if (StrUtil.isNotEmpty((CharSequence)full)) {
                    rosterDO.setCharIndex(InitialUtil.fullPinyin(rosterVO.getUserName()));
                } else {
                    rosterDO.setNameIndex(InitialUtil.generateInitials(rosterVO.getUserName()));
                }
                rosterDOList.add(rosterDO);
            });
        }
        if (!rosterDOList.isEmpty()) {
            this.userService.updateBatchById(rosterDOList);
        }
        return true;
    }

    public List<OrganizationBo> getNextContact(Long orgID) {
        return this.organizationBoService.findOrganizationsByParentId(orgID);
    }

    public List<UserStaffVo> searchContactByUserName(String userName, Long currentUserID) {
        if (HussarUtils.isNotEmpty((Object)userName)) {
            List<String> userNameList = Arrays.asList(userName.split("[,\uff0c]"));
            List sysUsers = this.sysUserJqxMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getUserName, userNameList));
            List<Long> userIds = sysUsers.stream().map(SysUsers::getId).collect(Collectors.toList());
            return this.getUserStaff(userIds);
        }
        return Collections.emptyList();
    }

    public PageDTO<RosterVO> getReceiver(Long msgID, PageDTO<RosterVO> pageDTO, String searchKey, String orgIDs, String roleIDs) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.apply("1=1", new Object[0])).eq((Object)"A.MSG_ID", (Object)msgID)).like(StrUtil.isNotEmpty((CharSequence)searchKey), (Object)"U.USER_NAME", (Object)StringUtil.replaceSpecialChar((String)searchKey));
        if (!StrUtil.isEmpty((CharSequence)orgIDs)) {
            List orgIDList = Arrays.stream(orgIDs.split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
            int i = 0;
            while (i < orgIDList.size()) {
                List<Long> childList = this.getAllChildList((Long)orgIDList.get(i));
                int finalI = i++;
                childList.removeIf(n -> n.equals(orgIDList.get(finalI)));
                orgIDList.addAll(childList);
            }
            wrapper.in((Object)"U.DEPARTMENT_ID ", orgIDList);
        }
        if (!StrUtil.isEmpty((CharSequence)roleIDs)) {
            wrapper.inSql((Object)"U.USER_ID", "SELECT USER_ID FROM EIM_ROLE_USER EO WHERE EO.ROLE_ID IN ('" + roleIDs.replace(",", "','") + "')");
        }
        return this.contactMapper.getReceiver(pageDTO, msgID, (Wrapper<RosterDO>)wrapper);
    }

    public PageDTO<RosterVO> getPermission(Long pubPlatID, String searchKey, PageDTO<RosterVO> pageDTO, String orgIDs, String roleIDs) {
        List<Long> orgIDList = this.contactMapper.getOrgIDList(pubPlatID);
        ArrayList childOrgIDs = new ArrayList();
        orgIDList.forEach(orgID -> childOrgIDs.addAll(this.getAllChildList((Long)orgID)));
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.apply("1=1", new Object[0])).and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)i.inSql((Object)"EU.USERID", "SELECT PU.OBJID FROM EIM_PUBPLAT_PERMISSION PU WHERE PU.PERMITTYPE='1' AND PU.BID='" + pubPlatID + "' ")).or()).in(!childOrgIDs.isEmpty(), (Object)"EU.ORGANISEID", (Collection)childOrgIDs)).or()).inSql((Object)"EU.USERID", "SELECT USER_ID FROM EIM_ROLE_USER WHERE ROLE_ID IN(SELECT PU.OBJID FROM EIM_PUBPLAT_PERMISSION PU WHERE PERMITTYPE='3' AND PU.BID='" + pubPlatID + "')");
        });
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.like((Object)"EU.USERNAME", (Object)StringUtil.replaceSpecialChar((String)searchKey));
            });
        }
        if (!StrUtil.isEmpty((CharSequence)orgIDs)) {
            List orgIDS = Arrays.stream(orgIDs.split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
            int i2 = 0;
            while (i2 < orgIDS.size()) {
                List<Long> childList = this.getAllChildList((Long)orgIDS.get(i2));
                int finalI = i2++;
                childList.removeIf(n -> n.equals(orgIDS.get(finalI)));
                orgIDS.addAll(childList);
            }
            wrapper.in((Object)"EU.ORGANISEID ", orgIDS);
        }
        if (!StrUtil.isEmpty((CharSequence)roleIDs)) {
            wrapper.inSql((Object)"EU.USERID", "SELECT USER_ID FROM EIM_ROLE_USER EO WHERE EO.ROLE_ID IN ('" + roleIDs.replace(",", "','") + "')");
        }
        return this.contactMapper.getUserIDList(pageDTO, (Wrapper)wrapper);
    }

    public PageVO<OrganVo> getAllContact() {
        PageVO pageVO = new PageVO();
        List allSubOrgan = this.organizationBoService.getAllSubOrgan(IMConstants.DEFAULT_COMPANY_ID);
        pageVO.setList(allSubOrgan);
        return pageVO;
    }
}

