/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.SysAppGroupCommonMapper;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eim.application.extend.model.SysEimApplicationExtend;
import com.jxdinfo.hussar.eim.application.extend.service.ISysEimApplicationExtendService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workstation.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeService;
import com.jxdinfo.hussar.workstation.application.service.ISysWorkstationAppService;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.application.vo.WorkstationApplicationVo;
import com.jxdinfo.mp.common.model.pubplat.PubPlatMenuVO;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.organization.dao.IMenuPermissionMapper;
import com.jxdinfo.mp.organization.dao.IPubPlatMapper;
import com.jxdinfo.mp.organization.dao.IPubPlatMenuMapper;
import com.jxdinfo.mp.organization.model.device.DeviceType;
import com.jxdinfo.mp.organization.model.menu.PubPlatMenuDO;
import com.jxdinfo.mp.organization.model.menu.PubPlatMenuDTO;
import com.jxdinfo.mp.organization.model.pubPlat.ApplicationExtendVo;
import com.jxdinfo.mp.organization.model.pubPlat.SysAppExtendGroupVo;
import com.jxdinfo.mp.organization.service.IPubPlatService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IPubPlatServiceImpl
implements IPubPlatService {
    private static final Logger log = LoggerFactory.getLogger(IPubPlatServiceImpl.class);
    @Resource
    private IPubPlatMenuMapper pubPlatMenuMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Resource
    private IHussarBaseUserService hussarBaseUserService;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysAppVisitAuthorizeService sysAppVisitAuthorizeService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysWorkstationAppService sysWorkstationAppService;
    @Resource
    private SysAppGroupCommonMapper sysAppGroupCommonMapper;
    @Resource
    private ISysAppCommonService sysAppCommonService;
    @Resource
    private ISysEimApplicationExtendService sysEimApplicationExtendService;
    @Resource
    private ISysAppVisitAuthorizationService sysAppVisitAuthorizationService;
    @Resource
    private ISysEimApplicationExtendService eimApplicationExtendService;
    @Resource
    private IMenuPermissionMapper iMenuPermissionMapper;
    @Resource
    private IPubPlatMapper pubPlatMapper;
    @Autowired
    Environment environment;
    @Resource
    private MessageProducerService messageProducerService;
    @Resource
    private MongoTemplate mongoTemplate;

    @Transactional
    public boolean powerPerson(String bID, List<Long> userIDs, List<Long> organiseIDs, List<Long> roleIDs, String flag) {
        ArrayList<Map<String, Long>> tempList;
        QueryWrapper menuWrapper = new QueryWrapper();
        menuWrapper.eq((Object)"B_ID", (Object)bID);
        this.iMenuPermissionMapper.delete((Wrapper)menuWrapper);
        if (ToolUtil.isNotEmpty(userIDs)) {
            List<String> userIDList = userIDs.stream().map(Object::toString).collect(Collectors.toList());
            tempList = new ArrayList<Map<String, Long>>();
            userIDList.forEach(userID -> {
                HashMap<String, Long> temp = new HashMap<String, Long>();
                temp.put("userId", Long.valueOf(userID));
                temp.put("permitId", IdWorker.getId(temp));
                tempList.add(temp);
            });
            this.pubPlatMenuMapper.powerViewPerson(tempList, bID, 1, LocalDateTime.now());
        }
        if (ToolUtil.isNotEmpty(organiseIDs)) {
            List<String> orgIDList = organiseIDs.stream().map(Object::toString).collect(Collectors.toList());
            tempList = new ArrayList();
            ArrayList<String> allIDS = new ArrayList<String>();
            orgIDList.forEach(orgID -> allIDS.addAll(this.hussarBaseOrganizationBoService.findOrganizationsByParentId(Long.valueOf(Long.parseLong(orgID))).stream().map(OrganizationBo::getId).map(String::valueOf).collect(Collectors.toList())));
            allIDS.addAll(orgIDList);
            allIDS.forEach(orgID -> {
                HashMap<String, Long> temp = new HashMap<String, Long>();
                temp.put("organiseId", Long.valueOf(orgID));
                temp.put("permitId", IdWorker.getId(temp));
                tempList.add(temp);
            });
            this.pubPlatMenuMapper.powerViewPerson(tempList, bID, 2, LocalDateTime.now());
        }
        if (ToolUtil.isNotEmpty(roleIDs)) {
            List<String> roleList = roleIDs.stream().map(Object::toString).collect(Collectors.toList());
            tempList = new ArrayList();
            roleList.forEach(roleID -> {
                HashMap<String, Long> temp = new HashMap<String, Long>();
                temp.put("roleId", Long.valueOf(roleID));
                temp.put("permitId", IdWorker.getId(temp));
                tempList.add(temp);
            });
            this.pubPlatMenuMapper.powerViewPerson(tempList, bID, 3, LocalDateTime.now());
        }
        return true;
    }

    public Map<String, List> getUsersByObjID(String objID, String authority) {
        HashMap<String, List> map = new HashMap<String, List>();
        List<Map<String, String>> iDs = this.pubPlatMenuMapper.getIDs(objID, authority);
        if (!iDs.isEmpty()) {
            List rosterVOList = new ArrayList();
            List userList = iDs.stream().filter(m -> String.valueOf(m.get("PERMIT_TYPE")).equals("1")).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(userList)) {
                List userIdList = userList.stream().map(m -> Long.parseLong(String.valueOf(m.get("OBJ_ID")))).distinct().collect(Collectors.toList());
                rosterVOList = (List)this.hussarBaseUserService.getUsersByUserIds(userIdList).getData();
            }
            ArrayList contactVOList = new ArrayList();
            List organList = iDs.stream().filter(m -> String.valueOf(m.get("PERMIT_TYPE")).equals("2")).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(organList)) {
                List organIdList = organList.stream().map(m -> Long.parseLong(String.valueOf(m.get("OBJ_ID")))).distinct().collect(Collectors.toList());
                int count = organList.size();
                int page = count / 50;
                if (count % 50 > 0) {
                    ++page;
                }
                for (int i = 0; i < page; ++i) {
                    int lastIndex = (i + 1) * 50 > count ? organIdList.size() : (i + 1) * 50;
                    List organPageIdList = organIdList.subList(i * 50, lastIndex);
                    contactVOList.addAll(this.hussarBaseOrganizationBoService.findOrganizationsByIds(organPageIdList));
                }
            }
            List<Object> roleList = new ArrayList();
            List roleMapList = iDs.stream().filter(m -> String.valueOf(m.get("PERMIT_TYPE")).equals("3")).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(iDs.stream().filter(m -> String.valueOf(m.get("PERMIT_TYPE")).equals("3")).collect(Collectors.toList()))) {
                List<Long> roleIdList = roleMapList.stream().map(m -> Long.parseLong(String.valueOf(m.get("OBJ_ID")))).distinct().collect(Collectors.toList());
                roleList = this.pubPlatMenuMapper.selectRoles(roleIdList);
            }
            if ("manage".equals(authority)) {
                map.put("user", rosterVOList);
            } else {
                map.put("user", rosterVOList);
                map.put("organise", contactVOList);
                map.put("role", roleList);
            }
        } else {
            map.put("role", this.pubPlatMenuMapper.selectRoles(Collections.singletonList(1450785135866925064L)));
        }
        return map;
    }

    public List<PubPlatMenuVO> loadMenuTree(String objID) {
        return this.pubPlatMenuMapper.loadMenuTree(objID);
    }

    public List<PubPlatMenuVO> loadMenuTreeByPermission(String objID) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List<Object> pubPlatMenuVOList = this.pubPlatMenuMapper.loadMenuTreeByPermission(objID, securityUser.getId(), securityUser.getDeptId(), securityUser.getRolesList());
        pubPlatMenuVOList = pubPlatMenuVOList.stream().collect(Collectors.toMap(PubPlatMenuVO::getMenuId, Function.identity(), (first, second) -> first, LinkedHashMap::new)).values().stream().collect(Collectors.toList());
        pubPlatMenuVOList.forEach(pubPlatMenuVO -> {
            List menuTypes = Arrays.stream(PubPlatMenuVO.MenuType.values()).filter(menuType -> menuType.ordinal() == pubPlatMenuVO.getMenuTypes().intValue()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(menuTypes)) {
                pubPlatMenuVO.setMenuType((PubPlatMenuVO.MenuType)menuTypes.get(0));
            }
        });
        List<PubPlatMenuVO> returnPubPlatMenuVoList = new ArrayList<PubPlatMenuVO>();
        if (CollectionUtil.isNotEmpty(pubPlatMenuVOList)) {
            Map<Long, PubPlatMenuVO> pubPlatMenuVOMap = pubPlatMenuVOList.stream().collect(Collectors.toMap(PubPlatMenuVO::getMenuId, pubPlatMenuVO -> pubPlatMenuVO, (v1, v2) -> v1));
            Map<Long, List<PubPlatMenuVO>> pubPlatMenuVOListMap = pubPlatMenuVOList.stream().collect(Collectors.groupingBy(PubPlatMenuVO::getParentMenuId));
            for (Long parentId : pubPlatMenuVOListMap.keySet()) {
                if (parentId.toString().equals(objID)) {
                    returnPubPlatMenuVoList = pubPlatMenuVOListMap.get(parentId);
                    continue;
                }
                PubPlatMenuVO pubPlatMenuVO2 = pubPlatMenuVOMap.get(parentId);
                if (pubPlatMenuVO2 == null) continue;
                pubPlatMenuVO2.setChild(pubPlatMenuVOListMap.get(parentId));
            }
        }
        return returnPubPlatMenuVoList;
    }

    public PageDTO<PubPlatMenuVO> selectMenuList(String objID, String menuName, String parentMenuID, int pageIndex, int pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)i.apply("1=1", new Object[0]);
        });
        if (!StrUtil.isEmpty((CharSequence)menuName)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.like((Object)"T.MENU_NAME", (Object)StringUtil.replaceSpecialChar((String)menuName));
            });
        }
        if (!StrUtil.isEmpty((CharSequence)objID)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"T.PUBPLAT_ID", (Object)objID);
            });
        }
        if (!StrUtil.isEmpty((CharSequence)parentMenuID)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"T.PARENT_MENU_ID", (Object)parentMenuID);
            });
        }
        wrapper.last("ORDER BY T.SHOW_ORDER");
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageIndex));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        this.pubPlatMenuMapper.selectMenuList(pageDTO, (Wrapper)wrapper);
        return pageDTO;
    }

    public Result<Boolean> saveMenu(PubPlatMenuDTO pubPlatMenuDTO) {
        PubPlatMenuDO platMenuDO = new PubPlatMenuDO();
        BeanUtil.copyProperties((Object)pubPlatMenuDTO, (Object)platMenuDO);
        platMenuDO.setMenuId(String.valueOf(IdWorker.getId((Object)pubPlatMenuDTO)));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"SHOW_ORDER", (Object)pubPlatMenuDTO.getShowOrder());
        if (this.pubPlatMenuMapper.selectCount((Wrapper)wrapper) > 0L) {
            return Result.succeed((Object)false, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5c55\u793a\u987a\u5e8f");
        }
        platMenuDO.setCreateTime(LocalDateTime.now());
        platMenuDO.setCreator(BaseSecurityUtil.getUser().getUserId());
        this.pubPlatMenuMapper.insert(platMenuDO);
        return Result.succeed((Object)true);
    }

    public Result<Boolean> editMenu(PubPlatMenuDO pubPlatMenuDO) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"SHOW_ORDER", (Object)pubPlatMenuDO.getShowOrder())).ne((Object)"MENU_ID", (Object)pubPlatMenuDO.getMenuId())).eq((Object)"PUBPLAT_ID", (Object)pubPlatMenuDO.getPubPlatId());
        if (this.pubPlatMenuMapper.selectCount((Wrapper)wrapper) > 0L) {
            return Result.succeed((Object)false, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5c55\u793a\u987a\u5e8f");
        }
        this.pubPlatMenuMapper.updateById(pubPlatMenuDO);
        return Result.succeed((Object)true);
    }

    public boolean deleteMenus(String menuID) {
        ArrayList allMenuIDs = new ArrayList();
        ArrayList menuVOS = new ArrayList();
        QueryWrapper wrapper = new QueryWrapper();
        List<String> menuIDList = Arrays.asList(menuID.split(","));
        menuIDList.forEach(menuId -> {
            menuVOS.addAll(this.selectMenuList("", "", (String)menuId, 1, -1).getList());
            allMenuIDs.add(menuId);
        });
        menuVOS.forEach(pubPlatMenuVO -> allMenuIDs.add(pubPlatMenuVO.getMenuId().toString()));
        wrapper.in((Object)"MENU_ID", allMenuIDs);
        this.pubPlatMenuMapper.delete((Wrapper)wrapper);
        return true;
    }

    public PageDTO<Map<String, Object>> queryPubMsgPush(PageDTO pageDTO, String searchKey, int mode) {
        Result<Page<WorkstationApplicationVo>> appList = this.getPageList(null, 1, Integer.MAX_VALUE, null, "8,19");
        List<String> pubplatIds = ((Page)appList.getData()).getRecords().stream().map(SysApplication::getId).map(String::valueOf).collect(Collectors.toList());
        List<Object> results = new ArrayList();
        long totalCount = 0L;
        if (mode == 1) {
            results = this.queryMongoMessages(pubplatIds, searchKey, pageDTO.getPageNum(), pageDTO.getPageSize());
            totalCount = this.getMongoMessagesCount(pubplatIds, searchKey);
        } else if (mode == 2) {
            results = this.queryUnpushedMessages(pubplatIds, searchKey, pageDTO.getPageNum(), pageDTO.getPageSize());
            totalCount = this.getUnpushedMessagesCount(pubplatIds, searchKey);
        }
        pageDTO.setList(results);
        pageDTO.setTotal((long)((int)totalCount));
        return pageDTO;
    }

    private List<Map<String, Object>> queryMongoMessages(List<String> pubplatIds, String searchKey, int pageNum, int pageSize) {
        Criteria criteria = new Criteria();
        criteria.and("receiverCode").in(pubplatIds);
        criteria.and("mode").is((Object)2);
        criteria.and("msgType").ne((Object)9);
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            String pattern = StringUtil.replaceSpecialChar((String)searchKey);
            Pattern regex = Pattern.compile(pattern, 2);
            criteria.orOperator(new Criteria[]{Criteria.where((String)"body").regex(regex), Criteria.where((String)"senderName").regex(regex), Criteria.where((String)"receiverName").regex(regex)});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"msgTime"}), Aggregation.group((String[])new String[]{"msgID"}).first("$$ROOT").as("doc"), Aggregation.replaceRoot((String)"doc"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"msgTime"}), Aggregation.skip((long)((long)(pageNum - 1) * (long)pageSize)), Aggregation.limit((long)pageSize)}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build());
        List messages = this.mongoTemplate.aggregate(aggregation, "message", MessageDO.class).getMappedResults();
        return messages.stream().map(msg -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("msgID", msg.getMsgID());
            map.put("TITLE", msg.getBody());
            map.put("MSG_BODY", this.buildMsgBody((MessageDO)msg));
            map.put("MSG_TYPE", msg.getMsgType());
            map.put("SEND_TIME", new Date(msg.getMsgTime()));
            map.put("APP_NAME", msg.getReceiverName());
            map.put("MODE", 2);
            map.put("STATE", 1);
            map.put("CREATE_TIME", new Date(msg.getMsgTime()));
            map.put("MATERIAL_ID", msg.getMsgID());
            return map;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> queryUnpushedMessages(List<String> pubplatIds, String searchKey, int pageNum, int pageSize) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pubplatIds", pubplatIds);
        params.put("searchKey", searchKey);
        params.put("state", 2);
        params.put("pageNum", pageNum);
        params.put("pageSize", pageSize);
        params.put("offset", (pageNum - 1) * pageSize);
        return this.pubPlatMapper.queryUnpushedMsgLogs(params);
    }

    private long getMongoMessagesCount(List<String> pubplatIds, String searchKey) {
        Aggregation aggregation;
        List results;
        Criteria criteria = new Criteria();
        criteria.and("receiverCode").in(pubplatIds);
        criteria.and("mode").is((Object)2);
        criteria.and("msgType").ne((Object)9);
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            String pattern = StringUtil.replaceSpecialChar((String)searchKey);
            Pattern regex = Pattern.compile(pattern, 2);
            criteria.orOperator(new Criteria[]{Criteria.where((String)"body").regex(regex), Criteria.where((String)"senderName").regex(regex), Criteria.where((String)"receiverName").regex(regex)});
        }
        return (results = this.mongoTemplate.aggregate(aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"msgID"}), Aggregation.count().as("total")}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build()), "message", Map.class).getMappedResults()).isEmpty() ? 0L : ((Number)((Map)results.get(0)).get("total")).longValue();
    }

    private long getUnpushedMessagesCount(List<String> pubplatIds, String searchKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pubplatIds", pubplatIds);
        params.put("searchKey", searchKey);
        params.put("state", 2);
        return this.pubPlatMapper.queryUnpushedMsgLogsCount(params);
    }

    private Date convertToDate(Object timeObj) {
        if (timeObj == null) {
            return null;
        }
        if (timeObj instanceof Date) {
            return (Date)timeObj;
        }
        if (timeObj instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)timeObj;
            return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (timeObj instanceof String) {
            try {
                return DateUtil.parse((CharSequence)((String)timeObj));
            }
            catch (Exception e) {
                log.warn("Failed to parse date string: {}", timeObj);
                return null;
            }
        }
        return null;
    }

    private String buildMsgBody(MessageDO msg) {
        switch (msg.getMsgType()) {
            case 1: 
            case 3: {
                return msg.getBody();
            }
        }
        return StrUtil.isNotBlank((CharSequence)msg.getBody()) ? msg.getBody() : "\u65e0\u5185\u5bb9";
    }

    public Result<Page<String>> getReceiver(int pageNum, int pageSize, String searchKey, String msgID, String pubPlatID, String orgIDs, String roleIDs) {
        RosterVO stateAndTime = this.pubPlatMapper.getState(msgID);
        String isFull = "";
        Page<String> page = new Page<String>();
        page.setSize((long)pageSize);
        page.setCurrent((long)pageNum);
        page = this.pubPlatMapper.getPubUserIDs(Long.valueOf(msgID), page);
        return Result.succeed(page);
    }

    public Result<Page<WorkstationApplicationVo>> getPageList(String searchKey, int pageNum, int pageSize, String classifyID, String appTypes) {
        List appList = this.sysApplicationService.getManageAppList(null, searchKey, ToolUtil.isNotEmpty((Object)appTypes) ? Arrays.asList(appTypes.split(",")) : null);
        ArrayList list = new ArrayList();
        for (SysAppGroupVo sysAppGroupVo : appList) {
            list.addAll(sysAppGroupVo.getSysApplicationList());
        }
        ArrayList sysWorkstationAppVO = new ArrayList();
        list.forEach(f -> {
            WorkstationApplicationVo workstationAppVO = new WorkstationApplicationVo();
            BeanUtil.copyProperties((Object)f, (Object)workstationAppVO);
            sysWorkstationAppVO.add(workstationAppVO);
        });
        Set longList = list.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
        if (HussarUtils.isNotEmpty(longList)) {
            List sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, longList));
            for (WorkstationApplicationVo workstationAppVO : sysWorkstationAppVO) {
                sysAppGroups.forEach(f -> {
                    if (f.getId().equals(workstationAppVO.getAppGroupId())) {
                        workstationAppVO.setGroupName(f.getGroupName());
                    }
                });
            }
        }
        Page workstationAppVOPage = new Page();
        workstationAppVOPage.setSize((long)pageSize);
        workstationAppVOPage.setCurrent((long)pageNum);
        workstationAppVOPage.setRecords(sysWorkstationAppVO.subList((pageNum - 1) * pageSize, Math.min(pageNum * pageSize, sysWorkstationAppVO.size())));
        workstationAppVOPage.setTotal((long)sysWorkstationAppVO.size());
        return Result.succeed((Object)workstationAppVOPage);
    }

    public void cleanPubPlatCache(CurrentLoginUser currentLoginUser, String pubPlatID) {
        String key1 = "PubPlat:" + pubPlatID;
        if (ToolUtil.isNotEmpty((Object)currentLoginUser.getMobileClient()) && ToolUtil.isNotEmpty((Object)currentLoginUser.getMobileClient().getDeviceTag())) {
            String key2 = "pubList:" + BaseSecurityUtil.getUser().getUserId() + ":" + currentLoginUser.getMobileClient().getDeviceTag();
            this.del(key1, key2);
        } else {
            this.del(key1);
        }
    }

    public void del(String ... key) {
        if (!StrUtil.hasEmpty((CharSequence[])key)) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pubMenuSendMsg(String userId, String pubPlatId, String pubPlatName, String menuUrl, CurrentLoginUser currentLoginUser) {
        String servicePath = this.environment.getProperty("mp.multi-tenant.OUT_NET_URL");
        String menuID = "'" + menuUrl.replace(",", "','") + "'";
        DefaultIdentifierGenerator defaultIdentifierGenerator = new DefaultIdentifierGenerator();
        if ("'02E4E4A8-5FF6-4357-87BB-BC8151C146F6'".equals(menuID)) {
            BaseMsgBean msgBean = null;
            boolean sendFlag = true;
            String strResult = "";
            CloseableHttpClient client = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost("http://oa.jxdinfo.com:9999/report/services");
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            ArrayList<BasicNameValuePair> paramPairs = new ArrayList<BasicNameValuePair>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("json", "{\"businessID\":\"J_OA_REPORT_0047\"}");
            Set keySet = map.keySet();
            for (String key : keySet) {
                Object val = map.get(key);
                paramPairs.add(new BasicNameValuePair(key, val.toString()));
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramPairs, "UTF-8");
                System.out.println("\u5c01\u88c5\u7684\u53c2\u6570\uff1a" + entity);
                httpPost.setEntity((HttpEntity)entity);
                CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
                HttpEntity respEntity = resp.getEntity();
                strResult = EntityUtils.toString((HttpEntity)respEntity, (String)"UTF-8");
                msgBean = new BaseMsgBean();
                msgBean.setMsgID(defaultIdentifierGenerator.nextId((Object)msgBean).toString());
                msgBean.setBody(this.getReportBody(strResult));
                msgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
                msgBean.setMsgTime(DateUtil.now());
                msgBean.setMsgType(BaseMsgBean.MsgType.TEXT);
                msgBean.setCompName(currentLoginUser.getTenantName());
                msgBean.setCompID(ToolUtil.isNotEmpty((Object)currentLoginUser.getTenantId()) ? currentLoginUser.getTenantId().toString() : "0");
                msgBean.setReceiverCode(pubPlatId);
                msgBean.setReceiverName(pubPlatName);
                msgBean.setPubplatReceiverCode(currentLoginUser.getId().toString());
                msgBean.setSenderCode("admin");
                msgBean.setSenderName("\u7cfb\u7edf");
                msgBean.setResource("system");
                msgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
            }
            catch (IOException e) {
                sendFlag = false;
                e.printStackTrace();
            }
            finally {
                try {
                    client.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (sendFlag) {
                this.sendMessage(msgBean, userId);
            }
            return true;
        }
        List<Map> menuAutoMsgList = this.pubPlatMapper.getMenuAutoMsgList(menuID);
        if (menuAutoMsgList.size() > 0) {
            for (Map o : menuAutoMsgList) {
                String fileSize;
                String saveName;
                String fileName;
                String fileId;
                String msgType = o.get("msgType").toString();
                String objId = o.get("libraryId").toString();
                String msgBody = o.get("msgBody").toString();
                if ((BaseMsgBean.MsgType.TEXT.ordinal() + "").equals(msgType)) {
                    BaseMsgBean msgBean = new BaseMsgBean();
                    msgBean.setMsgID(defaultIdentifierGenerator.nextId((Object)msgBean).toString());
                    msgBean.setBody(msgBody);
                    msgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
                    msgBean.setMsgTime(DateUtil.now());
                    msgBean.setMsgType(BaseMsgBean.MsgType.TEXT);
                    msgBean.setCompName(currentLoginUser.getTenantName());
                    msgBean.setCompID(ToolUtil.isNotEmpty((Object)currentLoginUser.getTenantId()) ? currentLoginUser.getTenantId().toString() : "0");
                    msgBean.setReceiverCode(pubPlatId);
                    msgBean.setReceiverName(pubPlatName);
                    msgBean.setSenderCode("admin");
                    msgBean.setSenderName("\u7cfb\u7edf");
                    msgBean.setResource("system");
                    msgBean.setPubplatReceiverCode(currentLoginUser.getId().toString());
                    msgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
                    this.sendMessage(msgBean, userId);
                    continue;
                }
                if ((BaseMsgBean.MsgType.ARTICLES.ordinal() + "").equals(msgType)) {
                    List<Map> articleList = this.pubPlatMapper.getArticlesByMsgId(objId);
                    String firstTitle = articleList.get(0).get("title") + "";
                    ArrayList<ArticleBean> articleBeanList = new ArrayList<ArticleBean>();
                    if (articleList.size() <= 0) continue;
                    for (int j = 0; j < articleList.size(); ++j) {
                        String subTitle = articleList.get(j).get("subTitle") + "";
                        String title = articleList.get(j).get("title") + "";
                        String url = articleList.get(j).get("url") + "";
                        String bid = articleList.get(j).get("bid") + "";
                        ArticleBean articleBean = new ArticleBean();
                        articleBean.setFileID(String.valueOf(defaultIdentifierGenerator.nextId((Object)articleBean)));
                        articleBean.setSubTitle(subTitle);
                        articleBean.setShowOrder(j + 1 + "");
                        articleBean.setTitle(title);
                        articleBean.setUrl(url);
                        if (!url.contains(servicePath)) {
                            articleBean.setUrl(url);
                        } else {
                            articleBean.setBid(bid);
                        }
                        articleBean.setLinkType(ArticleBean.LinkType.WEB);
                        articleBeanList.add(articleBean);
                    }
                    ArticleMsgBean articleMsgBean = new ArticleMsgBean();
                    articleMsgBean.setArticles(articleBeanList);
                    articleMsgBean.setMsgID(defaultIdentifierGenerator.nextId((Object)articleMsgBean).toString());
                    articleMsgBean.setBody(firstTitle);
                    articleMsgBean.setCompName(currentLoginUser.getTenantName());
                    articleMsgBean.setCompID(currentLoginUser.getTenantId() == null ? "0" : currentLoginUser.getTenantId().toString());
                    articleMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
                    articleMsgBean.setMsgTime(DateUtil.now());
                    articleMsgBean.setMsgType(BaseMsgBean.MsgType.ARTICLES);
                    articleMsgBean.setReceiverCode(pubPlatId);
                    articleMsgBean.setReceiverName(pubPlatName);
                    articleMsgBean.setPubplatReceiverCode(currentLoginUser.getId().toString());
                    articleMsgBean.setSenderCode("admin");
                    articleMsgBean.setSenderName("\u7cfb\u7edf");
                    articleMsgBean.setResource("system");
                    articleMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
                    this.sendMessage((BaseMsgBean)articleMsgBean, userId);
                    continue;
                }
                if ((BaseMsgBean.MsgType.IMAGE.ordinal() + "").equals(msgType)) {
                    fileId = o.get("fileID").toString();
                    List<Map> imageList = this.pubPlatMapper.getImageByMsgId(fileId);
                    fileName = imageList.get(0).get("fileName") + "";
                    saveName = imageList.get(0).get("fileID") + "";
                    fileSize = imageList.get(0).get("fileSize") + "";
                    String width = imageList.get(0).get("width") + "";
                    String height = imageList.get(0).get("height") + "";
                    String msgId = IdUtil.randomUUID().toUpperCase();
                    ImgMsgBean imgMsgBean = new ImgMsgBean();
                    imgMsgBean.setFileName(fileName);
                    imgMsgBean.setFileID(saveName);
                    imgMsgBean.setFileSize(fileSize);
                    imgMsgBean.setWidth(Integer.parseInt(width));
                    imgMsgBean.setHeight(Integer.parseInt(height));
                    imgMsgBean.setMsgID(defaultIdentifierGenerator.nextId((Object)imgMsgBean).toString());
                    imgMsgBean.setBody(fileName);
                    imgMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
                    imgMsgBean.setCompName(currentLoginUser.getTenantName());
                    imgMsgBean.setCompID(ToolUtil.isNotEmpty((Object)currentLoginUser.getTenantId()) ? currentLoginUser.getTenantId().toString() : "0");
                    imgMsgBean.setMsgTime(DateUtil.now());
                    imgMsgBean.setMsgType(BaseMsgBean.MsgType.IMAGE);
                    imgMsgBean.setReceiverCode(pubPlatId);
                    imgMsgBean.setReceiverName(pubPlatName);
                    imgMsgBean.setPubplatReceiverCode(currentLoginUser.getId().toString());
                    imgMsgBean.setSenderCode("admin");
                    imgMsgBean.setSenderName("\u7cfb\u7edf");
                    imgMsgBean.setResource("system");
                    imgMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
                    this.sendMessage((BaseMsgBean)imgMsgBean, userId);
                    continue;
                }
                if (!(BaseMsgBean.MsgType.FILETYPE.ordinal() + "").equals(msgType)) continue;
                fileId = o.get("fileID").toString();
                List<Map> fileList = this.pubPlatMapper.getImageByMsgId(fileId);
                fileName = fileList.get(0).get("fileName") + "";
                saveName = fileList.get(0).get("fileID") + "";
                fileSize = fileList.get(0).get("fileSize") + "";
                String fileType = fileList.get(0).get("fileType") + "";
                String msgId = IdUtil.randomUUID().toUpperCase();
                FileMsgBean fileMsgBean = new FileMsgBean();
                fileMsgBean.setFileName(fileName);
                fileMsgBean.setFileID(saveName);
                fileMsgBean.setFileSize(Float.valueOf(fileSize).floatValue());
                fileMsgBean.setFileStatus(FileMsgBean.FileStatus.UPLOADING);
                fileMsgBean.setMd5("");
                fileMsgBean.setMsgID(defaultIdentifierGenerator.nextId((Object)fileMsgBean).toString());
                fileMsgBean.setCompName(currentLoginUser.getTenantName());
                fileMsgBean.setCompID(ToolUtil.isNotEmpty((Object)currentLoginUser.getTenantId()) ? currentLoginUser.getTenantId().toString() : "0");
                fileMsgBean.setBody(fileName);
                fileMsgBean.setMode(BaseMsgBean.Mode.PUBPLAT);
                fileMsgBean.setMsgTime(DateUtil.now());
                fileMsgBean.setMsgType(BaseMsgBean.MsgType.FILETYPE);
                fileMsgBean.setReceiverCode(pubPlatId);
                fileMsgBean.setReceiverName(pubPlatName);
                fileMsgBean.setPubplatReceiverCode(currentLoginUser.getId().toString());
                fileMsgBean.setSenderCode("admin");
                fileMsgBean.setSenderName("\u7cfb\u7edf");
                fileMsgBean.setResource("system");
                fileMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
                this.sendMessage((BaseMsgBean)fileMsgBean, userId);
            }
        }
        return true;
    }

    private String getReportBody(String result) {
        JSONObject json = JSONObject.parseObject((String)result);
        Boolean success = json.getBoolean("success");
        if (success.booleanValue()) {
            String tag = json.getString("tag");
            StringBuilder reportStr = new StringBuilder(tag);
            reportStr.append("\u671f").append("\n");
            JSONArray data = json.getJSONArray("data");
            if (data != null && data.size() > 0) {
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject report = data.getJSONObject(i);
                    reportStr.append(report.getString("userName")).append("\uff1a\u5468\u62a5").append(" ").append(report.getInteger("reportNumber")).append(" \u7bc7\uff0c").append(report.getInteger("reportTime")).append(" \u5206\u949f\uff1b\u89c1\u89e3 ").append(report.getInteger("optionNumber")).append(" \u7bc7\uff0c").append(report.getInteger("optionTime")).append("\u5206\u949f").append("\n");
                }
            } else {
                reportStr.append("\u6682\u65e0\u7edf\u8ba1\u6570\u636e");
            }
            return reportStr.toString();
        }
        return "\u7edf\u8ba1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    }

    private boolean sendMessage(BaseMsgBean msgBean, String userId) {
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        pushMessageDTO.setBaseMsgBean(msgBean);
        pushMessageDTO.setMode(BaseMsgBean.Mode.PUBPLAT);
        pushMessageDTO.setReceiverIds(userId);
        pushMessageDTO.setMsgType(msgBean.getMsgType());
        return this.messageProducerService.sendMessage(pushMessageDTO);
    }

    public PageDTO<ApplicationExtendVo> getAppListWithExtend(String appName, String platform, List<String> appType, String deviceType, Integer size, Integer current, CurrentLoginUser currentLoginUser) {
        List appGroupVoList = this.sysAppVisitAuthorizeService.getAppList(appName, platform, appType);
        PageDTO page = new PageDTO();
        page.setSize((long)size.intValue());
        page.setCurrent((long)current.intValue());
        if (CollectionUtil.isEmpty((Collection)appGroupVoList)) {
            return page;
        }
        ArrayList applicationExtendVoList = new ArrayList();
        for (SysAppGroupVo sysAppGroupVo : appGroupVoList) {
            List tempList = BeanUtil.copyProperties((Collection)sysAppGroupVo.getSysApplicationList(), ApplicationExtendVo.class);
            applicationExtendVoList.addAll(tempList);
        }
        List extendList = this.eimApplicationExtendService.list((Wrapper)new LambdaQueryWrapper().in(SysEimApplicationExtend::getAppId, (Collection)applicationExtendVoList.stream().map(SysApplication::getId).collect(Collectors.toList())));
        applicationExtendVoList.forEach(f -> {
            f.setAppType("15");
            List tempList = extendList.stream().filter(a -> a.getAppId().equals(f.getId())).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(tempList)) {
                SysEimApplicationExtend extendVo = (SysEimApplicationExtend)tempList.get(0);
                BeanUtil.copyProperties((Object)extendVo, (Object)f);
                f.setId(extendVo.getAppId());
                f.setExtendId(extendVo.getId());
                if ("1".equals(platform)) {
                    f.setAppType(extendVo.getWebAppType());
                } else if ("2".equals(platform)) {
                    f.setAppType(extendVo.getMobileAppType());
                    f.setWebUrl(f.getMobileUrl());
                }
                String fileInfo = extendVo.getFileInfo();
                if (ToolUtil.isNotEmpty((Object)fileInfo)) {
                    Integer fileType = null;
                    if (DeviceType.ANDROID.name().equalsIgnoreCase(deviceType)) {
                        fileType = 0;
                    } else if (DeviceType.IOS.name().equalsIgnoreCase(deviceType)) {
                        fileType = 1;
                    } else if (DeviceType.PC.name().equalsIgnoreCase(deviceType)) {
                        fileType = 2;
                    }
                    JSONArray jsonArray = JSONArray.parseArray((String)fileInfo);
                    if (CollectionUtil.isNotEmpty((Collection)jsonArray)) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            Integer thisFileType = jsonObject.getInteger("fileType");
                            if (!thisFileType.equals(fileType)) continue;
                            f.setCodeFileId(jsonObject.getString("fileId"));
                        }
                    }
                }
            }
        });
        page.setTotal((long)applicationExtendVoList.size());
        page.setList(applicationExtendVoList.subList((current - 1) * size, Math.min(current * size, applicationExtendVoList.size())));
        return page;
    }

    public List<SysAppExtendGroupVo> getAppGroupListWithExtend(String appName, String platform, List<String> appType, String deviceType) {
        List appGroupVoList = this.sysAppVisitAuthorizeService.getAppList(appName, platform, appType);
        List appExtendGroupVoList = BeanUtil.copyProperties((Collection)appGroupVoList, SysAppExtendGroupVo.class);
        for (Object sysAppExtendGroupVo : appExtendGroupVoList) {
            List tempList = appGroupVoList.stream().filter(arg_0 -> IPubPlatServiceImpl.lambda$getAppGroupListWithExtend$27((SysAppExtendGroupVo)sysAppExtendGroupVo, arg_0)).collect(Collectors.toList());
            if (!ToolUtil.isNotEmpty(tempList)) continue;
            sysAppExtendGroupVo.setSysApplicationList(BeanUtil.copyProperties((Collection)((SysAppGroupVo)tempList.get(0)).getSysApplicationList(), ApplicationExtendVo.class));
        }
        ArrayList voList = new ArrayList();
        appGroupVoList = appGroupVoList.stream().filter(sysAppGroupVo -> CollectionUtil.isNotEmpty((Collection)sysAppGroupVo.getSysApplicationList())).collect(Collectors.toList());
        for (SysAppGroupVo sysAppGroupVo2 : appGroupVoList) {
            voList.addAll(sysAppGroupVo2.getSysApplicationList());
        }
        if (CollectionUtil.isEmpty(voList)) {
            return new ArrayList<SysAppExtendGroupVo>();
        }
        List extendList = this.eimApplicationExtendService.list((Wrapper)new LambdaQueryWrapper().in(SysEimApplicationExtend::getAppId, (Collection)voList.stream().map(SysApplication::getId).collect(Collectors.toList())));
        for (SysAppExtendGroupVo sysAppExtendGroupVo : appExtendGroupVoList) {
            for (ApplicationExtendVo applicationExtendVo : sysAppExtendGroupVo.getSysApplicationList()) {
                JSONArray jsonArray;
                String fileInfo;
                applicationExtendVo.setAppType("15");
                List tempList = extendList.stream().filter(a -> a.getAppId().equals(applicationExtendVo.getId())).collect(Collectors.toList());
                if (!ToolUtil.isNotEmpty(tempList)) continue;
                SysEimApplicationExtend extendVo = (SysEimApplicationExtend)tempList.get(0);
                BeanUtil.copyProperties((Object)extendVo, (Object)applicationExtendVo);
                applicationExtendVo.setId(extendVo.getAppId());
                applicationExtendVo.setExtendId(extendVo.getId());
                if ("1".equals(platform)) {
                    applicationExtendVo.setAppType(extendVo.getWebAppType());
                } else if ("2".equals(platform)) {
                    applicationExtendVo.setAppType(extendVo.getMobileAppType());
                    applicationExtendVo.setWebUrl(applicationExtendVo.getMobileUrl());
                }
                if (!ToolUtil.isNotEmpty((Object)(fileInfo = extendVo.getFileInfo()))) continue;
                Integer fileType = null;
                if (DeviceType.ANDROID.name().equalsIgnoreCase(deviceType)) {
                    fileType = 0;
                } else if (DeviceType.IOS.name().equalsIgnoreCase(deviceType)) {
                    fileType = 1;
                } else if (DeviceType.PC.name().equalsIgnoreCase(deviceType) || DeviceType.WEB.name().equalsIgnoreCase(deviceType)) {
                    fileType = 2;
                }
                if (!CollectionUtil.isNotEmpty((Collection)(jsonArray = JSONArray.parseArray((String)fileInfo)))) continue;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    Integer thisFileType = jsonObject.getInteger("fileType");
                    if (!thisFileType.equals(fileType)) continue;
                    applicationExtendVo.setCodeFileId(jsonObject.getString("fileId"));
                }
            }
        }
        return appExtendGroupVoList;
    }

    private static /* synthetic */ boolean lambda$getAppGroupListWithExtend$27(SysAppExtendGroupVo sysAppExtendGroupVo, SysAppGroupVo a) {
        return a.getId().equals(sysAppExtendGroupVo.getId());
    }
}

