/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.im.service.IIMService;
import com.jxdinfo.mp.organization.dao.LinkManMapper;
import com.jxdinfo.mp.organization.service.ClearCacheService;
import com.jxdinfo.mp.organization.service.UserCacheService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ClearCacheServiceImpl
implements ClearCacheService {
    @Resource
    private LinkManMapper linkManMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private IIMService imService;
    @Resource
    private UserCacheService userCacheService;

    public void clearCacheByUserID(Long userID) {
        ArrayList<String> keys = new ArrayList<String>();
        Long orgID = this.linkManMapper.getLinkManInfoByUserID(userID).getOrganiseID();
        if (orgID == null) {
            String key = "organise:" + BaseSecurityUtil.getUser().getTenantId();
            keys.add(key);
        } else {
            String key = "organise:" + orgID;
            keys.add(key);
        }
        this.imService.cleanGroupCache(userID);
        this.redisTemplate.delete(keys);
    }

    public void clearDeptCache(Long orgID, Long parentOrgID) {
        String key1 = "organise:" + orgID;
        if (parentOrgID == null) {
            String key2 = "organise:" + BaseSecurityUtil.getUser().getTenantId();
            this.userCacheService.delete(key2);
        } else {
            String key2 = "organise:" + parentOrgID;
            this.userCacheService.delete(key2);
        }
        this.userCacheService.delete(key1);
    }

    public void clearPubPlatCache(Long pubplatID) {
        String key1 = "pubList:";
        if (pubplatID != null) {
            if (pubplatID != 0L) {
                String key2 = "PubPlat:" + pubplatID;
                this.userCacheService.delete(key2);
            } else {
                String key2 = "PubPlat:";
                this.userCacheService.delete(key2);
            }
        }
        this.userCacheService.delete(key1);
    }
}

