/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.unifiedtodo.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class TodoMessagePushStartupValidator
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(TodoMessagePushStartupValidator.class);
    private static final String[][] METHODS_TO_VALIDATE = new String[][]{{"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "saveTask"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "updateTask"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "deleteTask"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "updateTaskStatus"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "updateUserStatus"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "updateTaskUser"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "addTaskUser"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "deleteTaskUser"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "addUrgeTask"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "transferUserTask"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "updateTaskStatusWithOutFollowers"}, {"com.jxdinfo.hussar.unifiedtodo.controller.UnifiedToDoExternalController", "transferTaskDeleteTaskUser"}};

    public void onApplicationEvent(ApplicationReadyEvent event) {
        log.info("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u5f00\u59cb\u6821\u9a8cAOP\u5207\u70b9\u65b9\u6cd5...");
        ArrayList<String> missingMethods = new ArrayList<String>();
        for (String[] methodInfo : METHODS_TO_VALIDATE) {
            String className = methodInfo[0];
            String methodName = methodInfo[1];
            if (this.validateMethod(className, methodName)) continue;
            missingMethods.add(className + "." + methodName);
        }
        if (!missingMethods.isEmpty()) {
            String errorMessage = String.format("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] AOP\u5207\u70b9\u6821\u9a8c\u5931\u8d25\uff01\u4ee5\u4e0b\u65b9\u6cd5\u4e0d\u5b58\u5728\uff1a%s\u3002\u8bf7\u68c0\u67e5TodoMessagePushAspect\u4e2d\u7684@Pointcut\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", String.join((CharSequence)", ", missingMethods));
            log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        log.info("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] AOP\u5207\u70b9\u65b9\u6cd5\u6821\u9a8c\u901a\u8fc7\uff0c\u5171\u6821\u9a8c{}\u4e2a\u65b9\u6cd5", (Object)METHODS_TO_VALIDATE.length);
    }

    private boolean validateMethod(String className, String methodName) {
        try {
            Method[] methods;
            Class<?> clazz = Class.forName(className);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                log.debug("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u65b9\u6cd5\u6821\u9a8c\u901a\u8fc7: {}.{}", (Object)className, (Object)methodName);
                return true;
            }
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u65b9\u6cd5\u4e0d\u5b58\u5728: {}.{}", (Object)className, (Object)methodName);
            return false;
        }
        catch (ClassNotFoundException e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u7c7b\u4e0d\u5b58\u5728: {}", (Object)className);
            return false;
        }
        catch (Exception e) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u63a8\u9001] \u6821\u9a8c\u65b9\u6cd5\u65f6\u53d1\u751f\u5f02\u5e38: {}.{}, \u5f02\u5e38: {}", new Object[]{className, methodName, e.getMessage()});
            return false;
        }
    }
}

