/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.mp.common.annotation.MethodHandler;
import com.jxdinfo.mp.im.anontion.MessageType;
import com.jxdinfo.mp.im.handler.MessageHandler;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.AutoReplyMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.LocationMsgBean;
import com.jxdinfo.mp.im.model.MeetingMsgBean;
import com.jxdinfo.mp.im.model.MentionMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.ProblemBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.im.model.VCardMsgBean;
import com.jxdinfo.mp.im.model.VoiceMsgBean;
import com.jxdinfo.mp.im.model.WithDrawMsgBean;
import com.jxdinfo.mp.im.model.single.MessageArticleDO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.MessageFileDO;
import com.jxdinfo.mp.im.model.single.ProblemAutoReplyDO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@MethodHandler
@Component
public class MessageHandleServiceImpl
extends MessageHandler {
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    public Environment environment;

    @MessageType(msgType=BaseMsgBean.MsgType.TEXT)
    public TextMsgBean handleTextMsgBean(MessageDO messageDO) {
        return new TextMsgBean();
    }

    @MessageType(msgType=BaseMsgBean.MsgType.IMAGE)
    public ImgMsgBean handleImgMsgBean(MessageDO messageDO) {
        ImgMsgBean imgMsgBean = new ImgMsgBean();
        MessageFileDO messageFileDO = this.getMessageFileDO(messageDO);
        if (messageFileDO != null) {
            BeanUtils.copyProperties((Object)messageFileDO, (Object)imgMsgBean);
            imgMsgBean.setFileStatus(ImgMsgBean.FileStatus.values()[messageFileDO.getFileStatus()]);
        }
        return imgMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.AUDIO)
    public VoiceMsgBean handleAudioMsgBean(MessageDO messageDO) {
        VoiceMsgBean voiceMsgBean = new VoiceMsgBean();
        MessageFileDO messageFileDO = this.getMessageFileDO(messageDO);
        if (messageFileDO != null) {
            BeanUtils.copyProperties((Object)messageFileDO, (Object)voiceMsgBean);
            voiceMsgBean.setFileSize(String.valueOf(messageFileDO.getFileSize()));
            voiceMsgBean.setFileStatus(VoiceMsgBean.FileStatus.values()[messageFileDO.getFileStatus()]);
        }
        return voiceMsgBean;
    }

    @Nullable
    private MessageFileDO getMessageFileDO(MessageDO messageDO) {
        MessageFileDO eimMessageFile = (MessageFileDO)HussarCacheUtil.get((String)"eim_cache", (Object)("eim_message_file:" + messageDO.getMsgID()));
        if (eimMessageFile != null) {
            return eimMessageFile;
        }
        MessageFileDO messageFileDO = (MessageFileDO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)Long.parseLong(messageDO.getMsgID()))), MessageFileDO.class);
        if (messageFileDO == null) {
            System.out.println("eim_message_file\u7f13\u5b58\u4e2d\u6ca1\u6709\u627e\u5230\u6d88\u606f\u6587\u4ef6\u4fe1\u606f");
            return null;
        }
        Integer property = (Integer)this.environment.getProperty("mp.im.sync_message_days", Integer.class, (Object)7);
        HussarCacheUtil.put((String)"eim_cache", (Object)("eim_message_file:" + messageDO.getMsgID()), (Object)messageFileDO, (long)(86400L * (long)property.intValue()));
        return messageFileDO;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.FILETYPE)
    public FileMsgBean handleFileMsgBean(MessageDO messageDO) {
        FileMsgBean fileMsgBean = new FileMsgBean();
        MessageFileDO messageFileDO = this.getMessageFileDO(messageDO);
        if (messageFileDO != null) {
            BeanUtils.copyProperties((Object)messageFileDO, (Object)fileMsgBean);
            fileMsgBean.setFileType(FileMsgBean.FileType.values()[messageFileDO.getFileType()]);
            fileMsgBean.setFileStatus(FileMsgBean.FileStatus.values()[messageFileDO.getFileStatus()]);
        }
        return fileMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.NOTICE)
    public NoticeMsgBean handleNoticeMsgBean(MessageDO messageDO) {
        NoticeMsgBean noticeMsgBean = new NoticeMsgBean();
        noticeMsgBean.setValue(messageDO.getValue());
        noticeMsgBean.setEventType(NoticeMsgBean.EventType.values()[messageDO.getEventType()]);
        return noticeMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.ARTICLES)
    public ArticleMsgBean handleArticleMsgBean(MessageDO messageDO) {
        ArticleMsgBean articleMsgBean = new ArticleMsgBean();
        List articles = this.mongoTemplate.find(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"articleMsgId").is((Object)messageDO.getMsgID())})).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"showOrder")})), MessageArticleDO.class);
        ArrayList articleBeans = CollUtil.newArrayList((Object[])new ArticleBean[0]);
        articles.forEach(article -> {
            ArticleBean articleBean = new ArticleBean();
            articleBean.setObjID(article.getObjID() == null ? null : String.valueOf(article.getObjID()));
            articleBean.setArticleMsgId(article.getArticleMsgId());
            articleBean.setBid(article.getBid() == null ? null : String.valueOf(article.getBid()));
            articleBean.setFileID(article.getFileID() == null ? null : String.valueOf(article.getFileID()));
            Integer linkType = article.getLinkType();
            articleBean.setLinkType(linkType == null ? null : ArticleBean.LinkType.values()[linkType]);
            articleBean.setShowOrder(article.getShowOrder().toString());
            articleBean.setSubTitle(article.getSubTitle());
            articleBean.setTitle(article.getTitle());
            articleBean.setUrl(article.getUrl());
            articleBeans.add(articleBean);
        });
        articleMsgBean.setArticles((List)articleBeans);
        return articleMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.WITHDRAW)
    public WithDrawMsgBean handleWithDrawMsgBean(MessageDO messageDO) {
        WithDrawMsgBean withDrawMsgBean = new WithDrawMsgBean();
        BeanUtils.copyProperties((Object)messageDO, (Object)withDrawMsgBean);
        withDrawMsgBean.setMsgType(BaseMsgBean.MsgType.values()[messageDO.getMsgType()]);
        return withDrawMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.MENTION)
    public MentionMsgBean handleMentionMsgBean(MessageDO messageDO) {
        MentionMsgBean mentionMsgBean = new MentionMsgBean();
        mentionMsgBean.setMentionId(messageDO.getMentionId());
        return mentionMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.VCARD)
    public VCardMsgBean handleVCardMsgBean(MessageDO messageDO) {
        VCardMsgBean vCardMsgBean = new VCardMsgBean();
        BeanUtils.copyProperties((Object)messageDO, (Object)vCardMsgBean);
        return vCardMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.LOCATION)
    public LocationMsgBean handleLocationMsgBean(MessageDO messageDO) {
        LocationMsgBean locationMsgBean = new LocationMsgBean();
        BeanUtils.copyProperties((Object)messageDO, (Object)locationMsgBean);
        locationMsgBean.setThumbnailId(Long.valueOf(Long.parseLong(messageDO.getMsgID())));
        return locationMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.MEETING)
    public MeetingMsgBean handleMeetingMsgBean(MessageDO messageDO) {
        MeetingMsgBean meetingMsgBean = new MeetingMsgBean();
        BeanUtils.copyProperties((Object)messageDO, (Object)meetingMsgBean);
        meetingMsgBean.setMeetingType(MeetingMsgBean.MeetingType.values()[messageDO.getMeetingType()]);
        return meetingMsgBean;
    }

    @MessageType(msgType=BaseMsgBean.MsgType.AUTOREPLY)
    public AutoReplyMsgBean handleAutoReplyMsgBean(MessageDO messageDO) {
        AutoReplyMsgBean autoReplyMsgBean = new AutoReplyMsgBean();
        BeanUtils.copyProperties((Object)messageDO, (Object)autoReplyMsgBean);
        List problemAutoReplyDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"autoReplyMsgId").is((Object)messageDO.getMsgID())), ProblemAutoReplyDO.class);
        ArrayList problemBeans = new ArrayList();
        problemAutoReplyDOList.forEach(problemAutoReplyDO -> {
            ProblemBean problemBean = new ProblemBean();
            BeanUtils.copyProperties((Object)problemAutoReplyDO, (Object)problemBean);
            problemBeans.add(problemBean);
        });
        autoReplyMsgBean.setProblems(problemBeans);
        return autoReplyMsgBean;
    }
}

