/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.im.dao.group.GroupMapper;
import com.jxdinfo.mp.im.service.GroupCacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GroupCacheServiceImpl
implements GroupCacheService {
    @Resource
    private GroupMapper groupMapper;
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;

    public GroupVO getRoomBean(Long roomID) {
        List users;
        List ids;
        String key = "ApiGroupChat:" + roomID;
        GroupVO groupVO = (GroupVO)HussarCacheUtil.get((String)"eim_cache", (Object)key);
        if (groupVO == null) {
            groupVO = this.groupMapper.getGroupByRoomID(roomID);
            List<RosterVO> userList = groupVO.getGroupType() == 1 ? this.groupMapper.getAllDeptUserByRoomID(roomID) : this.groupMapper.getAllUserByRoomID(roomID);
            if (userList.isEmpty()) {
                userList = new ArrayList<RosterVO>();
            }
            groupVO.setUsers(userList);
            groupVO.setUserCount(userList.size());
            System.out.println("\u5411redis\u4e2d\u4fdd\u5b58\u7fa4\u6210\u5458\u4fe1\u606f\uff1akey\u4e3a" + key);
            HussarCacheUtil.put((String)"eim_cache", (Object)key, (Object)groupVO);
        }
        if (HussarUtils.isEmpty((Object)groupVO.getSenderID())) {
            groupVO.setSenderID(groupVO.getAdminID());
        }
        if (ToolUtil.isNotEmpty((Object)(ids = this.hussarBaseOrganizationBoService.getSimpleOrganByIds((users = groupVO.getUsers()).stream().map(RosterVO::getOrganiseID).distinct().collect(Collectors.toList()))))) {
            for (RosterVO user : users) {
                List temp = ids.stream().filter(a -> a.getId().equals(String.valueOf(user.getOrganiseID()))).collect(Collectors.toList());
                if (!ToolUtil.isNotEmpty(temp)) continue;
                user.setOrganiseName(((OrganVo)temp.get(0)).getLabel());
            }
        }
        return groupVO;
    }

    public List<RosterVO> getAllRosterBeanByRoomID(Long roomID) {
        return this.getRoomBean(roomID).getUsers();
    }

    public PageVO<RosterVO> getGroupUserList(PageVO<RosterVO> pageVO, Long roomID, List<Long> excludeUserList, String searchKey) {
        List<Object> rosterBeanList = this.getAllRosterBeanByRoomID(roomID);
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            rosterBeanList = rosterBeanList.stream().filter(r -> r.getUserName().contains(searchKey) || String.valueOf(r.getUserId()).contains(searchKey)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(excludeUserList)) {
            rosterBeanList = rosterBeanList.stream().filter(r -> !excludeUserList.contains(r.getUserId())).collect(Collectors.toList());
        }
        int start = (pageVO.getPageNum() - 1) * pageVO.getPageSize();
        int end = pageVO.getPageNum() * pageVO.getPageSize();
        pageVO.setPageCount(Integer.valueOf(rosterBeanList.size()));
        if (start > rosterBeanList.size()) {
            return pageVO;
        }
        if (end >= rosterBeanList.size()) {
            pageVO.setList(rosterBeanList.subList(start, rosterBeanList.size()));
        } else {
            pageVO.setList(rosterBeanList.subList(start, end));
        }
        return pageVO;
    }

    public List<RosterVO> getRosterBeanByAmount(Long roomID, int number) {
        List<RosterVO> rosterBeanList = this.getAllRosterBeanByRoomID(roomID);
        if (rosterBeanList.size() <= number) {
            return rosterBeanList;
        }
        return rosterBeanList.subList(0, number);
    }

    public void clearRoomCache(Long roomID) {
        String key1 = "OfGroupChat:" + roomID;
        String key2 = "ApiGroupChat:" + roomID;
        this.delete(key1);
        this.delete(key2);
    }

    public void clearGroupChatCache(List<Long> roomIDs) {
        ArrayList<String> keys = new ArrayList<String>();
        if (roomIDs != null) {
            for (Long roomID : roomIDs) {
                String key = "OfGroupChat:" + roomID;
                keys.add(key);
                String key1 = "ApiGroupChat:" + roomID;
                keys.add(key1);
                this.delete(key1);
                this.delete(key);
            }
        }
    }

    public void delete(String key) {
        HussarCacheUtil.evict((String)"eim_cache", (Object)key);
    }
}

