/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.mp.im.dao.single.PubMsgLogMapper;
import com.jxdinfo.mp.im.model.material.MaterialDTO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDTO;
import com.jxdinfo.mp.im.service.MaterialService;
import com.jxdinfo.mp.im.service.PubPlatMessageService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PubPlatMsgJobHandler
implements BasicProcessor {
    @Resource
    private PubPlatMessageService pubPlatMessageService;
    @Resource
    private MaterialService materialService;
    @Resource
    private PubMsgLogMapper pubMsgLogMapper;
    @Resource
    private JobServiceService jobServiceService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        String jobParams = taskContext.getJobParams();
        ArrayList paramList = CollUtil.toList((Object[])jobParams.split("@"));
        MaterialDTO materialDTO = this.materialService.getMaterial(Long.valueOf((String)paramList.get(2))).getMaterialDTO();
        List<String> userIDS = this.pubMsgLogMapper.getPubUserIDs(Long.valueOf((String)paramList.get(3)));
        userIDS = userIDS.stream().distinct().collect(Collectors.toList());
        PubMsgLogDTO pubMsgLogDTO = new PubMsgLogDTO();
        pubMsgLogDTO.setPubPlatID(Long.valueOf((String)paramList.get(0)));
        pubMsgLogDTO.setPubPlatName((String)paramList.get(1));
        pubMsgLogDTO.setUserIDs(userIDS.toString().substring(1, userIDS.toString().length() - 1));
        pubMsgLogDTO.setMaterialDTO(materialDTO);
        PubMsgLogDO pubMsgLogDO = new PubMsgLogDO();
        pubMsgLogDO.setObjID(Long.valueOf((String)paramList.get(3)));
        pubMsgLogDO.setState(Convert.toInt((Object)this.pubPlatMessageService.sendPubMsg(pubMsgLogDTO).getData()));
        this.pubMsgLogMapper.updateById(pubMsgLogDO);
        this.jobServiceService.deleteJobApi(taskContext.getJobId());
        return new ProcessResult(true, "success");
    }
}

