/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.mp.common.config.OrganizationProperties;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.LocationMsgBean;
import com.jxdinfo.mp.im.model.MeetingMsgBean;
import com.jxdinfo.mp.im.model.VCardMsgBean;
import com.jxdinfo.mp.im.model.VoiceMsgBean;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5916\u90e8\u670d\u52a1\u53d1\u6d88\u606f\u63a5\u53e3"})
public class WebServiceController {
    private static final Logger log = LoggerFactory.getLogger(WebServiceController.class);
    @Resource
    private Environment environment;
    @Resource
    private OrganizationProperties organizationProperties;
    @Resource
    IHussarBaseStaffBoService hussarBaseStaffBoService;
    @Resource
    IOrganizationBoService organizationBoService;
    @Resource
    MessageProducerService messageProducerService;

    @PostMapping(value={"/v1/service/sendMessge"})
    public JSONObject sendMessage(@RequestParam(value="type") @ApiParam(value="\u6d88\u606f\u7c7b\u578b") String msgType, @RequestParam(value="msg") @ApiParam(value="\u6d88\u606f\u5185\u5bb9") String msg, @RequestParam(value="userId") @ApiParam(value="\u7528\u6237id") String userId) throws UnsupportedEncodingException {
        JSONObject resultJson = new JSONObject();
        this.writerFileContent("\u53d1\u9001\u6d88\u606f\u5f00\u59cb");
        if (StrUtil.isEmpty((CharSequence)msg)) {
            resultJson.put("success", (Object)"false");
            resultJson.put("error", (Object)"msg\u4e0d\u80fd\u4e3a\u7a7a\u53c2\u6570");
        }
        this.writerFileContent("\u53d1\u9001\u6d88\u606f----" + msg + "----\u8fdb\u884c\u4e2d");
        BaseMsgBean baseMsgBean = (BaseMsgBean.MsgType.IMAGE.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, ImgMsgBean.class) : ((BaseMsgBean.MsgType.AUDIO.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, VoiceMsgBean.class) : ((BaseMsgBean.MsgType.FILETYPE.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, FileMsgBean.class) : ((BaseMsgBean.MsgType.VCARD.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, VCardMsgBean.class) : ((BaseMsgBean.MsgType.ARTICLES.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, ArticleMsgBean.class) : ((BaseMsgBean.MsgType.LOCATION.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, LocationMsgBean.class) : ((BaseMsgBean.MsgType.MEETING.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, MeetingMsgBean.class) : (BaseMsgBean)JSON.parseObject((String)msg, BaseMsgBean.class)))))));
        String mode = baseMsgBean.getMode().ordinal() + "";
        if (HussarUtils.isEmpty((Object)baseMsgBean.getCompID())) {
            baseMsgBean.setCompID(this.organizationProperties.getDefaultCompanyId().toString());
            baseMsgBean.setCompName("\u91d1\u73b0\u4ee3\u4fe1\u606f\u4ea7\u4e1a\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        }
        if (mode.equals(BaseMsgBean.Mode.PUBPLAT.ordinal() + "")) {
            baseMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
            baseMsgBean.setSenderName("\u7cfb\u7edf");
            baseMsgBean.setResource("system");
        }
        StaffBo staffBo = this.hussarBaseStaffBoService.findStaffByStaffId(Long.valueOf(Long.parseLong(baseMsgBean.getSenderCode())));
        SysUsers sysUsers = this.organizationBoService.userDetail(Long.valueOf(Long.parseLong(baseMsgBean.getReceiverCode())));
        baseMsgBean.setReceiverName(sysUsers.getUserName());
        baseMsgBean.setSenderName(staffBo.getStaffName());
        baseMsgBean.setMsgType(BaseMsgBean.MsgType.values()[Integer.parseInt(msgType)]);
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        pushMessageDTO.setBaseMsgBean(baseMsgBean);
        pushMessageDTO.setReceiverIds("@all".equals(URLDecoder.decode(userId, "utf-8")) ? "" : userId);
        pushMessageDTO.setMsgType(baseMsgBean.getMsgType());
        pushMessageDTO.setMode(baseMsgBean.getMode());
        resultJson.put("success", (Object)this.messageProducerService.sendMessage(pushMessageDTO));
        this.writerFileContent("\u53d1\u9001\u6d88\u606f\u7ed3\u675f");
        return resultJson;
    }

    private void writerFileContent(String newContent) {
        File file = new File(this.environment.getProperty("thumbnail_url") + "/logs/sendMessLog.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileWriter fileWriter = new FileWriter(file, true);){
                fileWriter.write(DateUtil.now() + ":" + newContent + "\r\n");
            }
        }
        catch (IOException e) {
            log.debug(e.getMessage());
        }
    }
}

